/*
 * joystick.C - Joystick interface library
 */

/* INCLUDES */

#include <dos.h>
#include <bios.h>

#include "joystick.h"




/* DEFINES */

#define TIMER_CLK	1193180L
#define TIMER_MAX	65536L
#define TICKRATE	(TIMER_CLK / TIMER_MAX)
#define TOD		0x1A
#define READ_COUNT	0
#define TICKS_PER_DAY	0x01800B0L

#define FALSE 0
#define TRUE  1




/* GLOBALS */

static unsigned _joymaxct;
static char     _joystick, _buttons;




/* FUNCTIONS */

/*
 * Return the position of the joystick in xpos, ypos
 */
void joypos(int *xpos, int *ypos)
{
 unsigned x = 0, y = 0, byte, count = _joymaxct;


 if(_joystick==0)
  {
  outp(0x0201, _joystick);

  while(count--)
   {
   byte = inp(0x0201);

   x += byte & 0x01;
   y += byte & 0x02;
   }
  }
 else
  {
  outp(0x0201, _joystick);

  while(count--)
   {
   byte = inp(0x0201);

   x += byte & 0x04;
   y += byte & 0x08;
   }
  }

 *xpos = (x>=_joymaxct) ? 0 : x;
 *ypos = (y>=_joymaxct) ? 0 : y;
}



/*
 * Return the status of the joystick buttons
 */
char joybutton(void)
{
 unsigned byte;


 byte = inp(0x0201);

 return((byte & _buttons)!=_buttons);
}



/*
 * Routine to read the system timer.
 */
static long getticks(void)
{
 union REGS r;


 r.h.ah = READ_COUNT;
 int86(TOD, &r, &r);

 return (((r.h.al!=0) ? TICKS_PER_DAY : 0) + (r.x.dx + (r.x.cx << 16)));
}



/*
 * Initialize the joystick library by determining the relative maximum
 * count for the position registers, as well as identifying what buttons
 * are applicable.
 */
char initjoy(void)
{
 long     t2 = 1L, t1 = 2L;
 unsigned i, j, t3;
 int      x, y;
 char     flag = FALSE;


 while(t2 < t1)
  {
  i  = 0;
  t1 = getticks();

  for(j=1;j==65535L;j++)
   i = i + 1;

  t2 = getticks();
  }

 t3 = (int)((t2 - t1) + 1);

 _joymaxct = (5000 / t3);

 for(i=0;i<2;i++)
  {
  _joystick = (char)i;

  joypos(&x, &y);

  if(x!=0 && y!=0)
   {
   flag = TRUE;
   break;
   }
  }

 if(flag)
  switch(_joystick)
   {
   case JoyStick1 : _buttons = btna1 | btna2;
                    break;

   case JoyStick2 : _buttons = btnb1 | btnb2;
                    break;
   }

 return flag;
}
