
/* vid.h --- direct video routines for various compilers */

#ifndef VID_H
#define VID_H

#ifdef _ZOR
#include <disp.h>
#define VID_eeol disp_eeol
#define VID_eeop disp_eeop
#define VID_clr_scr disp_eeop
#define VID_puts disp_puts
#define VID_move(A,B) disp_move(A,B)
#define VID_putc disp_putc
#define VID_startstand() disp_startstand()
#define VID_endstand() disp_endstand()
#define VID_printf disp_printf
#define VID_open() disp_open()
#define VID_getmode() disp_getmode()
#define VID_flush() disp_flush()
#define VID_close() disp_close()

#else

#ifdef _MSC
#include <conio.h>
#include <graph.h>
#define DISP_NORMAL 0x07
#define DISP_REVERSEVIDEO 0x70
#define DISP_UNDERLINE		0x01
#define DISP_NONDISPLAY		0x00
/* The following attribute bits should be OR'ed in:	*/
#define DISP_INTENSITY		0x08
#define DISP_BLINK		0x80
/*****************************
 * Values for disp_setcursortype():
 */
#define DISP_CURSORBLOCK (disp_mono ? 0x000C : 0x0007)	/* block cursor	    */
#define DISP_CURSORHALF	 (disp_mono ? 0x060C : 0x0307)	/* half-size cursor */
#define DISP_CURSORUL	 (disp_mono ? 0x0B0C : 0x0707)	/* underline cursor */
#define VID_eeol()
#define VID_clr_scr() _clearscreen(_GCLEARSCREEN)
#define VID_eeop() _clearscreen(_GCLEARSCREEN)
#define VID_puts _outtext
#define VID_move(A,B) _settextposition(A+1,B+1)
#define VID_putc putch
#define VID_startstand() _settextcolor(0);_setbkcolor(7L)
#define VID_endstand() _settextcolor(7);_setbkcolor(0L)
#define VID_open()
#define VID_flush()
#define VID_close()

#else
/* assume use of TURBOC compiler */
#include <conio.h>
#define DISP_NORMAL 0x07
#define DISP_REVERSEVIDEO 0x70
#define DISP_UNDERLINE		0x01
#define DISP_NONDISPLAY		0x00
/* The following attribute bits should be OR'ed in:	*/
#define DISP_INTENSITY		0x08
#define DISP_BLINK		0x80
#define DISP_CURSORBLOCK 0x000C  /* block cursor	    */
#define DISP_CURSORHALF	 0x060C  /* half-size cursor */
#define DISP_CURSORUL	 0x0B0C  /* underline cursor */
#define VID_eeol clreol
#define VID_clr_scr clrscr
#define VID_eeop clrscr
#define VID_puts cputs
#define VID_move(A,B) gotoxy(B+1,A+1)
#define VID_putc putch
#define VID_startstand() (textattr(0x70))
#define VID_endstand() (textattr(0x07))
#define VID_printf cprintf
#define VID_open()
#define VID_getmode()
#define VID_flush()
#define VID_close()

#endif /* _MSC */
#endif /* ZOR */
#endif /* VID_H */
