/*
 * Sun clock.  Hacked into PC version by Dave Katz.
 */

/*
 * Sun clock.  X11 version by John Mackin.
 *
 * This program was derived from, and is still in part identical with, the
 * Suntools Sun clock program whose author's comment appears immediately
 * below.  Please preserve both notices.
 *
 * The X11R3/4 version of this program was written by John Mackin, at the
 * Basser Department of Computer Science, University of Sydney, Sydney,
 * New South Wales, Australia; <john@cs.su.oz.AU>.  This program, like
 * the one it was derived from, is in the public domain: `Love is the
 * law, love under will.'
 */

/*

        Sun clock

        Designed and implemented by John Walker in November of 1988.

        Version for the Sun Workstation.

    The algorithm used to calculate the position of the Sun is given in
    Chapter 18 of:

    "Astronomical  Formulae for Calculators" by Jean Meeus, Third Edition,
    Richmond: Willmann-Bell, 1985.  This book can be obtained from:

       Willmann-Bell
       P.O. Box 35025
       Richmond, VA  23235
       USA
       Phone: (804) 320-7016

    This program was written by:

       John Walker
       Autodesk, Inc.
       2320 Marinship Way
       Sausalito, CA  94965
       USA
       Fax:   (415) 389-9418
       Voice: (415) 332-2344 Ext. 2829
       Usenet: {sun,well,uunet}!acad!kelvin
           or: kelvin@acad.uu.net

    This  program is in the public domain: "Do what thou wilt shall be the
    whole of the law".  I'd appreciate  receiving  any  bug  fixes  and/or
    enhancements,  which  I'll  incorporate  in  future  versions  of  the
    program.  Please leave the original attribution information intact  so
    that credit and blame may be properly apportioned.

    Revision history:

        1.0  12/21/89  Initial version.
              8/24/89  Finally got around to submitting.
              3/25/91  PC version.

*/

#define True 1
#define False 0


#define VERSION         "1.0"
#define FGCOLOR 14
#define BGCOLOR 1
#define TEXTCOLOR 10
#define TEXTROW 24

#include <graph.h>
#include <string.h>
#include <malloc.h>
#include <conio.h>
#include "sunclock.h"

struct sunclock {
        int             s_width;        /* size of pixmap */
        int             s_height;
        int             s_flags;        /* see below */
        int             s_noon;         /* position of noon */
        short *         s_wtab1;        /* current width table (?) */
        short *         s_wtab;         /* previous width table (?) */
        long            s_increm;       /* increment for fake time */
        long            s_time;         /* time - real or fake, see flags */
        long            s_projtime;     /* last time we projected illumination */
        int             s_timeout;      /* time until next image update */
}clockblock;

char *                          Wdayname[] = {
        "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};
char *                          Monname[] = {
        "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
        "Aug", "Sep", "Oct", "Nov", "Dec"
};

/*
 * bits in s_flags
 */

#define S_FAKE          01              /* date is fake, don't use actual time */
#define S_ANIMATE       02              /* do animation based on increment */

double                          jtime();
double                          gmst();
char *                          salloc();
struct sunclock *               makeClockContext();


struct sunclock *               Current;

main(argc, argv)
int argc;
char *argv[];
{

        int animate = 0;
        int fake = 0;
        if (argc > 1) {
            int i;
            for (i = 1; i < argc; i++) {
                if (!strcmp(argv[i], "-a")) {
                    animate = 1;
                    printf("Animating.\n");
                }
                if (!strcmp(argv[i], "-f")) {
                    fake = 1;
                    printf("Faking.\n");
                }
            }
        }
        makePixmaps();
        makeClockContexts();
        if (animate)
            Current->s_flags |= S_ANIMATE;
        if (fake)
            Current->s_flags |= S_FAKE;

        eventLoop();
        _setvideomode(_DEFAULTMODE);

        exit(0);
}


makePixmaps()
{

    short error;
    int i,j,k;

    error = _setvideomode(_ERESCOLOR);
    if (!error) {
        printf("Error setting video mode.");
        exit(1);
    }
    _setcolor(BGCOLOR);
    _floodfill(0, 0, FGCOLOR);
    _setbkcolor(BGCOLOR);
    _settextcolor(TEXTCOLOR);
    _setcolor(FGCOLOR);
    for (i=0; i<320; i++) {
        for (j=0; j<80; j++) {
            unsigned char mapbyte = large_map_bits[i*80+j];
            if (mapbyte == 0)
                continue;
            for (k=0; k<8; k++) {
                if (mapbyte & (1<<(k))) {
                    _setpixel(j*8+k, i);
                }
            }
        }
    }
}

makeClockContexts()
{
        register struct sunclock * s;

        s = makeClockContext(large_map_width, large_map_height);
        Current = s;
}

struct sunclock *
makeClockContext(wid, ht)
int                             wid;
int                             ht;
{
        register struct sunclock * s;

        s = &clockblock;
        s->s_width = wid;
        s->s_height = ht;
        s->s_flags = 0;
        s->s_noon = -1;
        s->s_wtab = (short *)salloc((int)(ht * sizeof (short *)));
        s->s_wtab1 = (short *)salloc((int)(ht * sizeof (short *)));
        s->s_increm = 180;
        time(&s->s_time);
        s->s_timeout = 0;
        s->s_projtime = -1L;

        return (s);
}

/*
 * Someone is sure to wonder why the event loop is coded this way, without
 * using select().  The answer is that this was developed on a System V
 * kernel, which has select() but the call has bugs; so, I was inspired
 * to make it portable to systems without select().  The slight delay in
 * expose event processing that results from using sleep(1) rather than
 * alarm() is a fine payoff for not having to worry about interrupted
 * system calls.
 *
 * I've got to use XCheckIfEvent with a degenerate predicate rather than
 * XCheckMaskEvent with a mask of -1L because the latter won't collect all
 * types of events, notably ClientMessage and Selection events.  Sigh.
 */

eventLoop()
{

        for (;;) {
                if (kbhit())
                    break;
                updimage(Current);
                updtext(Current);
                doTimeout();
        }
}


doTimeout()
{
        time_t curtime = time(NULL);
        while (curtime == time(NULL)) {};
}


/*  UPDIMAGE  --  Update current displayed image.  */

updimage(s)
register struct sunclock *      s;
{
        register int            i;
        int                     xl;
        struct tm *             ct;
        double                  jt;
        double                  sunra;
        double                  sundec;
        double                  sunrv;
        double                  sunlong;
        double                  gt;
        short *                 wtab_swap;

        /* If this is a full repaint of the window, force complete
           recalculation. */

        if (s->s_noon < 0) {
                s->s_projtime = 0;
                for (i = 0; i < s->s_height; i++) {
                        s->s_wtab1[i] = -1;
                }
        }

        if (s->s_flags & S_ANIMATE) {
                s->s_time += s->s_increm;
                if (s->s_time < 0)
                        s->s_time = 0;
        } else
                time(&s->s_time);

        ct = gmtime(&s->s_time);

        jt = jtime(ct);
        sunpos(jt, False, &sunra, &sundec, &sunrv, &sunlong);
        gt = gmst(jt);

        /* Projecting the illumination curve  for the current seasonal
           instant is costly.  If we're running in real time, only  do
           it every PROJINT seconds.  */

        if ((s->s_flags & S_FAKE)
         || s->s_projtime < 0
         || (s->s_time - s->s_projtime) > PROJINT) {
                projillum(s->s_wtab, s->s_width, s->s_height, sundec);
                wtab_swap = s->s_wtab;
                s->s_wtab = s->s_wtab1;
                s->s_wtab1 = wtab_swap;
                s->s_projtime = s->s_time;
        }

        sunlong = fixangle(180.0 + (sunra - (gt * 15)));
        xl = sunlong * (s->s_width / 360.0);

        /* If the subsolar point has moved at least one pixel, update
           the illuminated area on the screen.  */

        if ((s->s_flags & S_FAKE) || s->s_noon != xl) {
                moveterm(s->s_wtab1, xl, s->s_wtab, s->s_noon, s->s_width,
                         s->s_height);
                s->s_noon = xl;
        }
}

/*  PROJILLUM  --  Project illuminated area on the map.  */

projillum(wtab, xdots, ydots, dec)
short *wtab;
int xdots, ydots;
double dec;
{
        int i, ftf = True, ilon, ilat, lilon, lilat, xt;
        double m, x, y, z, th, lon, lat, s, c;

        /* Clear unoccupied cells in width table */

        for (i = 0; i < ydots; i++)
                wtab[i] = -1;

        /* Build transformation for declination */

        s = sin(-dtr(dec));
        c = cos(-dtr(dec));

        /* Increment over a semicircle of illumination */

        for (th = -(PI / 2); th <= PI / 2 + 0.001;
            th += PI / TERMINC) {

                /* Transform the point through the declination rotation. */

                x = -s * sin(th);
                y = cos(th);
                z = c * sin(th);

                /* Transform the resulting co-ordinate through the
                   map projection to obtain screen co-ordinates. */

                lon = (y == 0 && x == 0) ? 0.0 : rtd(atan2(y, x));
                lat = rtd(asin(z));

                ilat = ydots - (lat + 90) * (ydots / 180.0);
                ilon = lon * (xdots / 360.0);

                if (ftf) {

                        /* First time.  Just save start co-ordinate. */

                        lilon = ilon;
                        lilat = ilat;
                        ftf = False;
                } else {

                        /* Trace out the line and set the width table. */

                        if (lilat == ilat) {
                                wtab[(ydots - 1) - ilat] = ilon == 0 ? 1 : ilon;
                        } else {
                                m = ((double) (ilon - lilon)) / (ilat - lilat);
                                for (i = lilat; i != ilat; i += sgn(ilat - lilat)) {
                                        xt = lilon + floor((m * (i - lilat)) + 0.5);
                                        wtab[(ydots - 1) - i] = xt == 0 ? 1 : xt;
                                }
                        }
                        lilon = ilon;
                        lilat = ilat;
                }
        }

        /* Now tweak the widths to generate full illumination for
           the correct pole. */

        if (dec < 0.0) {
                ilat = ydots - 1;
                lilat = -1;
        } else {
                ilat = 0;
                lilat = 1;
        }

        for (i = ilat; i != ydots / 2; i += lilat) {
                if (wtab[i] != -1) {
                        while (True) {
                                wtab[i] = xdots / 2;
                                if (i == ilat)
                                        break;
                                i -= lilat;
                        }
                        break;
                }
        }
}

/*  XSPAN  --  Complement a span of pixels.  Called with line in which
               pixels are contained, leftmost pixel in the  line,  and
               the   number   of   pixels   to   complement.   Handles
               wrap-around at the right edge of the screen.  */

xspan(pline, leftp, npix, xdots)
register int                    pline;
register int                    leftp;
register int                    npix;
register int                    xdots;
{
        int i;
        if (npix == 0)
            return;
        leftp = leftp % xdots;

        if (leftp + npix > xdots) {
                xspan(pline, leftp, (xdots - leftp), xdots);
                xspan(pline, 0, (leftp + npix - xdots), xdots);
/*              XDrawLine(dpy, p, GC_invert, leftp, pline, xdots - 1, pline);
                XDrawLine(dpy, p, GC_invert, 0, pline,
                          (leftp + npix) - (xdots + 1), pline);*/
        } else {
                for (i = leftp; i < leftp+npix; i++) {
                    if (_getpixel(i, pline) == BGCOLOR) {
                        _setcolor(FGCOLOR);
                        _setpixel(i, pline);
                    } else {
                        _setcolor(BGCOLOR);
                        _setpixel(i, pline);
                    }
                }
/*              XDrawLine(dpy, p, GC_invert, leftp, pline,
                          leftp + (npix - 1), pline);*/
        }
}

/*  MOVETERM  --  Update illuminated portion of the globe.  */

moveterm(wtab, noon, otab, onoon, xdots, ydots)
short *wtab, *otab;
int noon, onoon, xdots, ydots;
{
        int i, ol, oh, nl, nh;

        for (i = 0; i < ydots; i++) {

                /* If line is off in new width table but is set in
                   the old table, clear it. */

                if (wtab[i] < 0) {
                        if (otab[i] >= 0) {
                                xspan(i, ((onoon - otab[i]) + xdots) % xdots,
                                    otab[i] * 2, xdots);
                        }
                } else {

                        /* Line is on in new width table.  If it was off in
                           the old width table, just draw it. */

                        if (otab[i] < 0) {
                                xspan(i, ((noon - wtab[i]) + xdots) % xdots,
                                    wtab[i] * 2, xdots);
                        } else {

                                /* If both the old and new spans were the entire
                                   screen, they're equivalent. */

                                if (otab[i] == wtab[i] && wtab[i] == (xdots / 2))
                                        continue;

                                /* The line was on in both the old and new width
                                   tables.  We must adjust the difference in the
                                   span.  */

                                ol =  ((onoon - otab[i]) + xdots) % xdots;
                                oh = (ol + otab[i] * 2) - 1;
                                nl =  ((noon - wtab[i]) + xdots) % xdots;
                                nh = (nl + wtab[i] * 2) - 1;

                                /* If spans are disjoint, erase old span and set
                                   new span. */

                                if (oh < nl || nh < ol) {
                                        xspan(i, ol, (oh - ol) + 1, xdots);
                                        xspan(i, nl, (nh - nl) + 1, xdots);
                                } else {
                                        /* Clear portion(s) of old span that extend
                                           beyond end of new span. */
                                        if (ol < nl) {
                                                xspan(i, ol, nl - ol, xdots);
                                                ol = nl;
                                        }
                                        if (oh > nh) {
                                                xspan(i, nh + 1, oh - nh, xdots);
                                                oh = nh;
                                        }
                                        /* Extend existing (possibly trimmed) span to
                                           correct new length. */
                                        if (nl < ol) {
                                                xspan(i, nl, ol - nl, xdots);
                                        }
                                        if (nh > oh) {
                                                xspan(i, oh + 1, nh - oh, xdots);
                                        }
                                }
                        }
                }
                otab[i] = wtab[i];
        }
}

char *
salloc(nbytes)
register int                    nbytes;
{
        register char *         p;

        p = malloc((unsigned)nbytes);
        if (p == (char *)NULL) {
                fprintf(stderr, "%s: out of memory\n");
                exit(1);
        }
        return (p);
}


updtext(s)
struct sunclock *s;
{
        struct tm lt;
        register struct tm *            ltp = &lt;
        register struct tm *            gmtp;
        static char old[80];
        char new[80];
        char outstring[2];
        int i;

        outstring[1] = '\0';
        lt = *localtime(&s->s_time);
        gmtp = gmtime(&s->s_time);

        sprintf(new,
                "%02d:%02d:%02d %s %s %02d %s %02d     %02d:%02d:%02d UTC %s %02d %s %02d",
                ltp->tm_hour, ltp->tm_min,
                ltp->tm_sec,
                tzname[ltp->tm_isdst],
                Wdayname[ltp->tm_wday], ltp->tm_mday,
                Monname[ltp->tm_mon], ltp->tm_year % 100,
                gmtp->tm_hour, gmtp->tm_min,
                gmtp->tm_sec, Wdayname[gmtp->tm_wday], gmtp->tm_mday,
                Monname[gmtp->tm_mon], gmtp->tm_year % 100);

        /* For speed purposes, only update changed characters on the screen. */

        for (i=0; i<strlen(new); i++) {
                if (old[i] != new[i]) {
                        _settextposition(TEXTROW, i + 13);
                        outstring[0] = new[i];
                        _outtext(outstring);
                        old[i] = new[i];
                }
        }
}
