//
// strsearch.cpp: str class member functions for searching and replacing
// Author       : Roy S. Woll
//
// Copyright (c) 1993 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.4      12/16/93
//    Support reverse searcing
//
// Version 2.2      5/5/93
//    Fix bug in index relating to case sensitivity (backwards)
//
// Version 2.00     11/31/92
//    Support searching/replacing, regular expressions, case sensitivity
//

#include <string.h>
#include <limits.h>

#include "str.h"

inline int min(int x, int y){if (x<y) return x; else return y;}

// 
// index member functions
//
int str::index(const char * s, int start) const{
   if (!caseSensitive()){
      str mylowstr(::lowercase(*this));
      const char * charptr = strstr(mylowstr(start), ::lowercase(s));
      if (charptr) return (charptr - mylowstr());
      else return (-1);
   }
   else {
      const char * charptr = strstr((*this)(start), s);
      if (charptr) return (charptr - data->buf);
      else return (-1);
   }
};

// Search backwards
int str::indexr(const char * s, int start) const{
   int len1=length();
   int len2=strlen(s);

   if (len1<len2) return -1;
   int pos = len1-len2;
   if (start>=0) pos = min(pos, start);

   while (pos>=0)
   {
     if (!strncmp(data->buf+pos, s, len2)) return pos;
     pos--;
   }
   return -1;
};

int str::index(char s, int start) const
{
	const char * pos = strchr((*this)(start), s);
   if (pos) return pos-data->buf;
   else return -1;
}

int str::indexr(char s, int start) const
{
   while (start>=0){
     if (data->buf[start]==s) return start;
     else start--;
   }
   return start;
}


//
// search operator functions
//

int str::search(const char * s, int* startPtr) const{
   *startPtr = index(s, *startPtr);
   return *startPtr>=0;
};

int str::search(const char * s, int start) const{
   return index(s, start)>=0;
};

int str::search(char s, int* startPtr) const{
   *startPtr = index(s, *startPtr);
	return *startPtr>=0;
};

int str::search(char s, int start) const{
   return index(s, start);
};

int str::searchr(char s, int* startPtr) const{
   *startPtr = indexr(s, *startPtr);
	return *startPtr>=0;
};

int str::searchr(char s, int start) const{
   return indexr(s, start);
};


int str::searchr(const char * s, int* startPtr) const{
   *startPtr = indexr(s, *startPtr);
   return *startPtr>=0;
};

int str::searchr(const char * s, int start) const{
   return indexr(s, start)>=0;
};

int str::replace(const char * searchStr, const char* replaceStr,
                 int start, int numReplacements)
{
  return replace(searchStr, replaceStr, &start, numReplacements);
};


int str::replace(const char * searchStr, const char* replaceStr,
                 int* startPtr, int numReplacements)
{

   if (numReplacements==0) return 0;

   int& start = *startPtr;
   int countReplacements=0;
   int searchLen = strlen(searchStr), replaceLen = strlen(replaceStr);

   do {

      start = index(searchStr, start);
      if (start<0) break;
      countReplacements++;
      operator()(start, searchLen) = replaceStr;
      start+= replaceLen;           //skip past newly added data

      if (!--numReplacements) break;

   } while (1);

   return countReplacements;

};


int str::replaceAll(const char * searchStr, const char* replaceStr, int start)
{
  return replace(searchStr, replaceStr, &start, INT_MAX);
};

int str::count(const char * searchStr, int start)
{
	int countReplacements=0;
   int searchLen = strlen(searchStr);

	while (search(searchStr, start))
   {
		start+= searchLen;
		countReplacements++;
   }

	return countReplacements;
};

int str::replacer(const char * searchStr, const char* replaceStr,
                 int start, int numReplacements)
{
  return replacer(searchStr, replaceStr, &start, numReplacements);
};

int str::replacer(const char * searchStr, const char* replaceStr,
                 int* startPtr, int numReplacements)
{

   if (numReplacements==0) return 0;

   int& start = *startPtr;
   int countReplacements=0;
   int searchLen = strlen(searchStr);

   do {

      start = indexr(searchStr, start);
      if (start<0) break;
      countReplacements++;
      operator()(start, searchLen) = replaceStr;
      if (start) start--;           //skip past newly added data
      else break;

      if (!--numReplacements) break;

   } while (1);

   return countReplacements;

};


