//
// dynstream.h : dynstream class interface
// Author  : Roy S. Woll
//
// Copyright (c) 1992 by Roy S. Woll
// You may distribute this source freely as long as you leave all files
// in their original form, including the copyright notice as is.
//
//
// Version 2.00     11/30/92
//    Override member function streambuf::sync()   Roy S. Woll
//
// Version 1.00     10/20/92
//
//
#ifndef _DYNSTREAM_H
#define _DYNSTREAM_H

#include <iostream.h>

#include "str.h"


class dynstreambuf : public streambuf{
   str* strPtr;

protected:
   virtual int overflow(int = EOF);
   virtual streampos seekoff(streamoff offset, ios::seek_dir dir, int);
   virtual int sync();

   char * getNewBuffer(int newbufsize);

public:
   dynstreambuf(str *);

   void set_len(int len);
   void set_str(str *);
   void setNewBuffer(char * buf, int newbufsize, int curlength=0);
};

class dynstreambase : public virtual ios{
protected:
   dynstreambuf mystreambuf;
public:
   dynstreambase(str * AstrPtr): mystreambuf(AstrPtr){};
   dynstreambuf * rdbuf(){return &mystreambuf; };

};

class dynstream: public dynstreambase, public ostream{
public:
   dynstream(str *);
   ~dynstream(void);
};

#endif
