/* Include file for the Strip Chart Library */

extern double SC_yoffset; /* current window starting position */

struct SC_Window {
   int type; /* window type */
   int pymin, pymax; /* window position in PC */
   void *window; /* window data structure */
   struct SC_Window *next; /* linked list */
};

typedef struct SC_Window SC_WINDOW;

/* Printer resolution codes */
#define SC_LOW_RES 0  /* low resolution mode */
#define SC_HIGH_RES 1 /* high resolution mode */

/* Printer type codes */
#define SC_9PIN 9      /* 9 pin printer */
#define SC_24PIN 24    /* 24 pin printer */

/* Printer ports */
#define LPT1 0
#define LPT2 1
#define LPT3 2

/* Marker Types */
#define SCM_PULSE 0
#define SCM_TICK 1
#define SCM_BAR 2
#define SCM_BARLINE 3

 /* Window types */
#define SC_TRACE 1
#define SC_TEXT 2
#define SC_EVENT 3
#define SC_TIME 4 /* time axis with labels and ticks */
#define SC_TITLE 5 /* constant, periodic text */

/* Line types */
#define LIGHT_LINE  8
#define MEDIUM_LINE  4
#define SOLID_LINE 0

/* Fill types */
#define NO_FILL -1
#define SOLID_FILL 0
#define HALF_FILL 4

/* Flags */
#define SCF_NOFLAGS 0 /* no flags */
#define SCF_BORDER 1 /* Border around window */
#define SCF_GRID 2 /* Show grids */
#define SCF_YLABEL 4 /* Label horizontal grids */
#define SCF_CLIP 8 /* Enable clipping */

/* Time label types */
#define LABELS_BELOW_AXIS 0
#define LABELS_ABOVE_AXIS 1

/* Units Types */
#define INCHES 1.0
#define CENTIMETERS (1.0/2.54)

/* Error codes */
#define SCE_NO_ERROR 0
#define SCE_OUT_OF_MEMORY 1
#define SCE_INCORRECT_WINDOW_TYPE 2 /* incorrect window type for the function */
#define SCE_INVALID_TRACE_RANGE 3 /* ymin must not equal ymax */
#define SCE_INVALID_WINDOW_OFFSET 4 /*  yoffset must be > 0 */
#define SCE_INVALID_WINDOW_HEIGHT 5 /*  yheight must be > 0 */
#define SCE_INVALID_PRINTER 6  /* SC_Init: the indicated printer type and  resolution is not supported */
#define SCE_INVALID_TIME_INTERVAL 7 /* time interval must be > 0 */
#define SCE_INVALID_HGRID_DIV 8 /* horizontal grid divisions must be >= 1 */
#define SCE_NULL_STRING 9 /* tried to pass a null pointer */
#define SCE_INVALID_CHAR_HEIGHT 10 /* char height must be > 0 */


/*-------------------------------------------------*/
/* Function Prototypes for User Functions          */
/*-------------------------------------------------*/

extern SC_WINDOW *SC_AddEventWindow(double yoffset, double yheight,
   int markerType, int fillType, int *error);
extern void SC_Event(SC_WINDOW *eventWindow, int evtlevel, int *error);
extern SC_WINDOW *SC_AddTimeWindow(double yoffset,
   double yheight, int type, double tickInterval, int minorDiv,
   char * (*labelFunc)(SC_WINDOW *timeWindow,double elapsedTime,
      unsigned long labelCount),
   int *error);
extern SC_WINDOW *SC_AddTextWindow(double yoffset,double yheight,
   int *error);
extern void SC_Text(SC_WINDOW *textWindow,char *s,int *error);
extern SC_WINDOW *SC_AddTraceWindow(double yoffset, double yheight,
   double ymin, double ymax, unsigned int flags, int *error);
extern void SC_SetTraceRange(SC_WINDOW *traceWindow,
   double ymin, double ymax, int *error);
extern void SC_Trace(SC_WINDOW *traceWindow, double scan, int *error);
extern void SC_Draw(void);
extern void SC_Advance(double sec);
extern void SC_Close(void);
extern void SC_Init(int port, unsigned char printerType,
   unsigned char plotResolution, double units, double plotWidth,
   double plotSpeed, int *error);
extern int SC_PrinterReady(int port);
extern void SC_PrintChar(char c);
extern void SC_SetTimeGrids(double seconds, int *error);
extern void SC_SetHorizontalGrids(int divisions, int *error);
extern void SC_SetYlabels(double charHeight, char *format,
   double interval, int *error);
extern void SC_Title(SC_WINDOW *titleWindow,char *title,int *error);
extern SC_WINDOW *SC_AddTitleWindow(double yoffset, double yheight,
   double interval, int *error);
extern char *SC_ErrorMsg(int errCode);
extern void SC_SetErrorTrap(void (*errorFunc)(char *msg));

