#ifndef h__String
#define h__String

#include <stdlib.h>
#include <String.h>
#include <iostream.h>
//#include <conio.h>

class String {

    protected:
    char    *s;
    int     len;
    void allocFail() {
        if(!s) {
            cout << "\nString Allocation error!!!\n";
            exit(1);
        }
    }

    // Just for consistency, Strings are S,
    //                       char*   are P,
    //                       chars   are c.
    public:
    String();                   //See CONST1.CPP
    String(char *P);          //See CONST2.CPP
    String(String &S);    //See CONST3.CPP
    String(char c);             //See CONST4.CPP

    ~String() {delete s;}

    friend ostream &operator<<(ostream &stream, String &S); //output OUT.CPP
    friend istream &operator>>(istream &stream, String &S); //input  IN.CPP
    // if ( String > char* ) ....
    int operator <= (char* P)   { return strcmp(s,P)     <= 0; }
    int operator <  (char* P)   { return strcmp(s,P)     <  0; }
    int operator == (char* P)   { return strcmp(s,P)     == 0; }
    int operator >  (char* P)   { return strcmp(s,P)     >  0; }
    int operator >= (char* P)   { return strcmp(s,P)     >= 0; }
    int operator != (char* P)   { return strcmp(s,P)     != 0; }
    int operator <  (String& S) { return strcmp(s,S.s) <  0; }
    int operator == (String& S) { return strcmp(s,S.s) == 0; }
    int operator >  (String& S) { return strcmp(s,S.s) >  0; }
    int operator >= (String& S) { return strcmp(s,S.s) >= 0; }
    int operator != (String& S) { return strcmp(s,S.s) != 0; }
    int operator <= (String& S) { return strcmp(s,S.s) <= 0; }
    // if ( char* > String ) ....
    friend int operator <  (char* P,String& S) { return strcmp(P, S.s) <0; }
    friend int operator == (char* P,String& S) { return strcmp(P, S.s)==0; }
    friend int operator >  (char* P,String& S) { return strcmp(P, S.s) >0; }
    friend int operator >= (char* P,String& S) { return strcmp(P, S.s)>=0; }
    friend int operator != (char* P,String& S) { return strcmp(P, S.s)!=0; }
    friend int operator <= (char* P,String& S) { return strcmp(P, S.s)<=0; }

    String operator=(String &S);    //assign a String object.   COPYS.CPP
    String operator=(char *P);      //assign a quoted String.   COPYP.CPP
    String operator+(String &S);    //Concatenate a string.     ADDS.CPP
    String operator+(char *P);      //Concatenate a C string.   ADDP.CPP
    String operator+(char c);       //Concatenate a char.       ADDC.CPP

    void operator += (String& S);   //Concatenate a String      CONCATS.CPP
    void operator += (char* P);     //Concatenate a C string.   CONCATP.CPP
    void operator += (char c);      //Concatenate a char.       CONCATC.CPP
    char &operator[](unsigned i) { return s[i]; }

    int Length(void) { return (len-1);};
    void display() { cout << s << '\n';};
    void ddisplay() { cout << s << " [" << len << "]\n";}; //debug
    char *makeCString(void);    //makeC.cpp
    String SubString(int first,int length); //Return a sub String.  SUBSTR.CPP

    void Upper(void) { strupr(s); };
    void Lower(void) { strlwr(s); };
    int  isEmpty(void) { return (len<=1); };

};
#endif

