/***************************************************************************
**                                                                        **
**  Module :  strfile.h                                                   **
**                                                                        **
**  Author :  David J. Yazel                                              **
**                                                                        **
**  Notice :  Copyright (c) 1992, Tracking Technologies, Inc,             **
**                                                                        **
**            All source code contained within this file is released      **
**            into the public domain for use in personal and professional **
**            projects.  Sale of this source code, in portion or whole,   **
**            without prior, written permission from Tracking             **
**            Technologies, Inc. is strictly prohibited.                  **
**                                                                        **
**  Notes  :                                                              **
**                                                                        **
****************************************************************************/

#define READ_FILE   1
#define WRITE_FILE  2
#define APPEND_FILE 3

class StringFile {

private:

   FILE *stream;

   public:

   // Two constructors are provided, one which opens the file
   // and one which allows for opening the file via the open() function
   // later

   StringFile(String filename, Word mode );
   StringFile();

   // open() allows the user to open a new the file after a close() or
   // after a StringFile()

   Bool open(String filename, Word mode );
   void close();

   // reading and writing fron a string file

   String read();
   void write( String str );

   // interrogative functions

   Bool eof();           // True if end of file, False if not
   Bool IsOpen();        // True if file open, False if not

   // destructor for the string file

   ~StringFile();

};
