//========================================================================
//  The following routines have been uploaded to the Borland Forum BPROGB
//  on CompuServe by the Technical Support staff.  They are provided as a
//  courtesy and not as part of a Borland product; and, as such, are
//  provided without the assurance of technical support or any specific
//  guarantees.
//========================================================================
//  Turbo Vision - Streaming a User Defined Dialog
//
//  - This sample code demonstrates a method of creating a user defined
//  Dialog box with unique data members and handleEvent, executing the
//  Dialog box, streaming it out to disk, retrieving it from disk and
//  reexecuting it.
//
//  - Please refer to Chapter 8 in the Turbo Vision User's Guide
//  for more information on streamable objects.
//
//========================================================================

//----------------------- TV "Uses" -----------------------------------
#define Uses_MsgBox
#define Uses_TProgram
#define Uses_TApplication
#define Uses_TKeys
#define Uses_TRect
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TDeskTop
#define Uses_TView
#define Uses_TWindow
#define Uses_TFrame
#define Uses_TDialog
#define Uses_TButton
#define Uses_TSItem
#define Uses_TMenu
#define Uses_TObject
#define Uses_TStreamable
#define Uses_TResourceCollection
#define Uses_TStaticText

//----------------------------- stream "Uses" -----------------------
#define Uses_ifpstream
#define Uses_ofpstream
#define Uses_TStreamableClass
#define Uses_ipstream
#define Uses_opstream

#include <stdio.h>         // for sprintf()
#include <tv.h>            // Need TV.H before the __LINK Macros


//-------------------------------------------------------------------
//	You must register every TV class you intend to use.
//	Attempting to stream a class which is not registered
//	will cause the program to crash.
//-------------------------------------------------------------------
__link( RButton )
__link( RFrame )
__link( RResourceCollection )
__link( RDialog )
__link( RStaticText )


//------------------------ define our message constants -------------
const int cmAbout   = 100;
const int cmExit    = 101;
const int cmSpace   = 102;
const int cmDialog1 = 103;

//---------------- filename for streaming ---------------------------

const char *FILE_NAME = "strmdlg.sav";


//-------------------------------------------------------------------
//     This is an example of a user defined Dialog box.  Although
//     we inherit the streamable aspects of TDialog, we will need
//     to override several member functions inorder to provide
//     streamability for this new class.
//
//     NOTICE: The overridden WRITE, READ, BUILD, and
//	     STREAMABLENAME member functions. We also
//	     need the static NAME data member.
//
//-------------------------------------------------------------------
class TMyDialog: public TDialog
{

public:

   char buffer[60];
   int var1, var2, flag;

   virtual void write( opstream& os);
   virtual void *read( ipstream& );

   static const char * const name;
   static TStreamable *build();

   TMyDialog( const TRect& bounds, const char *aTitle) :
		   TDialog( bounds, aTitle),
		   TWindowInit( &TMyDialog::initFrame )
   {
       var1 = 37;                           // my new data members
       var2 = 99;                           // will need to be streamed.
       flags ^= wfMove;                     //turn off the move option.
   };

   virtual void handleEvent( TEvent& );     // override the handle event

protected:

   TMyDialog( StreamableInit  ) : TDialog( streamableInit ),
	 TWindowInit( streamableInit ) {};

private:

   virtual const char *streamableName() const
      { return name; }

};


/*--------------------------------------------------------------------*\
	 Build a skeleton for our new object.
\*--------------------------------------------------------------------*/
TStreamable *TMyDialog::build()
{
     return new TMyDialog( streamableInit );
}



/*-------------------------------------------------------------------*\
       Notice how we write out the new data members of our class
       (TMyDialog).
\*-------------------------------------------------------------------*/
void TMyDialog::write( opstream& os)
{
     TDialog::write( os );
     os << var1 << var2;
}



/*-------------------------------------------------------------------*\
       Here we read in the new data members of our class(TMyDialog).
\*-------------------------------------------------------------------*/
void *TMyDialog::read( ipstream& is )
{
      TDialog::read( is );
      is >> var1 >> var2;
      return this;
}



//------- initialize the static data member -------------------------\\
const char * const TMyDialog::name = "TMyDialog";



/*-------------------------------------------------------------------*\
       Overload the insertion and extraction operators for our
       new class( TMyDialog ).
\*-------------------------------------------------------------------*/
inline ipstream& operator >> ( ipstream& is, TMyDialog& cl )
     {    return is >> ( TStreamable& )cl;    }

inline ipstream& operator >> ( ipstream& is, TMyDialog*& cl )
     {    return is >> (void *&)cl;           }

inline opstream& operator << ( opstream& os, TMyDialog& cl )
     {    return os << ( TStreamable& )cl;    }

inline opstream& operator << ( opstream& os, TMyDialog* cl )
     {    return os << (TStreamable *)cl;     }




//-------------- Register our new class explictly  ------------------\\
TStreamableClass RMyDialog(  TMyDialog::name,
			     TMyDialog::build,
			     __DELTA(TMyDialog) );



/*-------------------------------------------------------------------*\
		Overloaded handle event.
\*-------------------------------------------------------------------*/
void TMyDialog::handleEvent( TEvent& event )
{

   if( event.what == evCommand )
   {
     switch( event.message.command )
     {
       case cmOK:
	 sprintf( buffer, "Var #1 is: %d  Var #2 is: %d", var1, var2);
	 messageBox( buffer, mfInformation | mfOKButton);
	 clearEvent( event );
	 break;
     }
   }

  TDialog::handleEvent( event );
}



class TMyApp : public TApplication
{

public:
	TMyApp();
	static TMenuBar *initMenuBar( TRect );
	void handleEvent(TEvent& event);
	void Dialog1(void);
};


TMyApp::TMyApp() :
  TProgInit( 0, &initMenuBar, &initDeskTop )
{}


void TMyApp::Dialog1(void)
{
    char *text = "This Dialog will be streamed out to disk... then"\
                 " streamed back and executed again...";

                                 // make initial dialog..........
    TMyDialog *pd = new TMyDialog( TRect( 5,1,75,20), "Streaming along...");

                                 // open output stream....check for valid
    ofpstream of( FILE_NAME, ios::out | ios::binary );
    if( !of )
    {
      messageBox("Error opening output file!", mfError );
      return;
    }

    if( validView( pd ) )        // if valid insert a buttons and execute
    {
      pd->insert( new TStaticText( TRect(10,3,60, 15), text) );
      pd->insert( new TButton(TRect(10,14,25,16), "Variables", cmOK, bfNormal) );
      pd->insert( new TButton(TRect(10,10,20,12), "Cancel", cmCancel, bfDefault) );
      deskTop->execView( pd );
    }


    messageBox("Streaming Dialog to disk now...", mfInformation|mfOKButton);
    of << pd;        // stream dialog out to disk


    of.close();      // close the output file
    destroy(pd);     // destroy the dialog


    //---------------- stream the dialog back in from disk ---------------

    TMyDialog  *dg = NULL;             // pointer to a TMyDialog

    ifpstream ifps( FILE_NAME );       // open input stream
    if( !ifps )                        // open correctly?
    {
      messageBox("Error opening input file!", mfError);
      return ;
    }


    messageBox("Streaming Dialog back from disk...", mfInformation|mfOKButton);
    ifps >> dg;                         // stream in the dialog

    if( validView( dg ) )
    {
      deskTop->execView( dg );          // execute the dialog again
    }

    destroy(dg);

}

/*------------------------------------------------------------------*\
     Application handleEvent...
\*------------------------------------------------------------------*/
void TMyApp::handleEvent(TEvent& event)
{
   TApplication::handleEvent( event );

   if( event.what == evCommand )
   {
      switch( event.message.command)
      {
	 case cmDialog1:
		Dialog1();
		break;

	 default:
		break;
      }
      clearEvent( event );
   }
}


TMenuBar *TMyApp::initMenuBar( TRect r )
{
    r.b.y = r.a.y + 1;

   TMenuItem *one =
      new TMenuItem("~E~xit", cmQuit, kbAltX, hcNoContext, 0);

   TMenuItem *two =
      new TMenuItem("~\xF0~", cmDialog1, kbAltSpace, hcNoContext,0, one);

   return new TMenuBar( r, new TMenu( *two ));


}


int main()
{
	TMyApp myApp;
	myApp.run();
	return 0;
}
