//*************************************************************
//  File name: GETTRACE.C
//
//  Description:
//      This file contains the GetStackTrace function which is
//      the main routine to handle logging of stack traces. This
//      routine works in a DLL too.
//       
//
//  Functions:
//       GetStackTrace(LPSTR, int, int);
//
//
//  Comments:
//      To use the GetStackTrace function, you need to declare the
//      function proto-type in your application, and compile/link
//      in both GETTRACE.C and STKTRACE.C files.  The prototype 
//      for the GetStackTrace function is:
//
//           UINT FAR PASCAL GetStackTrace (LPSTR, int, int);
//
//
//  Build Environment:
//      Windows SDK v3.1, C7.0
//
//
//  History:    Date       Author     Comment
//              8/18/92     MSS        Created
//              8/20/92     MSS   Updated to work in a DLL
//
//
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//*************************************************************

#include <windows.h>
#include <toolhelp.h>

LPSTR WINAPI FindSymbol (HFILE, WORD, WORD);

//*************************************************************
//  GetStackTrace
//
//  Purpose:
//     This routine logs stack trace info into a buffer. It uses the ToolHelp
//     APIs to walk the stack and the .SYM files to get the symbol names.
//     Only MaxFrame number of stack frames are stored into the buffer.
//         
//
//  Parameters:
//      LPSTR lpStkbuf  -  buffer to log the stack trace info
//      int nLen        -  length of the buffer
//      int MaxFrames   -  number of stack frames desired
//      
//  Return: (UINT)
//
//  History:    Date       Author     Comment
//              8/18/92     MSS       Created
//
//*************************************************************

UINT NEAR PASCAL GetStackTrace(LPSTR lpStkbuf, int nLen, int MaxFrames)
{
  STACKTRACEENTRY ste;
  HFILE         symfile;
  MODULEENTRY   me;
  WORD          wCS, wSS, wIP, wBP;
  OFSTRUCT      of;
  int           nBytes=0;
  char          framebuf[100];
  char          szTemp[128];
  LPSTR         lpTemp = (LPSTR)szTemp;
          
  //*** get the register values from the previous stack frame
  //*** note the way BP and IP are accessed
  _asm 
  {
       mov wCS, cs
       mov wSS, ss
       mov ax,  [bp]    ; since we need the old value of BP
       mov wBP, ax

       mov ax, [bp+2]   ; bp+2 points to the return addr or the 
       mov wIP, ax      ; IP value for a NEAR call
   }   
  
  lpStkbuf[0] = 0;
  if (!MaxFrames || !nLen)
     return 0;

  //*** required for all ToolHelp structures 
//  _fmemset( (LPSTR)&ste, 0, sizeof(STACKTRACEENTRY) );
  ste.dwSize = sizeof(STACKTRACEENTRY);
  me.dwSize = sizeof(me);

  //*** Beging the stack walk by obtaining the first stack frame
  //*** Note that StackTraceFirst() can't be used for the current task
  if (!StackTraceCSIPFirst(&ste, wSS, wCS, wIP, wBP)) 
     return 0;        
  
  //*** Do the stack walk   
  do
  {
      //*** extract the .SYM file name from the HMODULE and open the file
      if (ModuleFindHandle(&me, ste.hModule))
      {      
        LPSTR lp;

        lstrcpy((LPSTR) lpTemp, (LPSTR) me.szModule);
        lstrcat((LPSTR) lpTemp, (LPSTR) ".SYM");        
        symfile = OpenFile((LPCSTR) lpTemp, &of, OF_READ | OF_SHARE_DENY_WRITE);
        
        if (symfile > 0)
        {
            lstrcpy((LPSTR) lpTemp, (LPSTR) me.szModule);
            lstrcat((LPSTR) lpTemp, (LPSTR) ":"); 
            
            if ((lp = FindSymbol(symfile, ste.wSegment, ste.wIP))!=NULL)
               wsprintf(framebuf, " ->%-9s %s", lpTemp, lp);
             else
               wsprintf(framebuf, " ->%-9s %d:%04x", lpTemp, ste.wSegment, ste.wIP);
            _lclose(symfile);
        }
        else
            wsprintf(framebuf, " ->%-9s %d:%04x", lpTemp, ste.wSegment, ste.wIP);
      }
      else
        wsprintf( framebuf, " ->UNKNOWN:  %d:%04x", ste.wSegment, ste.wIP );

      nBytes += lstrlen((LPSTR) framebuf);      
      if (nLen > nBytes)
      { 
         lstrcat((LPSTR) lpStkbuf, (LPSTR) framebuf);
         lstrcat((LPSTR) lpStkbuf, (LPSTR) "\r\n");
      }
      else
         return 0;            

  } while (StackTraceNext(&ste) && MaxFrames-- > 0);
  
  lstrcat((LPSTR) lpStkbuf, (LPSTR) "\r\n");
  return 1;

} //*** GetStackTrace

//*** EOF: gettrace.c
