#define MAXSYMSIZE 256
#define MAXDIFFERENCE 0x0500

//***  Structure declarations for SEGDEF, MAPDEF, SYMDEF borrowed
//***  from the Vol. 4: Resources docs.
//***  The structure members that are needed in this program are
//***  marked as USED for convenience, so that the rest can be ignored
typedef struct tagMAPDEF 
{
     WORD ppNextMap;     /* paragraph pointer to next map        USED */
     BYTE bFlags;        /* symbol types                         USED */
     BYTE bReserved1;    
     WORD pSegEntry;     /* segment entry-point value            USED */
     WORD cConsts;       /* count of constants in map                 */
     WORD pConstDef;     /* pointer to the chain of constansts        */
     WORD cSegs;         /* count of segments in the map         USED */
     WORD ppSegDef;      /* paragraph pointer to first SEGDEF    USED */
     BYTE cbMaxSym;      /* maximum symbol-name length                */
     BYTE cbModName;     /* length of module name                     */
} MAPDEF;


//***  Note that the wReserved1 member has been renamed as SegNum for clarity
//***  as the docs do not explicitly say that this member is the segment number
typedef struct tagSEGDEF
{
     WORD ppNextSeg;     /* paragraph pointer to next SEGDEF     USED */
     WORD cSymbols;      /* count of symbols                     USED */
     WORD pSymDef;       /* offset to the chain of symbols       USED */
     WORD SegNum;        /* Renamed from wReserved1              USED */
     WORD wReserved2;    
     WORD wReserved3;
     WORD wReserved4;    
     BYTE bFlags;        /* symbol types                              */
     BYTE bReserved1;    
     WORD ppLineDef;     /* offset of line-number record              */
     BYTE bReserved2; 
     BYTE bReserved3; 
     BYTE cbSegName;     /* length of segment name                    */
} SEGDEF;
     

typedef struct tagSYMDEF
{
     WORD wSymVal;       /* symbol address or constant           USED */
     BYTE cbSymName;     /* length of symbol name                USED */
} SYMDEF;
     
     
