//_____________________________________________________________________
//(c)StatBarPlus+, all rights reserved 1993 - 1994
//Continuum Software
//1379 Towne Harbor Trail
//Woodstock, GA 30188
//_____________________________________________________________________
//************************************************************************
// test.cpp - 
//
// 
//************************************************************************
#ifndef __TEST_HPP
	#include "test.hpp"
#endif


#ifndef __STDLIB_H
	#include <stdlib.h>
#endif

#ifndef __TIME_H
	#include <time.h>
#endif

#ifndef __STRING_H
	#include <string.h>
#endif

#ifndef __ZAPPZAPP_INCLUDED
	#include "zapp.hpp"
#endif

MyBar *pIB,*pIB2;
zPushButton *pb;
zBitmap* okBitmap,*okBitmap2,*ignore,*retry;
unsigned int index=0;
char TimeString[150],ItemString[80];
struct tm *time_now;
time_t secs_now;
// Pane Member Functions - MainWin

MainWinPane::MainWinPane(zWindow *w, zSizer *sz): zPane(w, sz){}
//
// Frame Member Functions - MainWin
//
// Window Constructor
MainWin::MainWin(zWindow *w, zString &title)
 : zAppFrame(w,new zSizer(),zSTDFRAME, title)
{

	zColor Color1 (192,192,192);
	zColor Color2 (0,255,0);
	menu(new zMenu(this, zResId(MENU_1)));
	menu()->setHilite(this,(NotifyProc)&MainWin::MenuSelect);
	pIB = new  MyBar(this, new zGravSizer(ZGRAV_TOP, 39, sizer()),Color1,S_2D);
	pIB2 = new MyBar(this, new zGravSizer(ZGRAV_BOTTOM, 20, sizer()),Color1,S_3DF);
	pIB->addItem(new MyItemBmp(pIB, new zGravSizer(ZGRAV_LEFT,65,pIB->sizer()),S_2D,Color1, R1));
	pIB->addItem(new MyItemText(pIB, new zGravSizer(ZGRAV_LEFT,250,pIB->sizer()),S_3DR,Color1, R2));
	pIB->addItem(new MyItemText(pIB, new zGravSizer(ZGRAV_LEFT,80,pIB->sizer()),S_3DF,Color2, R3));
	pIB->addItem(new MyItemText(pIB, new zGravSizer(ZGRAV_LEFT,100,pIB->sizer()),S_2D,Color1, R4));
	pIB->addItem(new MyItem(pIB, new zGravSizer(ZGRAV_MIDDLE,0,pIB->sizer()),S_3DF,Color1, R5));
	pb = new zPushButton(pIB->item(R5),new zSizeWithParent, 0,"PUSH ME",ID_BUTTON);
	pb->show();
	pb->setNotifyClicked(pIB->item(R5),(NotifyProc)&MyItem::processClick);
	okBitmap = new zBitmap(((zStatusItemBitmap*)pIB->item(R1))->canvas(),"c:\\statbar\\bin\\ok.bmp");
	okBitmap2 = new zBitmap(((zStatusItemBitmap*)pIB->item(R1))->canvas(),"c:\\statbar\\bin\\ok2.bmp");
	((zStatusItemBitmap*)pIB->item(R1))->setBitmap(okBitmap);
	zTimer *Time = new zTimer(((zStatusItemBitmap*)pIB->item(R2)),
				(TimerProc)&MyItemText::processTime,1000);

	pIB->show();
	pIB2->show();
	wp = new MainWinPane(this, new zGravSizer(ZGRAV_MIDDLE,0,sizer()));
	wp->backgroundColor(zColor(0,0,255));
	wp->show();
}
int MyItemText::ch(zKeyEvt* Ev){
	switch(Ev->code())
	{
	case 0x0E:
		ItemString[index--]='\0';
		break;
	case 0x1C:
		ItemString[index=0]='\0';
		break;
	default:
		ItemString[index++]=Ev->ch();
		ItemString[index]='\0';
		break;
	}
        setText(zString(ItemString));
return 1;
}
	
int MyItemText::processTime(zEvent *ne)
{
	if(ne){
	tzset();
	time(&secs_now);
	time_now = localtime(&secs_now);
	strftime(TimeString,150,"%A  %B %d, %Y  %I:%M:%S %p",time_now);
	setText(TimeString);
	}
	return 1;
}
//
// Echo help text when user hilites menu option
//
int MyItem::processClick(zNotifyEvt *ne)
{
	if(ne->clicked()){
        	zMessage(this,"Button Pushed","TAO",MB_OK);
	}
	return 1;
}

//
// Mouse move function
int MyItemBmp::mouseButtonDown(zMouseClickEvt* bd){
	if(bd->isButtonDown(1) ){
		captureMouse();
		((zStatusItemBitmap*)pIB->item(R1))->setBitmap(okBitmap2);
		((zStatusItemBitmap*)pIB->item(R1))->canvas()->setDirty();
		zMessage(this,"An Apparition","Button Down",MB_OK);
		((zStatusItemBitmap*)pIB->item(R1))->setBitmap(okBitmap);
		((zStatusItemBitmap*)pIB->item(R1))->canvas()->setDirty();
	}return 1;}

//
int MyItemText::mouseMove(zMouseMoveEvt* )
{       if(down){
	setText(zString("Mouse Moving"));
        }
	return 1;
}

int MyItemText::mouseButtonDown(zMouseClickEvt* bd){
	if(bd->isButtonDown(1) && !down){
		captureMouse();
		setText(zString("Button Down"));
		down = 1;
	}return 1;}

int MyItemText::mouseButtonUp(zMouseClickEvt* bu){
	if (bu->isButton(1)){
		releaseMouse();
		down = 0;
		canvas()->setDirty();}
	return 1;}
//
// Mouse move function for StatBar
//
int MyBar::mouseMove(zMouseMoveEvt* )
{       if(down){
	setTextJustify(TEXT_RIGHT);
	setText(zString("Mouse Moving"));}
	setTextJustify(TEXT_CENTER);
	
	return 1;
}
int MyBar::mouseButtonDown(zMouseClickEvt* bd)
{
	if(bd->isButtonDown(1) && !down)
	{
		captureMouse();
		setTextJustify(TEXT_CENTER);
		setText(zString("Button Down"));
		canvas()->setDirty();
		down = 1;
	}
	return 1;
}
int MyBar::mouseButtonUp(zMouseClickEvt* bu){
	if (bu->isButton(1)){
		releaseMouse();
		down = 0;
		canvas()->setDirty();}
	return 1;}

int MainWin::MenuSelect(zMenuHiliteEvt *Ev)
{
	char szBuff[150];

	if(!((zMenuHiliteEvt *)Ev)->isPopup()&&!((zMenuHiliteEvt *)Ev)->isSystemMenu())
	{
		LoadString(app->instance(), ((zMenuHiliteEvt *)Ev)->id(),
			szBuff, sizeof(szBuff));

			pIB2->canvas()->setDirty();
			pIB2->setText(zString(szBuff));
	}
	else	pIB2->setText(zString(""));

        return 1;
}

int MainWin::command(zCommandEvt *Ev){ 
	zColor iColor2 (255,0,0);
	zColor iColor1 (0,0,0);
	zColor iColor3 (192,192,192);
	zFont* NewFont= new zFont("Helv",zPrPoint(200,200,pIB2->canvas()),ffDontCare);
	MyItemText* temp;
	zPane* about;
	MyItemText* abar;
	switch (Ev->cmd())
	{
	
		case ID_RECESS3:
			((zStatusItemText*)pIB->item(R3))->setText(zString("Recess #3"));
			break;
		case ID_RECESS4:
			((zStatusItemText*)pIB->item(R4))->setText(zString("Recess #4"));
			break;
                case ID_DELETE:
			pIB->deleteItem(R5);
			break;
		case ID_INSERT:
			temp = new MyItemText(pIB,new zGravSizer(ZGRAV_MIDDLE,0,pIB->sizer()),S_3DR,iColor3, R5);
			pIB->insertItem(temp, 4);
			break;
		case ID_FONT:
			pIB2->setTextFont(NewFont);
			pIB2->setBarHeight(40);
			break;
		case ID_EXIT:
			app->quit();
			break;
		case ID_ABOUT:
			about = new zPane(wp, new zGravSizer(ZGRAV_CENTER,zDimension(400,300),wp->sizer()),WS_THICKFRAME);
			about->show();
			abar = new MyItemText(about,new zGravSizer(ZGRAV_BOTTOM,20,about->sizer()),S_3DR,iColor3,R6);
			abar->show();
			about->canvas()->lock();
			about->canvas()->pushPen(new zPen(BlackPen));
			int i,j,l,m;
			for(i=0;i<3;i++){
			   for(j=0;j<150;j++){
			      for(int k=0;k<3000;k++,l++);
											for(m=5;m<150;m+=4){
				    about->canvas()->circle(zPoint(150,50),j++);
				    about->canvas()->circle(zPoint(150,50),m++);
				    about->canvas()->rectangle(i,j,m,i);
                                 }
			   }
			}
			delete about->canvas()->popPen();
			about->canvas()->unlock();
			abar->setText(zString("Alan D. Stokes"));
			wp->canvas()->setDirty();
			break;
						default:
		return 0;	
	}
	return 1;
	

}

int MainWin::activate(zActivateEvt* e){
	if(pIB->item(R4))
		if(e->active()) pIB->item(R4)->setFocus();
	return 1;
}
MainWin::~MainWin(){}
MainWinPane::~MainWinPane()
{
}
void zApp::main()
{

	MainWin* p = new MainWin(0,zString(" Status Line Test Program! "));
	p->show(SW_MAXIMIZE);
	go();
	delete p;
}


