/*-----------------------------------------------------------------
	Starfield Animation
	by: Brent Edstrom - 1994


	IMPORTANT!  The following functions were written for VGA 320x200.
	Use at your own risk.

	This code is public domain. Let me know if you have
	comments or suggestions.  (I am a self taught programmer.)
	Enjoy!

-------------------------------------------------------------------*/

#include <conio.h>
#include <mem.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>

void setgmode(int mode);
int current_mode();
char plot(int xp, int yp,char col,char far *vid_mem);//returns previous color
void cls(char col, char far *vid_mem);

char far *screen=(char far *)MK_FP(0xa000,0);

#define VGA320x200 0x13
#define VIEWER_DISTANCE 125

class star{
	long xp;long yp;int zp; //position of star
	void init(); //init location of star
	public:
	int xspeed;
	int yspeed;
	int zspeed;
	star();
	void move(char far *draw_scn);
};
star::star(){
	//Movement of star.  Play with these numbers for some interesting effects
	xspeed=-1;
	yspeed=0;
	zspeed=-1;
	init(); //init location
}
void star::move(char far* draw_scn){
	if(zp<=2)
		init();
	//The heart of the program.  Convert 3d x,y,z position to 2d screen
	int scn_x=VIEWER_DISTANCE*xp/zp;
	int scn_y=VIEWER_DISTANCE*yp/zp;
	//Star movement
	zp=zp+zspeed;
	xp=xp+xspeed;
	yp=yp+yspeed;
	if(scn_x<=318 && scn_x>=2 && scn_y>=2 && scn_y<=198){
		if(zp>150){
			plot(scn_x,scn_y,LIGHTGRAY,draw_scn);//use light gray for distant star
		}else{
			plot(scn_x,scn_y,WHITE,draw_scn);//close stars are white
		}

	}else{
		init();//If star is off the screen, re init values.
	}

}
void star::init(){
	xp=1+random(310);
	yp=1+random(190);
	zp=2+random(200);
}
void credits(){
	clrscr();
	puts("-Star Simulator-");
	puts("by: Brent Edstrom ");
	puts("\nPress a key to start.  Any key to exit.");
	getch();
}
void main(void){
	//----------------create star field
	star *Star;
	if(!(Star=new star[65])){
		puts("Insufficient memory for star array");
		getch();
		exit(1);
	}
	//----------------create drawing buffer for animation
	char far *draw_buff;
	if(!(draw_buff=new char[64000])){
		puts("Insufficient memory for drawing buffer");
		getch();
		exit(1);
	}

	credits();

	int old_mode=current_mode();
	setgmode(VGA320x200);

	while(!kbhit()){
		cls(BLACK,draw_buff);//Clear drawing buffer.
		for(int cnt=0;cnt<64;cnt++){
			Star[cnt].move(draw_buff);
		}
		memmove(screen,draw_buff,64000);//Move drawing buffer to screen.
	}
	//set to previous video mode.
	setgmode(old_mode);
	delete draw_buff;
}

void setgmode(int mode)
{
	union REGS regs;
	regs.h.ah = 0;  // video set function
	regs.h.al = mode;
	int86(0x10, &regs, &regs);
}
int current_mode(){
	int cur_mode=*(int *)MK_FP(0x40,0x49);
	return cur_mode;
}
char plot(int xp,int yp,char col,char far *vid_mem){
	long vid_offset=yp*320+xp;
	char prev_col;
	if(vid_offset<64000){
		prev_col=vid_mem[vid_offset];
		vid_mem[vid_offset]=col;
	}
	return prev_col;
}
void cls(char col,char far *vid_mem){
	memset(vid_mem,col,64000);
}


