/* ------------------------------------------------------------------------ */
/*                                 sststr.h                                 */
/*                                                                          */
/*                        string handling functions                         */
/*                                                                          */
/*       CopyRight (C) 1991,1992  Steven Lutrov.  All rights reserved.      */
/* ------------------------------------------------------------------------ */


#ifdef EOS
#  undef EOS
#endif
#define  EOS      '\x00'                     /* define end of string char */

#define ulong unsigned long

/* ------------------------------------------------------------------------ */
/*                      constants used in strcvt function                   */
/* ------------------------------------------------------------------------ */

#define RABLANKS        0x0001  /* remove all blanks */
#define RANONALPHA      0x0002  /* remove all non alphabetic characters */
#define RANONNUM        0x0004  /* remove all non numeric characters */
#define RALEADBLANKS    0x0008  /* remove all leading blanks */
#define RTRBLANKS       0x0010  /* remove trailing blanks */
#define RAALPHA         0x0020  /* remove all alphabetic characters  */
#define RANUMERIC       0x0040  /* remove all numeric characters */
#define RAPUNCT         0x0080  /* remove all punctuation */
#define CMBTOBRD_SINGLE     0x0100  /* convert multiple blanks to single */
#define CLCTOUPPER      0x0200  /* convert lower case characters to upper */
#define CUCTOLOWER      0x0400  /* convert upper case characters to lower */
#define UCWORDS         0x0800  /* capitalize all words */
#define NUCWORDS        0x1000  /* un - capitalize all words */



/* ------------------------------------------------------------------------ */
/*                            function prototypes                           */
/* ------------------------------------------------------------------------ */

char  *strcomma         (long n);
char  *strcvt           (char *d, char *s, int option, int ml);
int   strisblank        (char *s);
char  *strcode          (char *s, char *k);
char  *strinsert        (char *a, char *s, int p);
char  *strleft          (char *s, int n);
char  *strljust         (char *s);
char  *strltrim         (char *s);
char  *strmiddle        (char *s, int p, int n);
char  *strright         (char *s, int n);
char  *strrjust         (char *s);
char  *strrotleft       (char *s, int n);
char  *strrotright      (char *s, int n);
char  *strrtrim         (char *s);
char  *strresize        (char *s, int n);
char  *strshiftleft     (char *s, int n);
char  *strshiftright    (char *s, int n);
char  *strtrim          (char *s);
char  *struplow         (char *s);
int   touplow           (char *s, char *p, int c);

/* ------------------------------------------------------------------------ */
/*                     case dependent string operations                     */
/* ------------------------------------------------------------------------ */

int   strchangechar     (char *s, int a, int b);
ulong strchecksum       (char *s);
char  *strdelete        (char *a, char *s);
char  *strdeleteall     (char *a, char *s);
char  *strinc           (char *a, char *s);
int   strcountchar      (char *s, int c);
char  *strchangestr     (char *s, char *a, char *b);
int   strcountstr       (char *a, char *s);
char  *strsrep          (char *s, char *a, char *b);

/* ------------------------------------------------------------------------ */
/*                     case  independent string operations                  */
/* ------------------------------------------------------------------------ */

int   strichange        (char *s, int a, int b);
ulong strichecksum      (char *s);
char  *stridelete       (char *a, char *b);
char  *strideleteall    (char *a, char *b);
char  *striinc          (char *a, char *s);
int   stricountchar     (char *s, int c);
char  *strichangestr    (char *s, char *a, char *b);
int   stricountstr      (char *a, char *s);
char  *strisrep         (char *s, char *a, char *b);

/* ------------------------------------------------------------------------ */
/*                                 macros                                   */
/* ------------------------------------------------------------------------ */

#define  strleft(s,n)   strmiddle(s,0,n)
#define  strright(s,n)  strmiddle(s,strlen(s)-n,n)



