/* ------------------------------------------------------------------------ */
/*                                sstmisc.c                                 */
/*                                                                          */
/*                    low-level miscellaneous functions                     */
/*                                                                          */
/*      CopyRight (C) 1991,1992  Steven Lutrov.   All rights reserved.      */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <dos.h>

#include "sstwin.h"


/* ------------------------------------------------------------------------ */
/*                   puts the current date out to the screen                */
/*      1 = dd-mm-yy   	2 = dd mmm yyyy   3 = mm-dd-yy    4 = yy-mm-dd      */
/* ------------------------------------------------------------------------ */
void mscputdate(int x, int y, int attr, int fmt )
{
  char *MonthArray[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
			   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
  struct date dt;

  getdate(&dt);
  switch(fmt) {
     case 1:
	     vputf(x, y, attr,"%2d-%02d-%02d", dt.da_day, dt.da_mon,
		   dt.da_year % 100 );
	     break;
     case 2:
	     vputf(x, y, attr,"%2d %3s %04d", dt.da_day,
		   MonthArray[dt.da_mon-1], dt.da_year );
	     break;
     case 3:
	     vputf(x, y, attr,"%02d-%2d-%02d", dt.da_mon, dt.da_day,
		   dt.da_year % 100 );
	     break;
     case 4:
	     vputf(x, y, attr,"%02d-%02d-%2d", dt.da_year % 100 , dt.da_mon,
		   dt.da_day);
	     break;
	}
}

/* ------------------------------------------------------------------------ */
/*                     puts the current time onto the screen                */
/*                 1 = hh:mm:ss (military)   2 = hh:mm	(military)          */
/*		   3 = hh:mm:ss AM/PM        4 = hh:mm	AM/PM               */
/* ------------------------------------------------------------------------ */
void mscputtime(int x, int y, int attr, int fmt)
{
   struct time tm;
   char c;

   gettime(&tm);
   switch(fmt) {
	case 1:
		vputf(x, y, attr,"%2d:%02d:%02d",
			tm.ti_hour, tm.ti_min, tm.ti_sec );
		break;
	case 2:
		vputf(x, y, attr,"%2d:%02d",tm.ti_hour, tm.ti_min );
		break;
	case 3:
		c = 'A';
		if ( tm.ti_hour > 11 ) {
			c = 'P';
			tm.ti_hour -= 12;
		}
		if ( tm.ti_hour == 0 )  tm.ti_hour = 12;
		vputf(x, y, attr,"%2d:%02d:%02d %cM",
			tm.ti_hour, tm.ti_min, tm.ti_sec, c );
		break;
	case 4:
		c = 'A';
		if ( tm.ti_hour > 11 ) {
			c = 'P';
			tm.ti_hour -= 12;
		}
		if ( tm.ti_hour == 0 )  tm.ti_hour = 12;
		vputf(x, y, attr,"%2d:%02d %cM",
			tm.ti_hour, tm.ti_min, c );
		break;
   }
}

/* ------------------------------------------------------------------------ */
/*                           makes a beep noise                             */
/* ------------------------------------------------------------------------ */
void mscbeep(int m)
{
   if (m)    {
     sound(2000);
     delay(100);
   }
   else {
    sound(500);
    delay(250);
  }
 nosound();
}


