/* ------------------------------------------------------------------------ */
/*                                ssthelp.c                                 */
/*                   high-level help interface routines                     */
/*                                                                          */
/*      CopyRight (C) 1991,1992  Steven Lutrov.   All rights reserved.      */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <stdio.h>
#include <string.h>

#include "sstwin.h"
#include "sstkey.h"

#define MAXLINE     80          /* maximum help line width  */
#define MAXHELPS    25          /* maximum help topics */

static struct helps {
	char hname [9];     /* help name */
	int h, w;           /* height and width */
	long hptr;          /* pointer to help text */
} hps [MAXHELPS+1];

static int hp = 0;
static int ch = 0;
static int hx, hy;          /* x and y coordinates for help screen */
FILE   *helpfp = NULL;
char   helpname[64];        /* help tag name */


/* ------------------------------------------------------------------------ */
/*                        local function declerartions                      */
/* ------------------------------------------------------------------------ */

void   getline      (char *lineh);
void   help         (void);

/* ------------------------------------------------------------------------ */
/*                      load the HELP! definition file                      */
/* ------------------------------------------------------------------------ */
void Hload(char *hn)
{
	extern void (*helpfunc)();
	extern int helpkey;
	char lineh [MAXLINE];

	if (strcmp(helpname, hn) == 0)
		return;
	helpfunc = help;
	helpkey = F1;
	hp = 0;
	strcpy(helpname, hn);
	if ((helpfp = fopen(helpname, "r")) == NULL)
		return;
	getline(lineh);
	while (1)	{
		if (hp == MAXHELPS)
			break;
		if (strncmp(lineh, "<end>", 5) == 0)
			break;
		if (*lineh != '<')
			continue;
		hps[hp].h = 3;
		hps[hp].w = 18;
		strncpy(hps[hp].hname, lineh+1,8);
		hps[hp].hptr = ftell(helpfp);
		getline(lineh);
		while (*lineh != '<')	{
			hps[hp].h++;
			hps[hp].w = max(hps[hp].w, strlen(lineh)+2);
			getline(lineh);
		}
		hp++;
	}
}

/* ------------------------------------------------------------------------ */
/*                  get a line of text from the help file                   */
/* ------------------------------------------------------------------------ */
static void getline(char *lineh)
{
	if (fgets(lineh, MAXLINE, helpfp) == NULL)
		strcpy(lineh, "<end>");
}

/* ------------------------------------------------------------------------ */
/*                   set the current active help screen                     */
/* ------------------------------------------------------------------------ */
void Hset(char *s, int x, int y)
{
	for (ch = 0; ch < hp; ch++)
		if (strncmp(s, hps[ch].hname,8) == 0)
			break;
	hx = x;
	hy = y;
}
/* ------------------------------------------------------------------------ */
/*                    display the current help window                       */
/* ------------------------------------------------------------------------ */
void help(void)
{
	char ln [MAXLINE];
	int i;
	WINDOW *wnd;
	extern int helpkey;

	if (hp && ch != hp)	{
	     vpushcur();
	     vhidecur();
	     if ((wnd = Westablish(hx, hy, hps[ch].h, hps[ch].w)) == NULL)
		 return;
	     Wsetcolour(wnd, WIN_ALL, LIGHTGRAY, BLACK, DIM);
	     Wsetcolour(wnd, WIN_BORDER, LIGHTGRAY, WHITE, DIM);
	     Wsettitle(wnd," [Help] Esc to return ",JUST_L);
	     Wshow(wnd);
	     fseek(helpfp, hps[ch].hptr, 0);
	     for (i = 0; i < hps[ch].h-3; i++)	{
		getline(ln);
		Wprintf(wnd, ln);
	     }
	     while (kgetch() != ESC );
	     Wdelete(wnd);
	     vpopcur();
	}
}

