/* ------------------------------------------------------------------------ */
/*                                 idemo.c                                  */
/*                        demo on input entry fields                        */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <stdlib.h>
#include <conio.h>

#include "sstkey.h"
#include "sstwin.h"



/* ------------------------------------------------------------------------ */
/*                              function prototypes                         */
/* ------------------------------------------------------------------------ */

static int    validate_state      (char *);
static int    validate_date       (char *s);
static void   help_date           (char *);
static int    spaces              (char *c);
int           endstroke           (int c);
void          ShowEntryAll        (void);


/* ------------------------------------------------------------------------ */
/*                         structures used for demo                         */
/* ------------------------------------------------------------------------ */

typedef struct _info {
   int  x;                  /* x coordinate of the input prompt */
   int  y;                  /* x coordinate of the input prompt */
   int  (*fvalid)(char *);  /* field validation function	*/
   void (*fhelp) (char *);  /* field help function */
   int  fht;                /* filed help type */
   int  ft;                 /* field type */
   int  fa;                 /* field entry conversion attribute */
   char *name;              /* fields name */
   char *mask;
} RECORD;

#define  RECORD_COUNT  11

RECORD r[RECORD_COUNT] =  /* text displayed in Information screen         */
{
   { 5, 2,  NULL,          NULL,      HELP_WAIT,   FLD_ASCII,  FLD_ZFILL |
							       JUST_L,
     "Forced uppercase ascii :", "__________"},
   { 5, 3,  NULL,          NULL,      HELP_WAIT,   FLD_ASCII,  FLD_ZFILL |
							       JUST_R,
     "Forced lowercase Ascii :", "__________"},
   { 5, 4,  NULL,          NULL,      HELP_WAIT,   FLD_DIGIT,  JUST_L,
     "Any Digit              :", "__________"},
   { 5, 5,  NULL,          NULL,      HELP_WAIT,   FLD_ASCII,  JUST_R,
     "Any Ascii chars        :", "__________"},
   { 5, 6,  NULL,          NULL,      HELP_WAIT,   FLD_PRINT,  0,
     "Any printable chars    :", "__________"},
   { 5, 7,  NULL,          NULL,      HELP_WAIT,   FLD_XDIGIT, FLD_TOUPPER,
     "HeX Digit only         :", "__________"},
   { 5, 8,  NULL,          NULL,      HELP_WAIT,   FLD_ALNUM,  FLD_TOUPPER,
     "Forced uppercase Alpha :", "__________"},
   { 5, 9,  NULL,          NULL,      HELP_WAIT,   FLD_ALNUM,  FLD_TOLOWER,
     "Forced lowercase Alpha :", "__________"},
   { 5, 10, validate_date, help_date, HELP_NOWAIT, FLD_DATE,   0,
     "Date                   :", "__/__/__"},
   { 5, 11, NULL,          NULL,      HELP_WAIT,   FLD_INT,    0,
     "Integer value          :", "____"},
   { 5, 12, NULL,          NULL,      HELP_WAIT,   FLD_CURR,   0,
     "Currency value         :", "$___.__"},
};


char *drec[RECORD_COUNT] = {
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "yes       ",
	     "11        ",
	     "1234",
	     "13  ",
};

/* ------------------------------------------------------------------------ */
/*                     test for an ending keystroke                         */
/* this function is used to overide the default ending keystroke function   */
/*          this is used in setting implemention-dependant values           */
/* ------------------------------------------------------------------------ */
int endstroke(int c)
{
    switch (c)	{
	case '\r':
	case '\n':
	case '\t':
	case ESC:
	case F8:
	case F9:
	case F10:
	case PGUP:
	case PGDN:
	case HOME:
	case END:
	case UP:
	case DOWN:
		return TRUE;
	default:
		return FALSE;
	}
}

/* ------------------------------------------------------------------------ */
/*                       validate the state that is entered                 */
/* ------------------------------------------------------------------------ */
static int validate_state(char *bf)
{
	static char *states [] = {"","VIC","NSW","QLD","NT","WA","SA",
				  "TAS",NULL};
	char **st = states;

	while (*st)
		if (strcmp(*st++, bf) == 0)
			return OK;
	Wemsg("Invalid State");
	return ERROR;
}

/* ------------------------------------------------------------------------ */
/*                             provide today's date                         */
/* ------------------------------------------------------------------------ */
static void help_date(char *bf)
{
  struct date dat;

  getdate(&dat);
  sprintf(bf, "%02d%02d%02d",dat.da_day, dat.da_mon, dat.da_year % 100);
}


/* ------------------------------------------------------------------------ */
/*                          test for spaces                                 */
/* ------------------------------------------------------------------------ */
static int spaces(char *c)
{
	while (*c == ' ')
		c++;
	return !*c;
}

/* ------------------------------------------------------------------------ */
/*                            validate a date                               */
/* ------------------------------------------------------------------------ */
static int validate_date(char *s)
/* format == DD/MM/YY */

{
	static int days [] =
		{ 31,28,31,30,31,30,31,31,30,31,30,31 };
	char date [7];
	int mo;

	strcpy(date, s);
	if (spaces(date))
		return OK;
	days[1] = (atoi(date+4)%4) ? 28 : 29;  /* test February */
	*(date + 4) = '\0';
	mo = atoi(date+2);
	*(date+2) = '\0';
	if (mo && mo<13 && atoi(date) && atoi(date)<=days[mo-1])
		return OK;
	Wemsg("Invalid date");
	return ERROR;
}


/* ------------------------------------------------------------------------ */
/*                         demo 2 on entry fields                           */
/* ------------------------------------------------------------------------ */
void ShowEntryAll(void)

{
    WINDOW *wnd;
    FIELD  *fld;
    int c, ch = 0;

    wnd = Westablish(10, 5, 18, 60);
    Wsettitle(wnd, " Order Entry ",JUST_C);
    Wsetcolour(wnd, WIN_BORDER, BLUE, YELLOW,  DIM);
    Wsetcolour(wnd, WIN_TITLE,  BLUE, YELLOW, DIM);
    Wsetcolour(wnd, WIN_FACE, BLUE, LIGHTGRAY, DIM);
    Wsetcolour(wnd, WIN_ACCENT, LIGHTGRAY, BLUE, DIM);
    Wshow(wnd);

    Finittemplate(wnd);
    for (c = 0 ; c < RECORD_COUNT ; c++)  {
       Wprompt(wnd, r[c].x, r[c].y, r[c].name);
       fld = Festablish(wnd, r[c].x+28, r[c].y, r[c].mask,
			    drec[c], r[c].ft,r[c].fa);
       if (r[c].fvalid)
		 Fvalidate(fld, r[c].fvalid);
       if (r[c].fhelp)
		 Fsethelp(fld, r[c].fhelp,r[c].fht);
    }
    Fendfunction(endstroke);
    while ((ch != ESC) && (ch != F10))
	   ch = Fdataentry(wnd,0);
    Wdelete(wnd);
}

/* ------------------------------------------------------------------------ */
void main(void)

{
 ShowEntryAll();
}

