/* ------------------------------------------------------------------------ */
/*                                sstwin.h                                  */
/*                                                                          */
/*                           windows header file                            */
/*                                                                          */
/*      CopyRight (C) 1991,1992  Steven Lutrov.   All rights reserved.      */
/* ------------------------------------------------------------------------ */

#include <conio.h>
#include <stdlib.h>

#ifdef    TRUE
     #undef    TRUE
#endif
#ifdef    FALSE
     #undef    FALSE
#endif
#ifdef    ERROR
     #undef    ERROR
#endif
#ifdef    OK
     #undef    OK
#endif

#define   TRUE         1
#define   FALSE        0
#define   ERROR        -1
#define   OK           0
#define   ON           1
#define   OFF          0

#define   TABS         4

#define   SCREENWIDTH      (peekb(0x40,0x4a) & 255)
#define   SCREENHEIGHT     (visvga() || visega() ? peekb(0x40,0x84)+1 : 25)

#define   VIDEO            0x010   /* video interrupts */
#define   KEYBRD           0x016   /* keyboard interrupts */
#define   DOS              0x021   /* dos interrupts */
#define   CRIT             0x024   /* critical error handler */
#define   MOUSE            0x033   /* mouse interrupts */
#define   KBUSYLOOP        0x028   /* keyboard busy loop, intr handler */

/* ------------------------------------------------------------------------ */
/*                      input field controller structures                   */
/* ------------------------------------------------------------------------ */

typedef struct field {          /* data entry field description */
        char *fmask;            /* field data entry mask        */
        char *fprot;            /* field protection             */
        char *fbuff;            /* field buffer                 */
        int ftype;              /* field type                   */
        int fflags;             /* field flags                  */
        int frow;               /* field row                    */
        int fcol;               /* field column                 */
        void (*fhelp)(char *);  /* field help function          */
        char *fhwin;            /* field help window            */
        int flx, fly;           /* help window location         */
        int helptype;           /* class of help                */
        int (*fvalid)(char *);  /* field validation function    */
        struct field *fnxt;     /* next field on template       */
        struct field *fprv;     /* previous field on template   */
} FIELD;


/* ------------------------------------------------------------------------ */
/*                        window  controller structures                     */
/* ------------------------------------------------------------------------ */
typedef struct _wnd {
        int _wv;                  /* true if window is visible     */
        int _hd;                  /* true if window was hidden     */
        char *_ws;                /* points to window save block   */
        char *_tl;                /* points to window title        */
        int _tjust;               /* title justification           */
        int _wx;                  /* nw x coordinate               */
        int _wy;                  /* nw y coordinate               */
        int _ww;                  /* window width                  */
        int _wh;                  /* window height                 */
        int _wsp;                 /* scroll pointer                */
        int _sp;                  /* selection pointer             */
        int _cr;                  /* cursor x location             */
        int btype;                /* border type                   */
	int wcolour[5];           /* colours for window            */
        int _pn;                  /* previous normal colour        */
        struct _wnd *_nx;         /* points to next window         */
        struct _wnd *_pv;         /* points to previous window     */
        FIELD *_fh;               /* points to 1st data entry fld  */
        FIELD *_ft;               /* points to last data entry fld */
} WINDOW;

/* ------------------------------------------------------------------------ */
/*                         menu controller structures                       */
/* ------------------------------------------------------------------------ */
typedef struct w_menu {
        char *mname;              /* menu name */
        char **mselcs;            /* ptr to ptr of menu strings */
        void (**func)(int,int);   /* ptr to ptr of hook function */
} MENU;

/* ------------------------------------------------------------------------ */
/*                        window attribute components                       */
/* ------------------------------------------------------------------------ */

#define   WIN_BORDER       0x000           /* border or frame */
#define   WIN_TITLE        0x001           /* title area  */
#define   WIN_ACCENT       0x002           /* accent or highlight bar  */
#define   WIN_FACE         0x003           /* window face */
#define   WIN_FLDFACE      0x004           /* window field face */
#define   WIN_HOTKEY       WIN_FLDFACE     /* hot-key used for menu windows */
#define   WIN_ALL          0x005           /* all above components */

#define   BRIGHT           0x008           /* high intensity  */
#define   DIM              0x000           /* low intensity  */


/* ------------------------------------------------------------------------ */
/*                           window border components                       */
/* ------------------------------------------------------------------------ */

#define   BRD_SPACE        0x000           /* single line */
#define   BRD_SINGLE       0x001           /* single line */
#define   BRD_DOUBLE       0x002           /* double line */
#define   BRD_DOUBLESIDE   0x003           /* double sides & single top */
#define   BRD_DOUBLETOP    0x004           /* double top & single sides */
#define   BRD_SINGLESIDE   BRD_DOUBLETOP   /* ditto */
#define   BRD_SINGLETOP    BRD_DOUBLESIDE  /* ditto */

#define   BRD_PULLDOWN     0x005           /* used in pulldown menus */


/* ------------------------------------------------------------------------ */
/*                         justification components                         */
/* ------------------------------------------------------------------------ */
#define   JUST_C           0x000           /* centre justify */
#define   JUST_L           0x001           /* left justify */
#define   JUST_R           0x002           /* right justify */

/* ------------------------------------------------------------------------ */
/*                              field components                            */
/* ------------------------------------------------------------------------ */
#define   FIELDCHAR        0x05F           /* "_" char for field masks */

#define   FLD_ALNUM        0x001           /* alpha & numeric */
#define   FLD_ALPHA        0x002           /* alpha only */
#define   FLD_DIGIT        0x004           /* digit only */
#define   FLD_ASCII        0x008           /* ascii char only */
#define   FLD_PRINT        0x010           /* printable character */
#define   FLD_XDIGIT       0x020           /* hexadecimal char */
#define   FLD_DATE         0x040           /* date fromat char */
#define   FLD_INT          0x080           /* integer */
#define   FLD_CURR         0x100           /* currency format */

#define   FLD_TOUPPER      0x004           /* convert field to upper case */
#define   FLD_TOLOWER      0x008           /* convert field to lower case */
#define   FLD_NFILL        0x010           /* fill blanks with space char */
#define   FLD_ZFILL        0x020           /* fill blanks with zero char  */


/* ------------------------------------------------------------------------ */
/*                          menu spacing components                         */
/* ------------------------------------------------------------------------ */
#define   SPC_BETWEEN      0x01       /* menu space between items */
#define   SPC_LEFT         0x02       /* left end of menu spacing */
#define   SPC_RIGHT        0x04       /* right end of menu spacing */

/* ------------------------------------------------------------------------ */
/*                          help system components                          */
/* ------------------------------------------------------------------------ */
#define   HELP_NOWAIT      0x001           /* instant help on field */
#define   HELP_WAIT        0x002           /* wait for HELP keypress on field */
#define   HELP_DONE        0x010           /* help completed  */


/* ------------------------------------------------------------------------ */
/*                          quick access macros                             */
/* ------------------------------------------------------------------------ */
#define SAV              (wnd->_ws)
#define WTITLE           (wnd->_tl)
#define TJUST            (wnd->_tjust)
#define COL              (wnd->_wx)
#define ROW              (wnd->_wy)
#define WIDTH            (wnd->_ww)
#define HEIGHT           (wnd->_wh)
#define SCROLL           (wnd->_wsp)
#define SELECT           (wnd->_sp)
#define WCURS            (wnd->_cr)
#define WBORDER          (wnd->wcolour[WIN_BORDER])
#define WTITLEC          (wnd->wcolour[WIN_TITLE])
#define WACCENT          (wnd->wcolour[WIN_ACCENT])
#define WFACE            (wnd->wcolour[WIN_FACE])
#define WFIELD           (wnd->wcolour[WIN_FLDFACE])
#define PWIN_FACE        (wnd->_pn)
#define BTYPE            (wnd->btype)
#define NEXT             (wnd->_nx)
#define PREV             (wnd->_pv)
#define WCOLOUR          (wnd->wcolour)
#define VISIBLE          (wnd->_wv)
#define HIDDEN           (wnd->_hd)
#define FHEAD            (wnd->_fh)
#define FTAIL            (wnd->_ft)

#define NW               (wcs[wnd->btype].topleft)
#define NE               (wcs[wnd->btype].topright)
#define SE               (wcs[wnd->btype].botright)
#define SW               (wcs[wnd->btype].botleft)
#define SIDE             (wcs[wnd->btype].vert)
#define LINE             (wcs[wnd->btype].hor)

/* ------------------------------------------------------------------------ */
/*                      window functions and macros                         */
/* ------------------------------------------------------------------------ */
void    Wclear           (WINDOW *);
void    Wcloseall        (void);
void    Wcursor          (WINDOW *, int x, int y);
void    Wdelete          (WINDOW *);
void    Wemsg            (char *);
void    Wemsgclear       (void);
WINDOW  *Westablish      (int, int, int, int);
int     Wgetsel          (WINDOW *, int, char *);
void    Whide            (WINDOW *);
void    Wprintf          (WINDOW *, char *, ...);
void    Wprompt          (WINDOW *wnd, int, int, char *);
void    Wputch           (WINDOW *, int);
void    Wputchat         (WINDOW *wnd, int c, int bg, int fg, int i);
void    Wsetborder       (WINDOW *, int);
void    Wsetcolour       (WINDOW *, int, int, int, int);
void    Wsetintensity    (WINDOW *, int);
void    Wsettitle        (WINDOW *, char *, int);
void    Wshow            (WINDOW *);

#define Wforefront(wnd)  repos_wnd(wnd, 0, 0, 1)
#define Wmove(wnd,x,y)   repos_wnd(wnd, COL-x, ROW-y, 0)
#define Wrear(wnd)       repos_wnd(wnd, 0, 0, -1)
#define Wresetvideo(wnd) wnd->wcolour[WIN_FACE]=wnd->_pn
#define Wrevvideo(wnd)   wnd->wcolour[WIN_FACE]=wnd->wcolour[WIN_ACCENT]
#define Wrmove(wnd,x,y)  repos_wnd(wnd, x, y, 0)

/* ------------------------------------------------------------------------ */
/*                             editor function                              */
/* ------------------------------------------------------------------------ */
void    Eopen            (WINDOW *, char *, int);

/* ------------------------------------------------------------------------ */
/*                            menu functions                                */
/* ------------------------------------------------------------------------ */
int     Mselect          (MENU *mn);
void    Msetcolour       (int area,int bg,int fg,int inten);
void    Msetborder       (int btype);
void    Msettitle        (char *title, int just);
void    Msetspace        (int sp, int a);
void    Msetfullwidth    (int f);


/* ------------------------------------------------------------------------ */
/*                            help functions                                */
/* ------------------------------------------------------------------------ */
void    Hload            (char *);
void    Hset             (char *, int, int);

/* ------------------------------------------------------------------------ */
/*                         data entry functions                             */
/* ------------------------------------------------------------------------ */
void    Fcleartemplate   (WINDOW *wnd);
int     Fdataentry       (WINDOW *wnd, int p);
int     Fdataview        (WINDOW *wnd);
void    Fendfunction     (int (*f) (int));
FIELD   *Festablish      (WINDOW *wnd,int,int,char *,char *,int, int);
void    Finittemplate    (WINDOW *wnd);
void    Fnulltemplate    (WINDOW *wnd);
void    Fsethelpwin      (FIELD *, char *, int, int);
void    Fsethelp         (FIELD *f, void (*h)(char *), int w);
void    Ftally           (WINDOW *wnd);

#define Fprotect(f,s)    f->fprot=s
#define Fvalidate(f,v)   f->fvalid=v

/* ------------------------------------------------------------------------ */
/*                             video functions                              */
/* ------------------------------------------------------------------------ */

int  vblinkbit           (int flag);
void vclearrline         (unsigned char,unsigned char);
void vcls                (unsigned char);
void vfill               (int x, int y, int yy, int xx, int c, int a);
int  vget                (int x, int y);
int  vgeta               (int x, int y);
int  vgetac              (void);
int  vgetch              (int x, int y);
int  vgetchc             (void);
void vgetcur             (int *x, int *y);
void vhidecur            (void);
int  visega              (void);
int  visvga              (void);
void vnormalcur          (void);
void vpopcur             (void);
void vpopscreen          (void);
void vpushcur            (void);
int  vpushscreen         (void);
void vputch              (int x, int y, unsigned char a,
                          register unsigned char c);
void vputf               (int x, int y, unsigned char a, char *fmt, ...);
void vputfc              (int y, unsigned char attrib, char *fmt, ...);
void vputs               (int x, int y, unsigned char a, register char *s);
void vputsc              (int y, unsigned char a, char *s);
void vset25              (void);
void vset43              (void);
void vset50              (void);
void vsetcur             (int x, int y);
void vsetcurtype         (unsigned t);
void vshowcur            (void);


/* ------------------------------------------------------------------------ */
/*                           keyboard functions                             */
/* ------------------------------------------------------------------------ */
int  kgetch              (void);
int  kkeyhit             (void);
int  far *kstate         (void);

/* ------------------------------------------------------------------------ */
/*                           miscellaneous functions                        */
/* ------------------------------------------------------------------------ */
void mscbeep             (int mode);
void mscputdate          (int x, int y, int attr, int fmt);
void mscputtime          (int x, int y, int attr, int fmt);


/* ------------------------------------------------------------------------ */
/*                        mouse  functions and macros                       */
/* ------------------------------------------------------------------------ */
int  msinstalled         (void);
void msgetpos            (int *x, int *y);
void mshide              (void);
int  mspressed           (void);
int  msreleased          (void);
void msreset             (void);
void mssetpos            (int x, int y);
void mssettravel         (int, int, int, int);
void msshow              (void);

#define msgetch()        while(mspressed());
#define msleftpressed()  (mspressed()&1)
#define msrightpressed() (mspressed()&2)

/* ------------------------------------------------------------------------ */
/*                       internal to window processes                       */
/* ------------------------------------------------------------------------ */
void    accent           (WINDOW *);
void    deaccent         (WINDOW *);
void    scroll           (WINDOW *, int);
void    repos_wnd        (WINDOW *, int, int, int);
void    acline           (WINDOW *, int);
void    displ            (WINDOW *wnd, int x, int y, int ch, int at);

#define accent(wnd)      acline(wnd, WACCENT)
#define deaccent(wnd)    acline(wnd, WFACE)


/* ------------------------------------------------------------------------ */
/*                          common access macros                            */
/* ------------------------------------------------------------------------ */
#define CLR(bg,fg,in)    ((fg)|(bg<<4)|(in))
#define VCH(ch,at)       ((ch&255)|(at<<8))
#define VAD(x,y)         ((y)*(SCREENWIDTH*2)+(x)*2)
#define VIDMODE          *(unsigned char far *) 0x00449lu
#define MONOSEG          0xb0000000L
#define COLORSEG         0xb8000000L
#define VIDSEG           (unsigned char far *) \
                         ((7 == VIDMODE) ? MONOSEG : COLORSEG )
#define ISMONO()         (VIDMODE == 7)
#define ISTEXT()         (VIDMODE < 4)

