/* ------------------------------------------------------------------------ */
/*                                sstmouse.c                                */
/*                         low-level mouse routines                         */
/*                                                                          */
/*      CopyRight (C) 1991,1992  Steven Lutrov.   All rights reserved.      */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>

#include "sstwin.h"

/* ------------------------------------------------------------------------ */
/*                        local function prototypes                         */
/* ------------------------------------------------------------------------ */

static void near mouse     (int m1,int m2,int m3,int m4);


/* ------------------------------------------------------------------------ */
/*                              global variables                            */
/* ------------------------------------------------------------------------ */

static union REGS regs;

/* ------------------------------------------------------------------------ */
/*            main mouse interrupt routine used by other functions          */
/* ------------------------------------------------------------------------ */
static void near mouse(int m1,int m2,int m3,int m4)
{
    regs.x.dx = m4;
    regs.x.cx = m3;
    regs.x.bx = m2;
    regs.x.ax = m1;
    int86(MOUSE, &regs, &regs);
}

/* ------------------------------------------------------------------------ */
/*                             reset the mouse                              */
/* ------------------------------------------------------------------------ */
void msreset(void)
{
    mouse(0,0,0,0);
}

/* ------------------------------------------------------------------------ */
/*                 test to see if the mouse driver is installed             */
/* ------------------------------------------------------------------------ */
int msinstalled(void)
{
    unsigned char far *ms;
    ms = MK_FP(peek(0, MOUSE*4+2), peek(0, MOUSE*4));
    return (SCREENWIDTH <= 80 && ms != NULL && *ms != 0xcf);
}

/* ------------------------------------------------------------------------ */
/*                  return true if mouse buttons are pressed                */
/* ------------------------------------------------------------------------ */
int mspressed(void)
{
    if (msinstalled())
        mouse(3,0,0,0);
    return regs.x.bx & 3;
}

/* ------------------------------------------------------------------------ */
/*                          return mouse coordinates                        */
/* ------------------------------------------------------------------------ */
void msgetpos(int *x, int *y)
{
    if (msinstalled())    {
        mouse(3,0,0,0);
        *x = regs.x.cx/8;
        *y = regs.x.dx/8;
		if (SCREENWIDTH == 40)
			*x /= 2;
    }
}

/* ------------------------------------------------------------------------ */
/*                         position the mouse cursor                        */
/* ------------------------------------------------------------------------ */
void mssetpos(int x, int y)
{
    if (msinstalled())	{
		if (SCREENWIDTH == 40)
			x *= 2;
        mouse(4,0,x*8,y*8);
	}
}

/* ------------------------------------------------------------------------ */
/*                          display the mouse cursor                        */
/* ------------------------------------------------------------------------ */
void msshow(void)
{
    if (msinstalled())
        mouse(1,0,0,0);
}

/* ------------------------------------------------------------------------ */
/*                           hide the mouse cursor                          */
/* ------------------------------------------------------------------------ */
void mshide(void)
{
    if (msinstalled())
        mouse(2,0,0,0);
}

/* ------------------------------------------------------------------------ */
/*               return true if a mouse button has been released            */
/* ------------------------------------------------------------------------ */
int msreleased(void)
{
    if (msinstalled())
        mouse(6,0,0,0);
    return regs.x.bx;
}

/* ------------------------------------------------------------------------ */
/*                          set mouse travel limits                         */
/* ------------------------------------------------------------------------ */
void mssettravel(int minx, int maxx, int miny, int maxy)
{
    if (msinstalled())	{
		if (SCREENWIDTH == 40)	{
			minx *= 2;
			maxx *= 2;
		}
		mouse(7, 0, minx*8, maxx*8);
		mouse(8, 0, miny*8, maxy*8);
	}
}
