/* ------------------------------------------------------------------------ */
/*                                 wdemo.c                                  */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <stdlib.h>
#include <conio.h>

#include "sstkey.h"
#include "sstwin.h"

void WinTitlesColours  (void);
void WinPromote        (void);
void WinFast           (void);
void WinMove           (void);


/* ------------------------------------------------------------------------ */
/*                           demo on windows                                */
/* ------------------------------------------------------------------------ */
void WinTitlesColours(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(1, 1, 4, 40);
	wndB = Westablish(4, 10, 4, 40);
	wndC = Westablish(8, 20, 4, 40);
	Wsetcolour(wndA, WIN_ALL, GREEN, BLACK, DIM);
	Wsetcolour(wndB, WIN_ALL, LIGHTGRAY, BLUE, DIM);
	Wsetcolour(wndC, WIN_ALL, CYAN, BLUE, DIM);
	Wsettitle(wndA,"Left",JUST_L);
	Wsettitle(wndB,"Right",JUST_R);
	Wsettitle(wndC,"Centre",JUST_C);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wprintf(wndA,"Press R G B 1 2 3 keys");
	do	{
		c = kgetch();
		switch (c)	{
			case 'r':
				Wsettitle(wndB, " RED ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, RED, WHITE, BRIGHT);
				break;
			case 'b':
				Wsettitle(wndB, " BLUE ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, BLUE, WHITE, BRIGHT);
				break;
			case 'g':
				Wsettitle(wndB, " GREEN ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, GREEN, WHITE, BRIGHT);
				break;
			case '1': {
				Wsettitle(wndA, "Centre",JUST_C);
				Wsettitle(wndB, "Leff",JUST_L);
				Wsettitle(wndC, "Right",JUST_R);
				}
				break;
			case '2': {
				Wsettitle(wndA,"Right",JUST_R);
				Wsettitle(wndB,"Centre",JUST_C);
				Wsettitle(wndC,"Left",JUST_L);
				}
				break;
			case '3': {
				Wsettitle(wndA,"Left",JUST_L);
				Wsettitle(wndB,"Right",JUST_R);
				Wsettitle(wndC,"Centre",JUST_C);
				}
				break;
			default:
				break;
		}
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}

/* ------------------------------------------------------------------------ */
void WinPromote(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(5, 5, 9, 28);
	wndB = Westablish(10, 3, 9, 24);
	wndC = Westablish(13, 8, 9, 31);
	Wsetcolour(wndA, WIN_ALL, RED, YELLOW, DIM);
	Wsetcolour(wndB, WIN_ALL, CYAN, YELLOW, DIM);
	Wsetcolour(wndC, WIN_ALL, LIGHTGRAY, YELLOW, DIM);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wprintf(wndA, "\n\n Press A to promote me");
	Wprintf(wndB, "\n\n Press B to promote me");
	Wprintf(wndC, "\n\n Press C to promote me");
	do	{
		c = kgetch();
		switch (c)	{
			case 'a':	Wforefront(wndA);
						break;
			case 'b':	Wforefront(wndB);
						break;
			case 'c':	Wforefront(wndC);
						break;
			case 'A':	Wrear(wndA);
						break;
			case 'B':	Wrear(wndB);
						break;
			case 'C':	Wrear(wndC);
						break;
			default:	break;
		}
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}
/* ------------------------------------------------------------------------ */
void WinFast(void)
{
    int l,x,y;

    for (x = 0, y = 0; y < 16; x += 3, y++, l++)	{
		Westablish(x, y, 8,32);
		Wsetcolour(NULL, WIN_ALL, y, YELLOW, BRIGHT);
		Wshow(NULL);
		Wprintf(NULL," Fast win %d", l);
	}
    kgetch();
	while (y--)
		Wdelete(NULL);
}

/* ------------------------------------------------------------------------ */
void WinFast1(void)
{
    int l,x,y;

    for (x = 0, y = 0; y < 22; x += 3, y++, l++)	{
		Westablish(x, y, 3,14);
		Wsetcolour(NULL, WIN_ALL, y, YELLOW, BRIGHT);
		Wshow(NULL);
		Wprintf(NULL," Fast win %d", l);
	}
    kgetch();
	while (y--)
		Wdelete(NULL);
}


/* ------------------------------------------------------------------------ */
void WinFast2(void)
{
	int r, c, a;

	vblinkbit(0);
	for (r = 0, c = 0 , a = 7; a < 15; r += 9, c+=3, a++)	{
		Westablish(r, c, 4, 20);
		Wsetcolour(NULL, WIN_ALL, a, BLACK, BRIGHT);
		Wshow(NULL);
		Wprintf(NULL,"Fast window no  %d", a-6);
		Wprintf(NULL,"\nIntensity Enabled");
	}
	kgetch();
	while (c--)
		Wdelete(NULL);
	vblinkbit(1);
}


/* ------------------------------------------------------------------------ */
void WinMove(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(5, 5, 9, 19);
	wndB = Westablish(10, 3, 9, 23);
	wndC = Westablish(13, 8, 9, 12);
	Wsetcolour(wndA, WIN_ALL, RED, YELLOW, BRIGHT);
	Wsetcolour(wndB, WIN_ALL, CYAN, YELLOW, BRIGHT);
	Wsetcolour(wndC, WIN_ALL, LIGHTGRAY, YELLOW, BRIGHT);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wprintf(wndB, "\n I wouldn't care who");
	Wprintf(wndB, "\n wrote the laws if I");
	Wprintf(wndB, "\n could write the");
	Wprintf(wndB, "\n ballads.");
	Wprintf(wndB, "\n\n    Thomas Jefferson");
	do	{
		int x = 0, y = 0;
		c = kgetch();
		switch (c)	{
			case RIGHT:	x++;
						break;
			case LEFT:	--x;
						break;
			case UP:	--y;
						break;
			case DOWN:	y++;
			default:	break;
		}
		if (x || y)
			Wrmove(wndB, x, y);
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}

/* ------------------------------------------------------------------------ */
void main(void)

{
  WinTitlesColours();
  WinPromote();
  WinFast();
  WinFast1();
  WinFast2();
  WinMove();
}

