/* ------------------------------------------------------------------------ */
/*                                  demo.c                                  */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <stdlib.h>
#include <conio.h>

#include "sstkey.h"
#include "sstwin.h"

void ShowWinTitlesColours  (void);
void ShowWinPromote        (void);
void ShowWinFast           (void);
void ShowWinMove           (void);
void ShowEditor            (void);
void ShowEntry             (void);
void ShowEntryAll          (void);
void ShowVideo             (void);
void ShowList              (void);
void MainMenu              (void);

static void help_date      (char *bf);
static void get_list       (int s);

/* ------------------------------------------------------------------------ */
/*                           demo on windows                                */
/* ------------------------------------------------------------------------ */
void ShowWinTitlesColours(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(1, 1, 4, 40);
	wndB = Westablish(4, 10, 4, 40);
	wndC = Westablish(8, 20, 4, 40);
	Wsetcolour(wndA, WIN_ALL, GREEN, BLACK, DIM);
	Wsetcolour(wndB, WIN_ALL, LIGHTGRAY, BLUE, DIM);
	Wsetcolour(wndC, WIN_ALL, CYAN, BLUE, DIM);
	Wsettitle(wndA,"Left",JUST_L);
	Wsettitle(wndB,"Right",JUST_R);
	Wsettitle(wndC,"Centre",JUST_C);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wprintf(wndA,"Press R G B 1 2 3 keys");
	do	{
		c = kgetch();
		switch (c)	{
			case 'r':
				Wsettitle(wndB, " RED ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, RED, WHITE, BRIGHT);
				break;
			case 'b':
				Wsettitle(wndB, " BLUE ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, BLUE, WHITE, BRIGHT);
				break;
			case 'g':
				Wsettitle(wndB, " GREEN ",JUST_C);
				Wsetcolour(wndB, WIN_ALL, GREEN, WHITE, BRIGHT);
				break;
			case '1': {
				Wsettitle(wndA, "Centre",JUST_C);
				Wsettitle(wndB, "Leff",JUST_L);
				Wsettitle(wndC, "Right",JUST_R);
				}
				break;
			case '2': {
				Wsettitle(wndA,"Right",JUST_R);
				Wsettitle(wndB,"Centre",JUST_C);
				Wsettitle(wndC,"Left",JUST_L);
				}
				break;
			case '3': {
				Wsettitle(wndA,"Left",JUST_L);
				Wsettitle(wndB,"Right",JUST_R);
				Wsettitle(wndC,"Centre",JUST_C);
				}
				break;
			default:
				break;
		}
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}

/* ------------------------------------------------------------------------ */
void ShowWinPromote(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(5, 5, 9, 28);
	wndB = Westablish(10, 3, 9, 24);
	wndC = Westablish(13, 8, 9, 31);
	Wsetcolour(wndA, WIN_ALL, RED, YELLOW, DIM);
	Wsetcolour(wndB, WIN_ALL, CYAN, YELLOW, DIM);
	Wsetcolour(wndC, WIN_ALL, LIGHTGRAY, YELLOW, DIM);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wsetborder(wndA, BRD_SPACE);
	Wsetborder(wndB, BRD_DOUBLE);
	Wsetborder(wndC, BRD_DOUBLESIDE);
	Wprintf(wndA, "\n\n Press A to promote me");
	Wprintf(wndB, "\n\n Press B to promote me");
	Wprintf(wndC, "\n\n Press C to promote me");
	do	{
		c = kgetch();
		switch (c)	{
			case 'a':	Wforefront(wndA);
						break;
			case 'b':	Wforefront(wndB);
						break;
			case 'c':	Wforefront(wndC);
						break;
			case 'A':	Wrear(wndA);
						break;
			case 'B':	Wrear(wndB);
						break;
			case 'C':	Wrear(wndC);
						break;
			default:	break;
		}
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}
/* ------------------------------------------------------------------------ */
void ShowWinFast(void)
{
    int ofs, row, col, l = 0;

    for (ofs = 0 ; ofs < 36 ; ofs+=12) {
	for (row = 0, col = 0; col < 22; row += 2, col++, l++)	{
		Westablish(row+ofs, col, 3,14);
		Wsetcolour(NULL, WIN_ALL, col, YELLOW, BRIGHT);
		Wshow(NULL);
		Wprintf(NULL," Fast win %d", l);
	}
    }
    kgetch();
    for (ofs = 0 ; ofs < 3 ; ofs++)
	while (col--)
		Wdelete(NULL);
}


/* ------------------------------------------------------------------------ */
void ShowWinFast2(void)
{
	int r, c, a;

	vblinkbit(0);
	for (r = 0, c = 0 , a = 7; a < 15; r += 9, c+=3, a++)	{
		Westablish(r, c, 4, 20);
		Wsetcolour(NULL, WIN_ALL, a, BLACK, BRIGHT);
		Wshow(NULL);
		Wprintf(NULL,"Fast window no  %d", a-6);
		Wprintf(NULL,"\nIntensity Enabled");
	}
	kgetch();
	while (c--)
		Wdelete(NULL);
	vblinkbit(1);
}


/* ------------------------------------------------------------------------ */
/*                             demo on editor                               */
/* ------------------------------------------------------------------------ */
void ShowEditor(void)

#define LWID      (int)80
#define WHT       (int)14
#define PADHT          20

{
  char bf [PADHT] [LWID];
  char notefile [] = "test.txt";
  WINDOW *wnd;
  FILE *fp, *fopen();
  int i, ctr = 0;

	vshowcur();
	Hset("editor  ", 3, 8);
	setmem(bf, sizeof bf, ' ');
	if ((fp = fopen(notefile, "rt")) != NULL)	{
		while (fread(bf [ctr], LWID, 1, fp))
			ctr++;
		fclose(fp);
	}
	wnd = Westablish
		((80-(LWID+2))/2, (25-(WHT+2))/2, WHT+2, LWID+2);
	Wsetborder(wnd, 3);
	Wsettitle(wnd, "  Note Pad  ",JUST_C);
	Wsetcolour(wnd, WIN_ALL, BLUE, CYAN, DIM);
	Wsetcolour(wnd, WIN_ACCENT, CYAN, BLUE, DIM);
	Wsetcolour(wnd, WIN_FACE, BLUE, WHITE, DIM);
	Wshow(wnd);
	Eopen(wnd, (char*) bf, LWID * PADHT);
	Wdelete(wnd);
	ctr = PADHT;
	while (--ctr)	{
		for (i = 0; i < LWID; i++)
			if (bf [ctr] [i] != ' ')
				break;
		if (i < LWID)
			break;
	}
	fp = fopen(notefile, "w");
	for (i = 0; i < ctr+1; i++)
		fwrite(bf[i], LWID, 1, fp);
	fclose(fp);
}

struct {
	char name [26];
	char addr [26];
	char city [26];
	char state [3];
	char pcode [4];
	char amt [6];
	char dt [7];
	char phone [11];
} rcd;

char msk25     [] = "_________________________";
char mskamt    [] = "___.__";
char mskdate   [] = "__/__/__";
char mskphone  [] = "(___) ___-____";
char mskst     [] = "___";
char mskpcode  [] = "____";
/* ------------------------------------------------------------------------ */
/*                         demo on entry fields                             */
/* ------------------------------------------------------------------------ */
void ShowEntry(void)
{
	WINDOW *wnd;
	FIELD *fld;

	vshowcur();
	wnd = Westablish(10, 5, 15, 60);
	Wsettitle(wnd, " Order Entry ",JUST_C);
	Wsetcolour(wnd, WIN_ALL, BLUE, CYAN, DIM);
	Wsetcolour(wnd, WIN_ACCENT, LIGHTGRAY, BLACK, DIM);
	Wshow(wnd);
	Wprompt(wnd, 5, 2, "Name       :");
	Wprompt(wnd, 5, 3, "Address    :");
	Wprompt(wnd, 5, 4, "City       :");
	Wprompt(wnd, 5, 5, "State      :");
	Wprompt(wnd, 28, 5, "Post code :");
	Wprompt(wnd, 5, 10, "Phone     :");
	Wprompt(wnd, 5, 7, "Amount     :");
	Wprompt(wnd, 5, 8, "Date       :");
	Finittemplate(wnd);
	fld = Festablish(wnd, 18, 2, msk25, rcd.name, FLD_ALNUM,0);
	Fsethelpwin(fld,"name    ", 40, 1);
	fld = Festablish(wnd, 18, 3, msk25, rcd.addr, FLD_ALNUM,0);
	Fsethelpwin(fld,"address ", 40, 2);
	fld = Festablish(wnd, 18, 4, msk25, rcd.city, FLD_ALNUM,0);
	Fsethelpwin(fld,"address ", 40, 3);
	fld = Festablish(wnd, 18, 7, mskst, rcd.state, FLD_ALNUM,0);

	Fsethelpwin(fld,"state   ", 40, 4);
	fld = Festablish(wnd, 40, 5, mskpcode, rcd.pcode, FLD_INT,0);
	Fsethelpwin(fld,"address ", 40, 4);
	fld = Festablish(wnd,18,10,mskphone,rcd.phone, FLD_INT,0);
	Fsethelpwin(fld,"phone   ", 40, 9);
	fld = Festablish(wnd, 18, 7, mskamt, rcd.amt, FLD_CURR,0);
	Fsethelpwin(fld,"amount  ", 40, 8);
	fld = Festablish(wnd, 18, 8, mskdate, rcd.dt, FLD_DATE,0);
	Fsethelp(fld, help_date,HELP_WAIT);
	Fcleartemplate(wnd);
	Fdataentry(wnd,0);
	Wdelete(wnd);
}

/* ------------------------------------------------------------------------ */
/*                           provide today's date                           */
/* ------------------------------------------------------------------------ */
static void help_date(char *bf)
{
    struct date dat;

    getdate(&dat);
    sprintf(bf, "%02d%02d%02d",dat.da_day, dat.da_mon, dat.da_year % 100);
}



/* ------------------------------------------------------------------------ */
/*                         demo 2 on entry fields                           */
/* ------------------------------------------------------------------------ */
void ShowEntryAll(void)
{

struct {
	char alphanum [10];
	char alpha [10];
	char digit [10];
	char ascii [10];
	char print [10];
	char xdigit [10];
	char lower [10];
	char upper [10];
	char date [10];
	char integer [4];
	char curr    [5];
} r;

char msk10  []    = "__________";
char msk4   []    = "____";
char mskcurr[]    = "$___.__";

	WINDOW *wnd;

	wnd = Westablish(10, 5, 18, 50);
	Wsettitle(wnd, " Order Entry ",JUST_C);
	Wsetcolour(wnd, WIN_ALL, BLUE, CYAN, DIM);
	Wsetcolour(wnd, WIN_ACCENT, CYAN, BLACK, DIM);
	Wshow(wnd);
	Wprompt(wnd, 5, 2, "Alnum  :");
	Wprompt(wnd, 5, 3, "Alpha  :");
	Wprompt(wnd, 5, 4, "Digit  :");
	Wprompt(wnd, 5, 5, "Ascii  :");
	Wprompt(wnd, 5, 6, "Print  :");
	Wprompt(wnd, 5, 7, "XDigit :");
	Wprompt(wnd, 5, 8, "Lower  :");
	Wprompt(wnd, 5, 9, "Upper  :");
	Wprompt(wnd, 5, 10, "Date   :");
	Wprompt(wnd, 5, 11, "Int    :");
	Wprompt(wnd, 5, 12, "Curr   :");
	Finittemplate(wnd);
	Festablish(wnd, 15, 2,  msk10, r.alphanum, FLD_ALNUM,FLD_TOUPPER);
	Festablish(wnd, 15, 3,  msk10, r.alpha, FLD_ALNUM,FLD_TOLOWER);
	Festablish(wnd, 15, 4,  msk10, r.digit, FLD_DIGIT,JUST_R);
	Festablish(wnd, 15, 5,  msk10, r.ascii, FLD_ASCII,JUST_L);
	Festablish(wnd, 15, 6,  msk10, r.print, FLD_PRINT,0);
	Festablish(wnd, 15, 7,  msk10, r.xdigit, FLD_XDIGIT,0);
	Festablish(wnd, 15, 8,  msk10, r.lower, FLD_ALNUM,FLD_TOLOWER);
	Festablish(wnd, 15, 9,  msk10, r.upper, FLD_ALNUM,FLD_TOUPPER);
	Festablish(wnd, 15, 10, msk10, r.date, FLD_DATE,0);
	Festablish(wnd, 15, 11, msk4,  r.integer, FLD_INT,0);
	Festablish(wnd, 15, 12, mskcurr,  r.curr, FLD_CURR,0);
	Fcleartemplate(wnd);
	Fdataentry(wnd,0);
	Wdelete(wnd);
}

/* ------------------------------------------------------------------------ */
/*                        show how a window can be moved                    */
/* ------------------------------------------------------------------------ */
void ShowWinMove(void)
{
	WINDOW *wndA, *wndB, *wndC;
	int c;

	wndA = Westablish(5, 5, 9, 31);
	wndB = Westablish(10, 3, 9, 29);
	wndC = Westablish(13, 8, 9, 32);
	Wsetcolour(wndA, WIN_ALL, RED, YELLOW, BRIGHT);
	Wsetcolour(wndB, WIN_ALL, CYAN, YELLOW, BRIGHT);
	Wsetcolour(wndC, WIN_ALL, LIGHTGRAY, YELLOW, BRIGHT);
	Wshow(wndA);
	Wshow(wndB);
	Wshow(wndC);
	Wprintf(wndA, "\n I'm a less important window");
	Wprintf(wndC, "\n I'm a more important window");
	Wprintf(wndB, "\n     Actually a green");
	Wprintf(wndB, "\n    caterpillar is the");
	Wprintf(wndB, "\n ultimate visual evidence");
	Wprintf(wndB, "\n  of a nasty virus attack");
	Wprintf(wndB, "\n     on your computer.");
	do	{
		int x = 0, y = 0;
		c = kgetch();
		switch (c)	{
			case RIGHT:	x++;
						break;
			case LEFT:	--x;
						break;
			case UP:	--y;
						break;
			case DOWN:	y++;
			default:	break;
		}
		if (x || y)
			Wrmove(wndB, x, y);
	} while (c != ESC);
	Wdelete(wndA);
	kgetch();
	Wdelete(wndC);
	kgetch();
	Wdelete(wndB);
}

/* ------------------------------------------------------------------------ */
/*                            show direct video writes                      */
/* ------------------------------------------------------------------------ */
void ShowVideo(void)
{
   int  x;

   vputs(0,0,CYAN,"Look at this cyan title");
   for (x=1 ; x < 16 ; x++)
      vputf(0,5+x,x,"This is attribute %d",x);
}



static void get_list   (int s);
static int ht          (char **tb);
static int wd          (char **tb);

char *titles [] = {
	" 1 - int ",
	" 2 - char ",
	" 3 - float ",
	" 4 - unsigned ",
	" 5 - double ",0
};
WINDOW *pno [] = {0, 0, 0, 0, 0};
static int x [] = {20, 15, 29, 10, 17};
static int y [] = {5, 10, 13, 18, 6};
static int wcl [] [2] = {	{BLUE, WHITE},
				{MAGENTA, WHITE},
				{RED, WHITE},
				{GREEN, WHITE},
				{CYAN, WHITE}	};
char *sel1 [] = {
	 "Integer data type",
	 " ",
	 "Variables of type int are one word in length.",
	 "They can be signed (default) or unsigned,",
	 "which means they have a range of -32,768 to",
	 "32,767 and 0 to 65,535, respectively.",
	 0
};

char *sel2 [] = {

	"Character data type",
	" ",
	"Variables of type char are 1 byte in length.",
	"They can be signed (default) or unsigned,",
	"which means they have a range of -128 to 127",
	"and 0 to 255, respectively.",
	0
};

char *sel3 [] = {
	"Real number data type",
	" ",
	"Variables of type float are two words in",
	"length. Their range is 3.4E-38 to 3.4E+38.",
	" ",
	"Use of float or double requires linking in the",
	"floating-point math package. Turbo C++ will do",
	"this automatically if you use floating point",
	"in your program.",
	0
};

char *sel4 [] = {
	"A type modifier alters the meaning of the base",
	"type to yield a new type.",
	" ",
	"Each of these type modifiers can be applied to",
	"the base type int.",
	" ",
	"The modifiers signed and unsigned can be",
	"applied to the base type char.",
	0
};

char *sel5 [] = {
	"Real number data types",
	" ",
	"Variables of type double are four words in",
	"length. Their range is 1.7E-308 to 1.7E+308.",
	"Variables of type long double are five words",
	"in length. Their range is 3.4E-4932 to",
	"1.1E+4932",
	0
};
char **sel[] = {sel1,sel2,sel3,sel4,sel5,0};

/* ------------------------------------------------------------------------ */
/*                           show how to make a list box                    */
/* ------------------------------------------------------------------------ */
void ShowList(void)

{
	int s = 0, i, c;
	WINDOW *mn;
	char **cp;

	vsetcur(0, 25);
	mn = Westablish(0, 0, 7, 18);
	Wsettitle(mn, " Select A Type ",JUST_C);
	Wsetcolour(mn,WIN_BORDER,LIGHTGRAY,BLACK,DIM);
	Wsetcolour(mn,WIN_TITLE ,LIGHTGRAY,RED,DIM);
	Wsetcolour(mn,WIN_ACCENT,GREEN,BLACK,DIM);
	Wsetcolour(mn,WIN_FACE,LIGHTGRAY,BLACK,DIM);
	Wshow(mn);
	cp = titles;
	while (*cp)
		Wprintf(mn, "\n%s", *cp++);
	while (1)	{
		Hset("listtest", 40, 10);
		s = Wgetsel(mn, s+1, "12345");
		if (s == 0)
			break;
		if (s == RIGHT || s == LEFT)	{
			s = 0;
			continue;
		}
		Whide(mn);
		get_list(--s);
		c = 0;
		Hset("lists    ", 5, 15);
		while (c != ESC)	{
			c = kgetch();
			switch (c)	{
				case RIGHT:	Wrmove(pno[s], 1, 0);
							break;
				case LEFT:	Wrmove(pno[s], -1, 0);
							break;
				case UP:	Wrmove(pno[s], 0, -1);
							break;
				case DOWN:	Wrmove(pno[s], 0, 1);
							break;
				case DEL:	Wdelete(pno[s]);
							pno[s] = NULL;
							break;
				case '+':	Wforefront(pno[s]);
							break;
				case '-':	Wrear(pno[s]);
				default:	break;
			}
			if (c > '0' && c < '6')
				get_list(s = c - '1');
		}
		Wforefront(mn);
		Wshow(mn);
	}
	Wcloseall();
	for (i = 0; i < 5; i++)
		pno[i] = NULL;
}

/* ------------------------------------------------------------------------ */
/*                           activate a list by number                      */
/* ------------------------------------------------------------------------ */
static void get_list(int s)
{
	char **cp;
	static int lastp = -1;
	if (lastp != -1)
		Wsetintensity(pno[lastp], DIM);
	lastp = s;
	if (pno [s])
		Wsetintensity(pno[s], BRIGHT);
	else	{
		pno [s] = Westablish
			(x[s], y[s], ht(sel[s]), wd(sel[s]));
		Wsettitle(pno[s], titles[s],JUST_C);
		Wsetcolour(pno[s],WIN_ALL,wcl[s][0],wcl[s][1],BRIGHT);
		Wsetborder(pno[s], 1);
		Wshow(pno[s]);
		cp = sel[s];
		while (*cp)
			Wprintf(pno[s], "\n %s", *cp++);
	}
}
/* ------------------------------------------------------------------------ */
/*                   compute height of a window display table               */
/* ------------------------------------------------------------------------ */
static int ht(char **tb)
{
	int h = 0;
	while (*(tb + h++))	;
	return h + 3;
}
/* ------------------------------------------------------------------------ */
/*                    compute width of a window display table               */
/* ------------------------------------------------------------------------ */
static int wd(char **tb)
{
	int w = 0;
	while (*tb)		{
		w = max(w, strlen(*tb));
		tb++;
	}
	return w + 4;
}



/* ------------------------------------------------------------------------ */
/*                        pull down  menu tests                             */
/* ------------------------------------------------------------------------ */

char *wselcs[] = {
	" Colours Titles ",
	" Promote ",
	" Fast ",
	" Move ",
	NULL
};
char *eselcs[] = {
	" Orders ",
	" All Orders ",
	" Lists ",
	NULL
};
char *dselcs[] = {
	" Editor ",
	NULL
};
char *mselcs[] = {
	" Direct Video ",
	" Super Colors ",
	" Set 50 lines ",
	" Set 43 lines ",
	" Set 25 lines ",
	NULL
};

static void (*wfuncs[])()={ShowWinTitlesColours,ShowWinPromote,
			   ShowWinFast,ShowWinMove};
static void (*efuncs[])()={ShowEntry,ShowEntryAll,ShowList};
static void (*dfuncs[])()={ShowEditor};
static void (*mfuncs[])()={ShowVideo,ShowWinFast2,vset50,vset43,vset25};
static MENU tmn [] = {
	{" Windows ", 	wselcs, wfuncs},
	{" Entrys ",	eselcs, efuncs},
	{" Editor ",	dselcs, dfuncs},
	{" Misc  ", mselcs, mfuncs},
	{NULL,NULL,NULL}
};


void MainMenu(void)
{
    Msetcolour(WIN_BORDER,CYAN,WHITE,DIM);
    Msetcolour(WIN_TITLE ,CYAN,YELLOW,DIM);
    Msetcolour(WIN_ACCENT,BLUE,CYAN,BRIGHT);
    Msetcolour(WIN_FACE,CYAN,BLUE,DIM);
    Msettitle("[ Main pull-down menu ]",JUST_C);
    Msetfullwidth(1);
    Mselect(tmn);
}


extern int help_key = F1;

/* ------------------------------------------------------------------------ */
void main(void)

{
 Hload("demo.hlp");
 MainMenu();
}

