#define IBMPRO                /* define which printer codes to use   */

/*
**==========================================================================
**           P R I N T E R   C O N T R O L   S E Q U E N C E S
**==========================================================================
*/

/*
**   -----------------------
**    H P   L A S E R J E T 
**   -----------------------
*/
#ifdef HPLJ

#define LPP       57                   /* Lines Per Page                */
#define HMW       176                  /* Header Maximum Width          */
#define PNAME     "HPLJ (landscape)"   /* printer description           */
#define SEPCHAR   '|'                  /* separates line #'s from text  */
#define TMW       176                  /* Text Maximum Width            */

char HDRFONT[]  = {0x1B, 0x26, 0x6B, 0x32, 0x53, 0x00};  /* lineprinter font  */
char NO_ULINE[] = {0x1B, 0x26, 0x64, 0x40, 0x00};        /* underline off     */
char RESET[]    = {0x1B, 0x45, 0x00};                    /* reset printer     */
char SETUP[]    = {0x1B, 0x26, 0x6C, 0x31, 0x4F,         /* landscape         */
                   0x1B, 0x26, 0x6C, 0x38, 0x44, 0x00};  /* 8 lines per inch  */
char TXTFONT[]  = {0x1B, 0x26, 0x6B, 0x32, 0x53, 0x00};  /* lineprinter font  */
char ULINE[]    = {0x1B, 0x26, 0x64, 0x44, 0x00};        /* underline on      */

#endif  /* HPLJ */


/*
**   -------------------------------------------------------------
**    H P   L A S E R J E T   S E R I E S   I I   P O R T R A I T
**   -------------------------------------------------------------
*/
#ifdef HPLJ2

#define LPP       77                   /* Lines Per Page                */
#define HMW       80                   /* Header Maximum Width          */
#define PNAME     "HPLJ II (portrait)" /* printer description           */
#define SEPCHAR   ''                  /* separates line #'s from text  */
#define TMW       132                  /* Text Maximum Width            */

char HDRFONT[]  = {0x1B, 0x28, 0x73, 0x33, 0x54,         /* courier font      */
                   0x1B, 0x26, 0x6B, 0x30, 0x53, 0x00};  /* 10 pitch          */
char NO_ULINE[] = {0x1B, 0x26, 0x64, 0x40, 0x00};        /* underline off     */
char RESET[]    = {0x1B, 0x45, 0x00};                    /* reset printer     */
char SETUP[]    = {0x1B, 0x28, 0x31, 0x30, 0x55,         /* IBM PC char set   */
                   0x1B, 0x26, 0x6C, 0x38, 0x44, 0x00};  /* 8 lines per inch  */
char TXTFONT[]  = {0x1B, 0x26, 0x6B, 0x32, 0x53, 0x00};  /* lineprinter font  */
char ULINE[]    = {0x1B, 0x26, 0x64, 0x44, 0x00};        /* underline on      */

#endif  /* HPLJ2 */

/*
**   ---------------------------------------------------------------
**    H P   L A S E R J E T   S E R I E S   I I   L A N D S C A P E
**   ---------------------------------------------------------------
*/
#ifdef HPLJ2L

#define LPP       57                   /* Lines Per Page                */   
#define HMW       106                  /* Header Maximum Width          */   
#define PNAME     "HPLJ II (landscape)"/* printer description           */
#define SEPCHAR   ''                  /* separates line #'s from text  */   
#define TMW       176                  /* Text Maximum Width            */   

char HDRFONT[]  = {0x1B, 0x28, 0x73, 0x33, 0x54,         /* courier font      */
                   0x1B, 0x26, 0x6B, 0x30, 0x53, 0x00};  /* 10 pitch          */
char NO_ULINE[] = {0x1B, 0x26, 0x64, 0x40, 0x00};        /* underline off     */
char RESET[]    = {0x1B, 0x45, 0x00};                    /* reset printer     */
char SETUP[]    = {0x1B, 0x28, 0x31, 0x30, 0x55,         /* IBM PC char set   */
                   0x1B, 0x26, 0x6C, 0x31, 0x4F,         /* landscape         */
                   0x1B, 0x26, 0x6C, 0x38, 0x44, 0x00};  /* 8 lines per inch  */
char TXTFONT[]  = {0x1B, 0x26, 0x6B, 0x32, 0x53, 0x00};  /* lineprinter font  */
char ULINE[]    = {0x1B, 0x26, 0x64, 0x44, 0x00};        /* underline on      */

#endif  /* HPLJ2L */


/*
**   -----------------------------
**    I B M   P R O P R I N T E R
**   -----------------------------
*/
#ifdef IBMPRO

#define LPP       60                   /* Lines Per Page                */
#define HMW       80                   /* Header Maximum Width          */
#define PNAME     "IBM Proprinter"     /* printer description           */
#define SEPCHAR   ''                  /* separates line #'s from text  */
#define TMW       130                  /* Text Maximum Width            */

char HDRFONT[]  = {0x1B, 0x12, 0x00};        /* 10 cpi*/
char NO_ULINE[] = {0x1B, 0x2D, 0x30, 0x00};  /* underline off  */
char RESET[]    = {0x1B, 0x12,               /* 10 cpi         */
                   0x1B, 0x18, 0x00};        /* cancel data    */
char SETUP[]    = {0x00};                    /* you might want NLQ here */
char TXTFONT[]  = {0x1B, 0x0F,               /* condensed print*/
                   0x1B, 0x3A, 0x00};        /* 12 cpi         */
char ULINE[]    = {0x1B, 0x2D, 0x01, 0x00};  /* underline on   */

#endif  /* IBMPRO */


