/* 
**                        Source Print Utility
**                       ---------------------- 
**   
**
**   This is a simple program designed to print source files.
**   It will print the file name, page number, and date of last
**   modification at the top of each page.  Each line of code is
**   printed (usually in compressed mode) with it's relative line
**   number.
**
**   The program was written using Microsoft C v5.1. It should be
**   fairly easy to port to other printers (just change the escape
**   codes in SPU.H).  The code and executable are released to the
**   public domain.  All I ask is that if you make modifications
**   please change the version number and describe the changes
**   below.  (Place your modification notes *ABOVE* the previous
**   version's notes).  Also, I would appreciate it if you could
**   upload your new version to CompuServe.  Thanks and enjoy...
**
**   
**                                               J.C. Ratjen
**   
**   
**   
**      Date       Version     Comments
**    --------     -------    -----------------------------------------
**    06/02/89       1.1      Fixed bug where SPU went into an endless
**                            loop if it couldn't open the input file.
**
**                            Added wrapping of long lines
**
**                                                   JCR
**
**    04/17/89       1.0      Initial version released to public domain
**   
**                                                   J.C. Ratjen
**                                                   CIS [75006,2277]
*/


#include <dos.h>
#include <stdio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "spu.h"

#define FATTR     _A_ARCH|_A_HIDDEN|_A_RDONLY|_A_SYSTEM
#define MAXCHAR   512         /* Maximum number of chars per record  */
#define OFF       0
#define ON        1
#define TABVAL    3           /* Tab stops every 3 characters        */
                              /* (you may want to change this to 8   */
#define VERSION   "1.2"

void detab(), heading(), blurb(), get_fdate(), prn_cmd(), usage();

void main(argc, argv)
int argc;
char *argv[];
{
   FILE *fpin;
   int len, line, outline, pnum, status;
   char inrec[MAXCHAR+1], date[16];
   struct find_t finfo;

   blurb();
   if (argc<2) {
      usage();
      exit(0);
   }
   fflush(stdprn);
   prn_cmd(RESET);
   prn_cmd(SETUP);
   while (--argc) {
      status = _dos_findfirst(*++argv, FATTR, &finfo);
      while (!status) {
         if ((fpin=fopen(finfo.name,"r")) != NULL) {
            line = outline = pnum = 0;
            get_fdate(finfo.name, date);
            strupr(*argv);
            while (fgets(inrec,MAXCHAR,fpin)!=NULL) {
               line++;
               detab(inrec);
               len = strlen(inrec);
               if ((outline%LPP)==0 || !pnum)
                  heading(finfo.name,++pnum,date);
               fprintf(stdprn, "%4d%c  %.*s\r",line,SEPCHAR,TMW-7, inrec);
               outline++;
               if (len==(TMW-7))
                  fprintf(stdprn,"\n");
               while (len>(TMW-7)) {
                  memmove(inrec,&inrec[TMW-7],len-(TMW-8));
                  len = strlen(inrec);
                  fprintf(stdprn, "\n    %c  %.*s\r",SEPCHAR,TMW-7, inrec);
                  outline++;
               }
               printf("%s  line %d...\r",finfo.name,line);
            }
            fprintf(stdprn,"\f");
            printf("%s done, %d page%s printed.\n",finfo.name,pnum,pnum>1 ? "s" : "");
            fclose(fpin);
         }
         else 
            printf("%s - unable to open.\n",finfo.name);
         
         status = _dos_findnext(&finfo);
      }
   }
   prn_cmd(RESET);
}

void blurb()
{
   printf("Source Print Utility - version %s (%s)\n",VERSION, __DATE__);
   printf("<<< configured for %s >>>\n\n",PNAME);
}

void detab(str)
char *str;
{
   char *tmpstr;
	int cnt;

   cnt = 0;
   tmpstr = (char *)strdup(str);
   while (*tmpstr) {
      if (*tmpstr != '\t') 
         str[cnt++] = *tmpstr++;
      else {
         str[cnt++] = ' ';
         while (cnt%TABVAL) 
            str[cnt++] = ' ';
         tmpstr++;
      }
   }
   str[cnt] = '\0';
   free((char *)tmpstr);
}

void get_fdate(fname, dstr)
char *fname,
     *dstr;
{
   struct stat fdate;
   char tmpstr[26];

   if (!stat(fname, &fdate)) {
      strcpy(tmpstr,ctime(&fdate.st_atime));
      sprintf(dstr,"%.2s-%.3s-%.2s %.5s",&tmpstr[8],&tmpstr[4],&tmpstr[22],&tmpstr[11]);
   }
   else 
      *dstr = '\0';
}

void heading(fname,page,dstr)
char *fname;
int page;
char *dstr;
{
   int tmpint;

   if (page>1)
      fprintf(stdprn,"\f");
   tmpint = (HMW-10)/2;
   prn_cmd(HDRFONT);
   prn_cmd(ULINE);
   fprintf(stdprn," %-*sPage %-3d%*s \r\n\n",tmpint,fname,page,tmpint,dstr);
   prn_cmd(NO_ULINE);
   prn_cmd(TXTFONT);
}

void prn_cmd(cmd)
char *cmd;
{
   fputs(cmd,stdprn);
}

void usage()
{
   puts("Usage:   SPU file1 <file2> <fileN>\n");
}
