#include <dos.h>
#include <alloc.h>

void gitmap( int x, int y, unsigned char *bitmap, int byteswide,
			 int rows )
{
	char far *ptr;
	char far *bpt;
	int i, j;

	bpt = bitmap;

	for (j=0; j<rows; ++j)
	{
		ptr = (char far *)MK_FP( 0xA000, (y + j) * 320 + x);
		for (i=0; i<byteswide; ++i)
		{
			*bpt = *(ptr + i);
			bpt++;
		}
	}
}

void bitmap( int x, int y, unsigned char *bitmap,
			 int byteswide, int rows )
{
	char far *ptr;
	char far *bpt;
	int i, j;

	bpt = bitmap;

	for (j=0; j<rows; ++j)
	{
		ptr = (char far *)MK_FP( 0xA000, (y + j) * 320 + x);
		for (i=0; i<byteswide; ++i)
		{
			if (i + x < 320 && i + x >= 0)
				*(ptr + i) = *bpt;
			bpt++;
		}
	}
}

void bitmap( int x, int y, unsigned char *bitmap, char CDC,
			 int byteswide, int rows, char *redraw )
{
	char far *ptr;
	char far *bpt;
	char far *red;
	int i, j;

	bpt = bitmap;
	red = redraw;

	for (j=0; j<rows; ++j)
	{
		ptr = (char far *)MK_FP( 0xA000, (y + j) * 320 + x);
		for (i=0; i<byteswide; ++i)
		{
			if(*bpt != CDC && i + x < 320 && i + x >= 0)
			{
				*red = *(ptr + i);
				*(ptr + i) = *bpt;
			}
			red++;bpt++;
		}
	}
}

class sprite {
private:
	int x,y;
	char colorDontCare;
	int bmx,bmy;
	char *bitmapptr;
	char *reinsert;
	int hidden;
public:
	short init( char *, int, int, int, int, char );
	void close( void );
	void refresh( int, int );
	void refresh( char *, int, int );
	void refresh( char *, int, int, int, int );
	void hide( void );
	void unhide( void );
	short getx( void );
	short gety( void );
};

short sprite::init( char *bitmap, int xpos, int ypos,
					int xsiz, int ysiz, char CDC )
{
	bitmapptr = bitmap;
	x = xpos;
	y = ypos;
	bmx = xsiz;
	bmy = ysiz;
	hidden = 1;
	colorDontCare = CDC;

	reinsert = (char *)malloc( xsiz * ysiz );

	gitmap( x, y, reinsert, bmx, bmy );
	refresh( xpos, ypos );

	return (short)reinsert;
}

void sprite::close( void )
{
	free(reinsert);
}

void sprite::refresh( int xpos, int ypos )
{
	bitmap( x, y, reinsert, bmx, bmy );
	x = xpos;
	y = ypos;

	gitmap( x, y, reinsert, bmx, bmy );
	if (!hidden)
		bitmap( x, y, bitmapptr, colorDontCare, bmx, bmy, reinsert );
}

void sprite::refresh( char *newmap, int xpos, int ypos )
{
	bitmapptr = newmap;

	refresh( xpos, ypos );
}

void sprite::refresh( char *newmap, int xpos, int ypos, int sizx, int sizy )
{
	int hstat;

	hstat = hidden;

	if (!hstat)
		hide();

	free(reinsert);

	reinsert = (char *)malloc( sizx * sizy );
	bmx = sizx;
	bmy = sizy;

	refresh( newmap, xpos, ypos );

	if (!hstat)
		unhide();
}

void sprite::hide( void )
{
	bitmap( x, y, reinsert, bmx, bmy );
	hidden = 1;
}

void sprite::unhide( void )
{
	bitmap( x, y, bitmapptr, colorDontCare, bmx, bmy, reinsert );
	hidden = 0;
}

short sprite::getx( void )
{
	return x;
}

short sprite::gety( void )
{
	return y;
}