/**********************************************************************
	This sample demonsrates a more efficient alternative to using
	predefined controls when creating a spreadsheet type application.

   Copyright (c) 1991 Microsoft Corporation. All rights reserved.
***********************************************************************/
#include "windows.h"
#include "spdsheet.h"

HANDLE hInst;
HWND hEdit;
HWND hStatic;
BOOL bLastDot;
WORD wPresentRow = 0;
WORD wPresentColumn = 0;
char szPosition[6];
RECT CurrentRect;
char Cell[TOTAL_ROWS][TOTAL_COLUMNS][DATA_LENGTH];  /* Spreadshet data */
BOOL bEditCreated = FALSE;


int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
   MSG msg;

   if (!hPrevInstance)
      if (!InitApplication(hInstance))
         return FALSE;
   if (!InitInstance(hInstance, nCmdShow))
      return FALSE;
   while (GetMessage(&msg, NULL, NULL, NULL))
   {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return msg.wParam;
}


BOOL InitApplication(hInstance)
HANDLE hInstance;
{
   WNDCLASS wc;

   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
   wc.lpszMenuName = "spdsheetMenu";
   wc.lpszClassName = "spdsheetWClass";
   return RegisterClass(&wc);
}


BOOL InitInstance(hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
{
   HWND hWnd;

   hInst = hInstance;

   /* Create the main window */
   hWnd = CreateWindow("spdsheetWClass", "Spreadsheet Sample Application",
                       WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
                       WS_MINIMIZEBOX, CW_USEDEFAULT, CW_USEDEFAULT,
                       CLIENT_WIDTH, CLIENT_HEIGHT, NULL, NULL, hInstance,
                       NULL);
   if (!hWnd)
      return FALSE;
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   /* Create the edit control */
   hEdit = CreateWindow("Edit", NULL, WS_CHILD | WS_BORDER, LEFT_OF_EDIT,
                        TOP_OF_EDIT, EDIT_WIDTH, EDIT_HEIGHT, hWnd, NULL,
                        hInstance, NULL);
   if (!hEdit)
      return FALSE;
   ShowWindow(hEdit, SW_SHOWNORMAL);
   UpdateWindow(hEdit);
   SetFocus(hEdit);
   bEditCreated = TRUE;

   /* Create the static window to display the position of the current cell */
   hStatic = CreateWindow("Static", NULL, WS_CHILD | WS_BORDER,
                          LEFT_OF_POSITION, TOP_OF_POSITION, POSITION_WIDTH,
                          POSITION_HEIGHT, hWnd, NULL, hInstance, NULL);
   if (!hStatic)
      return FALSE;
   wsprintf(szPosition, "  %c%d", wPresentColumn + 65, wPresentRow + 1);
   SetWindowText(hStatic, szPosition);
   ShowWindow(hStatic, SW_SHOWNORMAL);
   UpdateWindow(hStatic);
   return TRUE;
}


long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{
   FARPROC lpProcAbout;
   static FARPROC lpfnDrawDots;
   HDC hDC;
   PAINTSTRUCT ps;
   int i, j;
   HPEN hSolidPen, hOriginalPen;
   RECT rect;
   char ColumnLetter[2];
   char szRowNumber[3];
   int x, y;
   char szEdit[40];

   switch (message)
      {
   case WM_CREATE:
      /* Call-back function to draw dotted vertical lines */
      lpfnDrawDots = MakeProcInstance(DrawDots, hInst);

      /* Store the rect. coordinates for the current cell */
      SetCurrentRect(wPresentRow, wPresentColumn);
      break;

   case WM_ACTIVATE:
      /* Edit control should always have the focus */
      if (bEditCreated)
      {
         SetFocus(hEdit);
         SetWindowText(hEdit, (LPSTR)Cell[wPresentRow][wPresentColumn]);
      }
      break;

   case WM_COMMAND:
      /* Draw edit control content on the current cell */
      if (HIWORD (lParam) == EN_CHANGE)
      {
         GetWindowText(hEdit, szEdit, 40);
         hDC = GetDC(hWnd);
         SetBkColor(hDC, RGB (192, 192, 192));
         DrawText(hDC, "                      ", -1, &CurrentRect, DT_LEFT);
         DrawText(hDC, (LPSTR)szEdit, -1, &CurrentRect, DT_LEFT);
         ReleaseDC(hWnd, hDC);
         lstrcpy(Cell[wPresentRow][wPresentColumn], szEdit);
         return DefWindowProc(hWnd, message, wParam, lParam);
      }
      else if (wParam == IDM_ABOUT)
      {
         lpProcAbout = MakeProcInstance(About, hInst);
         DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
         FreeProcInstance(lpProcAbout);
         break;
      }
      else
         return DefWindowProc(hWnd, message, wParam, lParam);

   case WM_PAINT:
      hDC = BeginPaint(hWnd, &ps);

      /* Create and Select a gray solid pen */
      hSolidPen = CreatePen(PS_SOLID, 1, RGB (0x80, 0x80, 0x80));
      hOriginalPen = SelectObject(hDC, hSolidPen);

      /* Draw horizontal gray lines for cells*/
      for (i = 2; i < TOTAL_HORZ_LINES; i++)
      {
         MoveTo(hDC, LEFT_OF_SHEET, TOP_OF_SHEET + CELL_HEIGHT * i);
         LineTo(hDC, CLIENT_WIDTH, TOP_OF_SHEET + CELL_HEIGHT * i);
      }

      /* Draw vertical dotted lines for cells */
      for (i = 1; i < TOTAL_VERT_LINES; i++)
      {
         bLastDot = TRUE; /* Flag for drawing dotted lines */
         LineDDA(CELL_WIDTH * i + NUM_COLUMN_WIDTH, TOP_OF_SHEET,
                 CELL_WIDTH * i + NUM_COLUMN_WIDTH, CLIENT_HEIGHT,
                 lpfnDrawDots, (LPSTR)&hDC);
      }

      /* Create and Select a black solid pen */
      hSolidPen = CreatePen(PS_SOLID, 1, RGB (0, 0, 0));
      DeleteObject(SelectObject(hDC, hSolidPen));

      /* Draw two black horizontal lines for column number cells */
      MoveTo(hDC, LEFT_OF_SHEET, TOP_OF_SHEET);
      LineTo(hDC, CLIENT_WIDTH, TOP_OF_SHEET);
      MoveTo(hDC, LEFT_OF_SHEET, TOP_OF_SHEET + CELL_HEIGHT);
      LineTo(hDC, CLIENT_WIDTH, TOP_OF_SHEET + CELL_HEIGHT);

      /* Draw four black vertical lines for column number cells */
      for (i = 1; i < TOTAL_VERT_LINES; i++)
      {
         MoveTo(hDC, CELL_WIDTH * i + NUM_COLUMN_WIDTH, TOP_OF_SHEET);
         LineTo(hDC, CELL_WIDTH * i + NUM_COLUMN_WIDTH,
                TOP_OF_SHEET + CELL_HEIGHT);
      }

      /* Draw a black vertical line for row number cells */
      for (i = 1; i < TOTAL_VERT_LINES; i++)
      {
         MoveTo(hDC, NUM_COLUMN_WIDTH, TOP_OF_SHEET);
         LineTo(hDC, NUM_COLUMN_WIDTH, CLIENT_HEIGHT);
      }
      DeleteObject(SelectObject(hDC, hOriginalPen));

      /* Draw letters for columns */
      rect.top = TOP_OF_SHEET + 1;
      rect.bottom = TOP_OF_SHEET + CELL_HEIGHT;
      ColumnLetter[0] = 'A';
      ColumnLetter[1] = 0;   /* NULL for the column letter string */
      SetBkColor(hDC, RGB (192, 192, 192));
      for (i = 0; i < 5; i++)
      {
         rect.left = 1 + NUM_COLUMN_WIDTH + CELL_WIDTH * i;
         rect.right = 1 + NUM_COLUMN_WIDTH + CELL_WIDTH + (CELL_WIDTH * i);
         DrawText(hDC, (LPSTR)ColumnLetter, 1, &rect, DT_CENTER);
         ColumnLetter[0]++;
      }

      /* Draw numbers for rows */
      rect.left = 0;
      rect.right = NUM_COLUMN_WIDTH;
      for (i = 0; i < TOTAL_CELL_ROWS; i++)
      {
         rect.top = 1 + TOP_OF_SHEET + CELL_HEIGHT + (CELL_HEIGHT * i);
         rect.bottom = TOP_OF_SHEET + CELL_WIDTH * 2 + CELL_WIDTH * i;
         wsprintf(szRowNumber, "%d", i + 1);
         DrawText(hDC, (LPSTR)szRowNumber, -1, &rect, DT_CENTER);
      }
      /* Hilight present cell */
      HighlightCell(hDC);

      /* Draw value corresponding to each cell */
      for (i = 0; i < TOTAL_ROWS; i++)
         for (j = 0; j < TOTAL_COLUMNS; j++)
         {
            SetCurrentRect(i, j);
            SetBkColor(hDC, RGB (192, 192, 192));
            DrawText(hDC, (LPSTR)Cell[i][j], -1, &CurrentRect, DT_LEFT);
         }
      EndPaint(hWnd, &ps);
      SetCurrentRect(wPresentRow, wPresentColumn);
      break;

   case WM_LBUTTONDOWN:
      x = LOWORD (lParam);
      y = HIWORD (lParam);
      /* if a cell should be selected, then do the processing */
      if (x >= NUM_COLUMN_WIDTH && y >= (TOP_OF_SHEET + CELL_HEIGHT))
      {
         /* Calculate the cell number from x and y */
         x -= NUM_COLUMN_WIDTH;
         y -= TOP_OF_SHEET + CELL_HEIGHT;
         wPresentColumn = x / CELL_WIDTH;
         wPresentRow = y / CELL_HEIGHT;

         /* Display the new position */
         wsprintf(szPosition, "  %c%d", wPresentColumn + 65, wPresentRow + 1);
         SetWindowText(hStatic, szPosition);

         /* Remove the highlight from the old cell */
         hDC = GetDC(hWnd);
         HighlightCell(hDC);

         /* Highlight th new cell and copy its content to the edit control */
         SetCurrentRect(wPresentRow, wPresentColumn);
         SetWindowText(hEdit, (LPSTR)Cell[wPresentRow][wPresentColumn]);
         HighlightCell(hDC);
         ReleaseDC(hWnd, hDC);
      }
      break;

   case WM_DESTROY:
      PostQuitMessage(0);
      break;

   default:
      return DefWindowProc(hWnd, message, wParam, lParam);
      }
   return 0;
}


BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
   switch (message)
      {
   case WM_INITDIALOG:
      return TRUE;

   case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
      {
         EndDialog(hDlg, TRUE);
         return TRUE;
      }
      break;
      }
   return FALSE;
}


void FAR PASCAL DrawDots(X, Y, lphDC)
/* This function is used to draw the vertical dotted lines */
int X;
int Y;
LPSTR lphDC;
{
   if (!bLastDot)
      SetPixel(*(HDC far *)lphDC, X, Y, 0);
   bLastDot = !bLastDot;
}


void SetCurrentRect(Row, Column)
WORD Row;
WORD Column;
{
   CurrentRect.left = 3 + NUM_COLUMN_WIDTH + Column * CELL_WIDTH;
   CurrentRect.top = 2 + TOP_OF_SHEET + CELL_HEIGHT + Row * CELL_HEIGHT;
   CurrentRect.right = CurrentRect.left + CELL_WIDTH - 5;
   CurrentRect.bottom = CurrentRect.top + CELL_HEIGHT - 4;
}


void HighlightCell(hDC)
HDC hDC;
{
   /* Draw highlite on left */
   PatBlt(hDC, CurrentRect.left - 2, CurrentRect.top - 1, 1,
          CurrentRect.bottom - CurrentRect.top + 1, DSTINVERT);

   /* Draw highlite on top */
   PatBlt(hDC, CurrentRect.left, CurrentRect.top - 1,
          CurrentRect.right - CurrentRect.left, 1, DSTINVERT);

   /* Draw highlite on right */
   PatBlt(hDC, CurrentRect.right + 1, CurrentRect.top - 1, 1,
          CurrentRect.bottom - CurrentRect.top + 1, DSTINVERT);

   /* Draw highlite on bottom */
   PatBlt(hDC, CurrentRect.left - 1, CurrentRect.bottom + 1,
          CurrentRect.right - CurrentRect.left + 1, 1, DSTINVERT);
}

