//----------------------------------------------------------------------------
//    Farpoint Spreadsheet Example
//----------------------------------------------------------------------------

#include <mem.h>

#include <owl\applicat.h>
#include <owl\checkbox.h>
#include <owl\dc.h>
#include <owl\edit.h>
#include <owl\framewin.h>
#include <owl\owlpch.h>
#include <owl\point.h>
#include <owl\radiobut.h>

#include "spread.h"
#include "spread.rh"

const char   AppName[] = "Spread"; // Name of app, window title & icon resource id
InspectData  Attributes;

DEFINE_RESPONSE_TABLE1(InspectDialog,TDialog)
  EV_COMMAND( IDOK, CmOk ),
END_RESPONSE_TABLE;


InspectDialog::InspectDialog( TWindow *parent, TResID resid )
  : TDialog( parent, resid )
{
  SetTransferBuffer( &Attributes );
  new TCheckBox( this, IDC_CHECKBOLD, 0 );
  new TCheckBox( this, IDC_CHECKITALIC, 0 );
  new TCheckBox( this, IDC_CHECKSTRIKE, 0 );
  new TCheckBox( this, IDC_CHECKUNDER, 0 );

  new TRadioButton( this, IDC_EDIT, 0 );
  new TRadioButton( this, IDC_NUMERIC, 0 );
  new TRadioButton( this, IDC_TEXT, 0 );
  new TEdit( this, IDC_FORMULA, FORMULA_LEN );
}

void InspectDialog::CmOk()
{
	 TDialog::CmOk();
}


DEFINE_RESPONSE_TABLE2(TMyWindow,TWindow,TVbxEventHandler)
  EV_WM_SIZE,
  EV_COMMAND( CM_FILENEW, EvFileNew ),
  EV_COMMAND( CM_FILEEXIT, EvFileExit ),
  EV_COMMAND( CM_EDITCUT, EvEditCut ),
  EV_COMMAND( CM_EDITCOPY, EvEditCopy ),
  EV_COMMAND( CM_EDITPASTE, EvEditPaste ),
  EV_VBXEVENTNAME( IDC_Spread,"RightClick", EvRightClick ),
END_RESPONSE_TABLE;

TMyWindow::TMyWindow( TWindow *parent, const char far *title )
{
  TWindow::Init( parent, title, 0 );
  mySpread = new TVbxSpreadSheet( this, IDC_Spread, "Spreadsheet",
				  0, 0, 0, 0, sizeof(SpreadSheetData), SpreadSheetData );
}

TMyWindow::~TMyWindow()
{
	delete mySpread;
}

void TMyWindow::SetupWindow()
{
  TRect rect;

  TWindow::SetupWindow();
  TWindow parent( GetParent( ) );  // get the parent
  parent.GetClientRect( rect );    // get the size of the TFrameWindow
  // size the client to the TFrameWindow
  mySpread->MoveWindow( 0, 0, rect.Width(), rect.Height(), TRUE );
}

void TMyWindow::EvSize( UINT , TSize& size)
{
  mySpread->MoveWindow( 0, 0, size.cx, size.cy, TRUE );
}

void TMyWindow::EvFileNew()
{
	mySpread->SetPropAction( TVbxSpreadSheet::Action_28_Reset );
}

void TMyWindow::EvFileExit()
{
	 ::PostMessage( GetParent(), WM_CLOSE, 0, 0L );
}

void TMyWindow::EvEditCut( )
{
	 mySpread->SetPropAction( TVbxSpreadSheet::Action_23_ClipboardCut );
}

void TMyWindow::EvEditCopy( )
// inserted comment
{
	 mySpread->SetPropAction( TVbxSpreadSheet::Action_22_ClipboardCopy );
}

void TMyWindow::EvEditPaste( )
{
	 mySpread->SetPropAction( TVbxSpreadSheet::Action_24_ClipboardPaste );
}

void TMyWindow::EvRightClick( VBXEVENT far *event )
{
  ENUM CellType=0;
  long Col;
  long Row;

  memset( &Attributes, 0, sizeof(Attributes) );

  Col = VBX_EVENTARGNUM( event, long, 1 );
  Row = VBX_EVENTARGNUM( event, long, 2 );

  mySpread->SetPropCol( Col );
  mySpread->SetPropRow( Row );
  mySpread->SetPropAction( TVbxSpreadSheet::Action_0_ActivateCell );

  mySpread->GetPropFontUnderline( Attributes.underline );
  mySpread->GetPropFontBold( Attributes.bold );
  mySpread->GetPropFontItalic( Attributes.italic );
  mySpread->GetPropFontStrikethru( Attributes.strikethru );
  mySpread->GetPropCellType( CellType );
  mySpread->GetPropFormula( Attributes.formula );

  switch( CellType )
  {
	 case TVbxSpreadSheet::CellType_1_Edit:
	 {
		Attributes.numeric = 0;
		Attributes.text = 0;
		Attributes.edit = 1;
		break;
	 }
	 case	TVbxSpreadSheet::CellType_2_Float:
	 {
		Attributes.numeric = 1;
		Attributes.text = 0;
		Attributes.edit = 0;
		break;
	 }
	 case	TVbxSpreadSheet::CellType_5_StaticText:
	 {
		Attributes.numeric = 0;
		Attributes.text = 1;
		Attributes.edit = 0;
		break;
	 }
	 default:
	 {
		Attributes.numeric = 0;
		Attributes.text = 0;
		Attributes.edit = 0;
		break;
	 }
  }
  if( InspectDialog( this, IDC_DIALOG1 ).Execute() ==  IDOK )
  {
	 if( Attributes.text ) CellType = TVbxSpreadSheet::CellType_1_Edit;
	 if( Attributes.numeric ) CellType = TVbxSpreadSheet::CellType_2_Float;
	 if( Attributes.edit ) CellType = TVbxSpreadSheet::CellType_5_StaticText;
	 mySpread->SetPropCol( Col );
	 mySpread->SetPropRow( Row );
	 mySpread->SetPropAction( TVbxSpreadSheet::Action_0_ActivateCell );
	 mySpread->SetPropReDraw( FALSE );
	 mySpread->SetPropFontUnderline( Attributes.underline );
	 mySpread->SetPropFontBold( Attributes.bold );
	 mySpread->SetPropFontItalic( Attributes.italic );
	 mySpread->SetPropFontStrikethru( Attributes.strikethru );
	 mySpread->SetPropCellType( CellType );
	 mySpread->SetPropFormula( Attributes.formula );
	 mySpread->SetPropReDraw( TRUE );
  }
}

class TWPApp : public TApplication
{
  public:
	 TWPApp(const char far* name) : TApplication(name) {}
	 ~TWPApp() {  }
	 void   InitMainWindow();
};

void
TWPApp::InitMainWindow()
{
  SetMainWindow( new TFrameWindow((TWindow *)0, Name, new TMyWindow(0,"SpreadSheet"), FALSE ));

  GetMainWindow()->SetIcon(this, AppName);
  GetMainWindow()->AssignMenu(SPREAD_MENU);
}

int
OwlMain(int /*argc*/, char* /*argv*/ [])
{
  TBIVbxLibrary VbxLib;

  TWPApp    App(AppName);
  return App.Run();
}
