#include <owl\dialog.h>
#include <owl\eventhan.h>

#define VBXGEN_DATA

#include <ssbc1.h>

//
// Transfer data structure for the Inspector dialog
//

struct InspectData
{
  int bold;
  int italic;
  int strikethru;
  int underline;

  int edit;
  int numeric;
  int text;
  char formula[128];
};

//
// Client window class for the application
//

class TMyWindow : public TWindow, public TVbxEventHandler
{
  public:
	 TMyWindow( TWindow *parent, const char far *title );
	 ~TMyWindow();
  protected:
	 void SetupWindow();
	 void EvSize( UINT, TSize& );
	 void EvFileNew();
	 void EvFileExit();

	 void EvEditCut();
	 void EvEditCopy();
	 void EvEditPaste();

	 void EvRightClick( VBXEVENT far *);

	 TVbxSpreadSheet *mySpread;

  DECLARE_RESPONSE_TABLE( TMyWindow );
};

//
//  Inspector dialog for modifying the attributes of cells
//

class InspectDialog : public TDialog
{
  public:
	 void CmOk();
	 void CmCancel();

	 InspectDialog( TWindow *parent, TResID resid );

  DECLARE_RESPONSE_TABLE( InspectDialog );
};


