//============================================================================
//
//  SPPDEMO.CPP
//
//  Demo program for Serial++ Library SPP.LIB Ver. 1.10
//
//  Copyright (c) 1991,1992 Cortlandt Technologies, All rights reserved.
//
//  Cortlandt Technologies, P.O. Box 195, Pleasantville NY 10570
//
//  Please direct all inquiries to the above address,
//  or via Compuserve: 71066,155
//
//============================================================================
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "serial.h"

//============================================================================
//
//	Setup up command line defaults

	CommPort cp = COM_1;		// COM1:

	Baud      bd = B_1200;		// 1200 baud

	DataBits  db = D_8;		// 8 data bits

	Parity	 ps = P_N;		// no parity

	StopBits  sb = S_1;		// 1 stop bit


//============================================================================
//
//	Globals

	char buffer[255];            // buffer for messages

	SerialPort *com;             // pointer to a SerialPort -- used in
										  // main routine to establish port

//============================================================================
//
//	Prototypes of functions in this file

	StopBits  cl_StopBits(const char *cltok);
	Parity    cl_Parity(const char *cltok);
	DataBits  cl_DataBits(const char *cltok);
	Baud      cl_Baud(const char *cltok);
	CommPort  cl_CommPort(const char *cltok);
	void      printUsage(void);

//============================================================================
//
//	Main program
//
//----------------------------------------------------------------------------
void
main(void)
{
	unsigned char cc;

// 	Banner
	printf("\n SPPDEMO - Demo program for SPP.LIB\n Copyright (c) 1991 Cortlandt Technologies, All rights reserved.\n\n Type $$$ at prompt or press Ctrl-Break to exit.\n");

//	parse command line
	switch (_argc)          // depending on number of
		{               // command line arguments
		case 6:
			sb = cl_StopBits(_argv[5]);   	// override stop bits

		case 5:
			ps = cl_Parity(_argv[4]);     	// override parity

		case 4:
			db = cl_DataBits(_argv[3]);   	// override data bits

		case 3:
			bd = cl_Baud(_argv[2]);       	// override baud

		case 2:
			cp = cl_CommPort(_argv[1]);   	// override port
			break;

		default:                            	// bad command line -
			printUsage();                 	// print help and exit
			exit(0);
		}

// establish port
	com = new SerialPort(cp,bd,db,ps,sb);  // taking defaults for buffer size
														// and break trapping: see SERIAL.H
	if (com->lineOK())
		{
//		loop sending messages back and forth
		do {
			printf("\n  To port>>");
			gets(buffer);

//			string "$$$" causes program to exit
			if (strcmp(buffer,"$$$")==0)
				break;

//			send message out port
			com->outstr(buffer);     // the message as a string
			com->outbyte(0x0d);      // add a carriage return

//			clear buffer to use for incoming message
			memset(buffer,'\0',sizeof(buffer));

//			read port until quiet for 2 seconds
			int ii=0;

			while (   (com->inbyte((unsigned char)buffer[ii++],2000))
				&&(ii<sizeof(buffer)));

			printf("\nFrom port<<%s",buffer);
			}
			while (1);

		}
	else
		printf("\n Unable to establish port!\n");

	delete com;  // VERY IMPORTANT! Delete SerialPort before exit...
		     // Destructor resets captured interrupt vectors!
}
//============================================================================
//
//	Command line parse routines
//
//----------------------------------------------------------------------------
StopBits
cl_StopBits(const char *cltok)
{
	switch (atoi(cltok))
		{
		case 2:
				return S_2;

		case 1:
				return S_1;

		default:
				printf("\n Stop bits incorrect!\n");
				printUsage();
				exit(0);
		}

	return (StopBits)0;
}

//----------------------------------------------------------------------------
Parity
cl_Parity(const char *cltok)
{
	switch (toupper(*cltok))
		{
		case 'N':
				return P_N;

		case 'E':
				return P_E;

		case 'O':
				return P_O;

		default:
				printf("\n Parity selection incorrect!\n");
				printUsage();
				exit(0);
		}

	return (Parity)0;
}

//----------------------------------------------------------------------------
DataBits
cl_DataBits(const char *cltok)
{
	switch (atoi(cltok))
		{
		case 8:
				return D_8;

		case 7:
				return D_7;

		case 6:
				return D_6;

		case 5:
				return D_5;

		default:
				printf("\n Data bits incorrect!\n");
				printUsage();
				exit(0);
		}

	return (DataBits)0;
}

//----------------------------------------------------------------------------
Baud
cl_Baud(const char *cltok)
{
	switch (atoi(cltok))
		{
		case 2400:
				return B_2400;

		case 1200:
				return B_1200;

		case 300:
				return B_300;

		default:
				printf("\n Baud incorrect!\n");
				printUsage();
				exit(0);
		}

	return (Baud)0;
}

//----------------------------------------------------------------------------
CommPort
cl_CommPort(const char *cltok)
{

	switch (atoi(cltok+strlen(cltok)-1)) // look at last byte of token
		{
		case 2:
				return COM_2;

		case 1:
				return COM_1;

		default:
				printf("\n Port incorrect!\n");
				printUsage();
				exit(0);
		}

	return (CommPort)0;
}

//============================================================================
//
//	Usage screen print
//
//----------------------------------------------------------------------------
void
printUsage(void)
{
	printf("\nUsage: [sppdemo [port [baud [databits [parity [stopbits]]]]]]");
	printf("\n\n      port = COM1 | COM2\n      baud = 2400 | 1200 | 300\n  databits =    8 |    7\n    parity = NONE | EVEN | ODD\n  stopbits =    1 |    2");
	printf("\n\n  Example (defaults):   sppdemo COM1 1200 8 N 1\n");
}

//============================================================================
//============================================================================
