// Number of icons in the resource
#define ICONS 13
#define NETICONS 4

#ifdef __WIN32__
  #define GetActiveWin() GetForegroundWindow()
#else
  #define GetActiveWin() GetActiveWindow()
#endif

#define IDB_FIRST  100                 // ID of the first button
#define HELPSTR    100                 // first string for the inline help
#define MAXICONS   32                  // Maximum number of icons
#define IDBI_FIRST 500                 // ID of the first button in the Icon list

#define WM_SYNCPAINT 0x0088            // undocumented message

// USER messages
#define WM_MENU  100
#define WM_DRAW  101
#define WM_ERROR 102

#define IDM_CONNECT     150
#define IDM_DISCONNECT  151
#define IDM_SHARE       152
#define IDM_STOPSHARE   153

// BUTTONS MESSAGES
#define CM_DOS   100
#define CM_EXIT  101
#define CM_CLOCK 102
#define CM_SHUT  103
#define CM_CANC  104
#define CM_APP   105
#define CM_CONF  106
#define CM_SCRSV 107
#define CM_SSON  108
#define CM_CALC  109
#define CM_RES   110
#define CM_NET   111
#define CM_HELP  112

#define IDAPPLI  100
#define CM_APPGO 500

#define WININI_ERR 1
#define DLL_ERR    2
#define VERSION    3
#define NETERROR   4

// external variables

extern HINSTANCE MainInstance;        // Instance of the application
extern BOOL BarActive;                // Is the Tool bar active ?
extern HWND MainWindow;               // Handle the the main window
extern HDC  MainDC;                   // Display context of the main window (No more used)


// Miscellaneous Structs

typedef struct ButtonData {
		  int ID;                       // Identifier of the button
		  HWND hwnd;                    // Handle of the button
		  } BUTTONDATA;


typedef struct AppliDesc
{
 char* PathName;                      // Path name of the application (ex: C:\\WINDOWS\\WINFILE)
 char* AppliName;                     // Application name (ex: MS Winfile)
 int   AppNum;                        // Number of this application
 int   TotalApp;                      // Total number of applications defined in [SpeedManu]
 } APPLIDESC;

typedef struct IconData {
		  int ID;                       // Identifier of the button
		  HWND hwnd;                    // Handle of the button
		  LPSTR Text;                   // Text of the button
		  } ICONDATA;


/*
---  Windows EXE header. ---

 00h  2 BYTEs   "NE" (4Eh 45h) signature
 02h  2 BYTEs   linker version (major, then minor)
 04h    WORD    offset from start of this header to entry table (see #0700)
 06h    WORD    length of entry table in bytes
 08h    DWORD   file load CRC (0 in Borland's TPW)
 0Ch    BYTE    program flags (see #0694)
 0Dh    BYTE    application flags (see #0695)
 0Eh    WORD    auto data segment index
 10h    WORD    initial local heap size
 12h    WORD    initial stack size (added to data seg, 0000h if SS <> DS)
 14h    DWORD   program entry point (CS:IP), "CS" is index into segment table
 18h    DWORD   initial stack pointer (SS:SP), "SS" is segment index
					 if SS=automatic data segment and SP=0000h, the stack pointer is
						set to the top of the automatic data segment, just below the
						local heap
 1Ch    WORD    segment count
 1Eh    WORD    module reference count
 20h    WORD    length of nonresident names table in bytes
 22h    WORD    offset from start of this header to segment table (see #0698)
 24h    WORD    offset from start of this header to resource table
 26h    WORD    offset from start of this header to resident names table
 28h    WORD    offset from start of this header to module reference table
 2Ah    WORD    offset from start of this header to imported names table
                (array of counted strings, terminated with a string of length
                  00h)
 2Ch    DWORD   offset from start of file to nonresident names table
 30h    WORD    count of moveable entry point listed in entry table
 32h    WORD    file alignment size shift count
					 0 is equivalent to 9 (default 512-byte pages)
 34h    WORD    number of resource table entries
 36h    BYTE    target operating system
					 00h unknown
					 01h OS/2
					 02h Windows
					 03h European MS-DOS 4.x
					 04h Windows 386
					 05h BOSS (Borland Operating System Services)
 37h    BYTE    other EXE flags (see #0696)
 38h    WORD    offset to return thunks or start of gangload area
 3Ah    WORD    offset to segment reference thunks or length of gangload area
 3Ch    WORD    minimum code swap area size
 3Eh  2 BYTEs   expected Windows version (minor version first)
*/

typedef struct ExeHdr {
	BYTE    signature[2];
	BYTE    linker_version[2];
	WORD    entry_table;
	WORD    len_entry_table;
	DWORD   CRC;
	BYTE    program_flags;
	BYTE    application_flags;
	WORD    data_segment_index;
	WORD    local_heap;
	WORD    stack_size;
	DWORD   program_entry_point;
	DWORD   stack_pointer;
	WORD    segment_count;
	WORD    module_reference_count;
	WORD    len_nonresident;
	WORD    offset_seg_table;
	WORD    offset_res_table;
	WORD    offset_resid_table;
	WORD    offset_mod_table;
	WORD    offset_imp_table;
	DWORD   offset_nonr_table;
	WORD    count_mov_entry;
	WORD    file_alig;
	WORD    num_res_tbl_entries;
	BYTE    OS;
	BYTE    EXE_flags;
	WORD    thunks;
	WORD    seg_ref;
	WORD    code_swap_area;
	BYTE    WinVer[2];
} EXEHDR;

// Resource header format

typedef struct ResFmt {
		  WORD   Unknow1;   // I didn't find what is this word
		  BYTE   ResType;   // Type of the following resource(s)
		  BYTE   Unknow2;   // ???
		  WORD   NumRes;    // Number of resources following this header
		  WORD   Unknow3;   // ???
} RESFMT;

// Resource format

typedef struct Resource {
		  WORD   RESERV1;   // Seems to be reserved
		  WORD   OFFSET;    // Offset of the resource in the file
		  WORD   SIZE;      // Size of the resource (multiply by file_alig from EXE header struct)
		  WORD   ATTR;      // Attribute: Moveable, Preload etc...
		  WORD   ID;        // ID of the resource
		  WORD   RESERV2;   // Don't know
} RESOURCE;

#ifndef __WIN32__
typedef struct cwpStruct
{
 LPARAM lParam;
 WPARAM wParam;
 UINT   message;
 HWND   hwnd;
 } CWPSTRUCT;
#endif

typedef DWORD pascal DPascal;

typedef DPascal (*NetConnectionDialog)(HWND hWnd, WORD resourceType);
typedef DPascal (*NetDisconnectDialog)(HWND hWnd, WORD resourceType);
typedef DPascal (*NetShareAsDialog)(HWND hWnd, WORD resourceType, LPSTR Path);
typedef DPascal (*NetStopShareDialog)(HWND hWnd, WORD resourceType, LPSTR Path);

// ------------------------- PROCS -----------------------------------------------------------

BOOL MakeToolBar(HWND _Parent, int x, int y);

BOOL MakeIconBar(HWND _Parent, int x, int y);

APPLIDESC *LookForAppli(HWND hwndDlg, int Text, int Box, int Slot);

void MakeWinHelp();

BOOL NetFuncs(HWND _Parent, int x, int y);

BOOL DestroyNet();
