/*  DpbStruct -- Layout of parameter block returned by Int 21H, Fn 32H    */
/*               This function is an undocumented MS-DOS service but has  */
/*               been verified to work correctly on PC/MS-DOS 2.0 through */
/*               PC/MS-DOS 3.3                                            */

struct DpbStruct {
    char     Designator;   		/* Drive # (0=A, 1=B, ...)       */
    char     AltDesignator;		/* As above; 0 if RAMdisk        */
    unsigned SectorSize;		/* Bytes per Sector              */
    char     ClusterSize;  		/* Sectors per Cluster - 1       */
    char     ClusterShift; 		/* Log2 (Sectors per Clus)       */
    unsigned FatStart;			/* Sectors in Boot Record        */
    char     FatCopies;			/* Copies of FAT                 */
    unsigned MaxEntries;		/* Max entries in Root Directory */
    unsigned DataStart;			/* 1st sector of data area       */
    unsigned LastCluster;		/* Last cluster number           */
    char     FatSize;			/* Sectors in FAT                */
    unsigned DirStart;			/* 1St sector in Root Directory  */
    long     ddh;				/* Internal use (?)              */
    unsigned MediaType;			/* Disk type code                */
    long     NextTable;			/* chain to next disk table      */
    };

/*
 *  MsDate -- packed date format used in directory
 */
struct MsDate {
    unsigned d : 5;
    unsigned m : 4;
    unsigned y : 7;
    };

/*
 *  MsTime -- packed time format used in directory
 */
struct MsTime {
    unsigned xx : 5;
    unsigned mm : 6;
    unsigned hh : 5;
    };

/*  ExtendedHeader -- header used in constructing an
 *                     extended file control block.
 */

struct ExtendedHeader {
    char Header;
    char Zeros[5];
    char Attrib;
    };

/*  ExtFcb -- extended file control block */

struct ExtFcb {
    struct ExtendedHeader FcbHdr;
    char DriveId;
    char FileName[8];
    char FileExtension[3];
    unsigned CurBlock;
    unsigned RecSize;
    long FileSize;
    struct MsDate Date;
    struct MsTime Time;
    char Reserved[8];
    char RecInBlock;
    long RelRecord;
    };

/*
 *  DirDta -- dta directory entry structure
 */

struct DirDta {
    char DriveNum;
    char FileName[11];
    char Attributes;
    char Unused[10];
    struct MsTime CreateTime;
    struct MsDate CreateDate;
    unsigned FirstCluster;
    long FileSize;
    };

/*
 *  DirEntry -- format of an entry in the directory
 */

struct DirEntry {
    unsigned char      Name[8];
    char      Ext[3];
    char      Attribute;
    char      Reserved[10];
	unsigned  ModifyTime;
	unsigned  ModifyDate;
    unsigned  FirstCluster;
    long      FileSize;
    };

/*
 *  ExtendedEntry -- directory structure for use with
 *                    extended file search
 */

struct ExtendedEntry {
    struct ExtendedHeader DirHdr;
    struct DirDta Body;
    };

struct ClusterEntry {
    struct ClusterEntry *Next;
    unsigned Cluster;
    };

struct ClusterQueue {
    struct ClusterEntry *Head, *Current;
    int Count;
    };


