#include <stdio.h>
#include <dos.h>
#include "dosstruc.h"

/*
 *	GETDPB is a routine to use the undocumented PC/MS-DOS Int 21H, Func 32H
 *		   to obtain disk information.  This function has been verified to
 *		   perform correctly in all versions of PC/MS-DOS from 2.0 through
 *		   3.3.  Since it is heavily used by DOS programs such as CHKDSK,
 *		   it will prbably continue to work correctly.  This routine is used
 *		   to avoid problems with non-standard boot sectors.
 */

void GetDPB (int Disk, struct DpbStruct *Dpb) {
	int seg, offset;

	offset = FP_OFF(Dpb);		/* Separate ptr to return area into Seg */
	seg = FP_SEG(Dpb);			/*   and Offset							*/
	asm test	word ptr seg,0FFFFH		/* Compensate for "Tiny" model			*/
	asm jnz		L0
	asm mov		seg,DS
L0:
	asm push	ES				/* Save ES and DS for return            */
	asm push	DS
	asm mov     DX,Disk           /* Get disk number for func 32H      */
	asm test    DL,0FFH           /* Check for default disk			   */
	asm jz      L1                /* ... Xfr - default				   */
	asm and     DL,0FH            /* Make disk numeric				   */
L1:
	asm mov     AH,32H            /* MS-DOS 'Get Disk Parameter Block' */
	asm int     21H               /* ... DOS Entry Interrupt		   */
	asm mov     SI,BX             /* DS:SI points to parameter block   */
	asm mov     DI,offset         /* ES:DI points to destination	   */
	asm mov		ES,seg			  /* ...							   */
	asm mov     CX,28             /* CX = size of block				   */
	asm cld                       /* Clear Direction Flag [forward]	   */
	asm rep     movsb             /* Move parameter block			   */
	asm pop		DS
	asm pop		ES
	}




