/*************************************************
 **                                             **
 **   sc_clock.h                                **
 **                                             **
 **     SoftC Clock/Calendar functions header   **
 **                                             **
 **          Copyright (C) 1989, 1990 by        **
 **               SoftC, Ltd.                   **
 **               16820 3rd St NE               **
 **               Ham Lake, MN 55304            **
 **               (612) 434-6968                **
 **                                             **
 **             All rights reserved.            **
 *************************************************/



/**********
 *
 *  Defines
 *
 **********/




#define SC_GREGOR 1         /* Gregorian date "mm/dd/yy" */
#define SC_GREGORL 2        /* Gregorian date "mm/dd/yyyy" */
#define SC_JULIAN 3         /* Julian date "yyyy/ddd" */
#define SC_YMD 4            /* dBASE date "yyyymmdd" */
#define SC_DMY 5            /* European/Military date "ddmmyy" */

#define SC_CSHMS 1          /* colon separated time "hh:mm:ss" */
#define SC_MIL 2            /* Military time 0000 - 2359 */



/**********
 *
 *  Integer Date Source Function Prototypes
 *
 **********/




signed int sccdi2l(   signed long *,      /* number of days since 1/1 0001 */
                      signed int,         /* year */
                      signed int,         /* month */
                      signed int );       /* day */

signed int sccdi2s(   signed char *,      /* date string */
                      signed int,         /* date string format (YMD, GREG, JUL) */
                      signed int,         /* year */
                      signed int,         /* month */
                      signed int );       /* day */

signed int sccdiget(  signed int *,       /* current DOS year */
                      signed int *,       /*             month */
                      signed int *,       /*             day of month */
                      signed int *);      /*             day of week */

signed int sccdileap( signed int );       /* year */

signed int sccdiperm( signed char *,      /* number of days in month */
                      signed int,         /* desired year */
                      signed int);        /* desired month */




/**********
 *
 *  Long Date Source Function Prototypes
 *
 **********/




signed int sccdl2dow( signed char *,      /* day number (0-6) */
                      signed long );      /* long date source */

signed int sccdl2i(   signed int *,       /* year */
                      signed int *,       /* month */
                      signed int *,       /* day */
                      signed long );      /* long date source */

signed int sccdl2sx(  signed char *,      /* date string */
                      signed int,         /* date string format */
                      signed long);       /* number of days since 1/1/00 */




/**********
 *
 *  String Date Source Function Prototypes
 *
 **********/



signed int sccds2day( signed char *,      /* day of week string */
                      signed char *,      /* source date string */
                      signed int );       /* source date string format */

signed int sccds2dow( signed char *,      /* day of week number */
                      signed char *,      /* source date string */
                      signed int );       /* source date string format */

signed int sccds2i(   signed int *,       /* year */
                      signed int *,       /* month */
                      signed int *,       /* day */
                      signed char *,      /* date string */
                      signed int );       /* string format */

signed int sccds2lx(  signed long *,      /* number of days since 1/1 0001 */
                      signed char *,      /* date string */
                      signed int );       /* date string format (YMD,GREG, JUL) */

signed int sccds2mon( signed char *,      /* month of year string */
                      signed char *,      /* source date string */
                      signed int );       /* source date string format */

signed int sccds2s(   signed char *,      /* output date string */
                      signed int,         /* output string format */
                      signed char *,      /* source date string */
                      signed int );       /* source string format */

signed int sccdsday(  signed char *,      /* day of week text string */
                      signed char);       /* numeric day of week */

signed int sccdsdiff( signed long *,      /* difference in days */
                      signed char *,      /* date string */
                      signed int,         /* string format (YMD, GREG, JULIAN) */
                      signed char *,      /* date string */
                      signed int);        /* string format (YMD, GREG, JULIAN) */

signed int sccdsget(  signed char *,      /* DOS date string */
                      signed int );       /* date string format */

signed int sccdsleap( signed char *,      /* date string */
                      signed int );       /* string format (YMD,GREG,JULIAN) */

signed int sccdsmonth(signed char *,      /* month text string */
                      signed char);       /* numeric month */

signed int sccdsperm( signed char *,      /* number of days in month */
                      signed char *,      /* date string */
                      signed int );       /* string format (YMD, GREG, JUL) */

signed int sccdsvalid(signed char *,      /* date string */
                      signed int );       /* string format (YMD,GREG,JULIAN) */





/**********
 *
 *  Integer Clock Source Function Prototypes
 *
 **********/




signed int sccti2s(   signed char *,      /* time string */
                      signed int,         /* string format (H:M:S) */
                      signed int,         /* hours */
                      signed int,         /* minutes */
                      signed int);        /* seconds */

signed int scctiget(  signed int *,       /* current DOS hour */
                      signed int *,       /*             minute */
                      signed int *,       /*             second */
                      signed int * );     /*             hundredths of second */






/**********
 *
 *  String Clock Source Function Prototypes
 *
 **********/




signed int sccts2i(   signed int *,       /* hours */
                      signed int *,       /* minutes */
                      signed int *,       /* seconds */
                      signed char *,      /* time string */
                      signed int);        /* string format (H:M:S) */

signed int scctsdiff( signed long *,      /* number of seconds difference */
                      signed char *,      /* time 1 */
                      signed int,         /* string format */
                      signed char *,      /* time 2 */
                      signed int);        /* string format (H:M:S) */

signed int scctsget(  signed char *,      /* current time in string format */
                      signed int);        /* time string format (MIL, H:M:S) */

signed int scctsvalid(signed char *,      /* time string */
                      signed int);        /* string format (H:M:S) */




/**********
 *
 *  External Variables
 *
 **********/




extern signed char sc_dpm[13];    /* days per month array */



/**********
 *
 *  Compatibility Definitions
 *
 **********/




#define sccday(a,b) sccdsday(a,b)
#define sccddiff(a,b,c) sccdsdiff(a,b,SC_YMD,c,SC_YMD)
#define sccdl2s(a,b) sccdl2sx(a,SC_YMD,b)
#define sccdn2s(a,b,c,d) sccdi2s(a,SC_YMD,b,c,d)
#define sccdperm(a,b) sccdsperm(a,b,SC_YMD)
#define sccdpermi(a,b,c) sccdiperm(a,b,c)
#define sccds2l(a,b) sccds2lx(a,b,SC_YMD)
#define sccds2n(a,b,c,d) sccds2i(a,b,c,d,SC_YMD)
#define sccdvalid(a) sccdsvalid(a,SC_YMD)
#define sccleap(a) sccdsleap(a,SC_YMD)
#define sccleapi(a) sccdileap(a)
#define sccmonth(a,b) sccdsmonth(a,b)

#define scctdiff(a,b,c) scctsdiff(a,b,SC_CSHMS,c,SC_CSHMS)
#define scctn2s(a,b,c,d) sccti2s(a,SC_CSHMS,b,c,d)
#define sccts2n(a,b,c,d) sccts2i(a,b,c,d,SC_CSHMS)
#define scctvalid(a) scctsvalid(a,SC_CSHMS)

