/*************************************************
 **                                             **
 **   sc_base.h                                 **
 **                                             **
 **       SoftC Database Library common header  **
 **                                             **
 **         Copyright (C) 1988, 1989, 1990 by   **
 **               SoftC, Ltd.                   **
 **               16820 3rd St NE               **
 **               Ham Lake, MN 55304            **
 **               (612) 434-6968                **
 **                                             **
 **             All rights reserved.            **
 *************************************************/



/**********
 *
 *  Program Control Prototypes
 *
 **********/




signed int scdinit( signed int,  signed int );
void scdterm( void );
#define sceclr() (sc_code = SC_SUCCESS)




/**********
 *
 *  Defines
 *
 **********/




/* scdikfind, scdnkfind, scdckfind definitions */
#define SC_FIRST 1                  /* find first key */
#define SC_EXACT 2                  /* find exact key (uses record number) */

/* sctrget, sctrput definitions */
#define SC_CRUNCHNG 0               /* leave memo buffer unchanged */
#define SC_CRDELETE 1               /* delete soft carriage returns */

/* scdcopen, scddopen, scdiopen, scdnopen, scdtopen */
#define SC_RDWR 0                   /* read/write access (default) */
#define SC_RDONLY 1                 /* read only access */
#define SC_BUFFER 0                 /* buffer disk writes in memory (default) */
#define SC_FLUSH 2                  /* force all writes to disk */
#define SC_EXCLUDE 0                /* open file for exclusive use (default) */
#define SC_SHARED 4                 /* open file for shared use */

/* scdcbfrsz, scddbfrsz, scdibfrsz, scdnbfrsz */
#define SC_SETSZ 0                  /* set buffer size */
#define SC_GETSZ 1                  /* get current buffer size */

/* scddrget */
#define SC_UPDATE 1                 /* update existing record */
#define SC_ADD 2                    /* append record at end of file */

/* scdccreate, scdicreate, scdncreate */
#define SC_UNIQUE 0x80              /* unique index keys */
#define SC_CKEY 'C'                 /* character type key */
#define SC_DKEY 'D'                 /* date type key */
#define SC_LKEY 'L'                 /* logical key type */
#define SC_NKEY 'N'                 /* numeric type key */

/* scdinit */
#define SC_USEXHNDL 1               /* allow more than 20 open files */




/**********
 *
 *  Type Definitions
 *
 **********/




typedef struct {  /* database field description */
  signed char name[11];   /* field name */
  signed char type;       /* field type
                           * 'c' or 'C' - character
                           * 'd' or 'D' - date
                           * 'f' or 'F' - floating point (binary)
                           * 'l' or 'L' - logical
                           *              't' or 'T' - true
                           *              'f' or 'F' - false
                           *              'y' or 'Y' - yes
                           *              'n' or 'N' - no
                           *              '?'        - uninitialized
                           * 'n' or 'N' - floating point (bcd) */
  signed int len;         /* field width */
  signed int decpl;       /* decimal count */
} SC_FIELD;



typedef struct {  /* file open bit fields */
  unsigned int isreadonly:1;    /*    read only     - or -  read/write (default) */
  unsigned int isshareable:1;   /*    shared        - or -  single (default) */
  unsigned int isunbuffered:1;  /*    no buffering  - or -  auto buffer (default) */
} SC_FLAGS;



typedef struct {  /* dBASE data file information packet */
  signed char fname[80];  /* file name */
  signed char style;      /* file type (dBase3 or dBase4) */
  signed char memo;       /* memo file required */
  signed char mdx;        /* dBase4 .MDX file required (true or false) */
  signed char trans;      /* dBase4 transaction in process (true or false) */
  signed char encrypt;    /* dBase4 data file encrypted (true or false) */
  signed char lockt;      /* record/file/no lock */
  unsigned long ladrs;    /* beginning address of locked area */
  unsigned long lsize;    /* length of locked region */
  SC_FLAGS flags;         /* miscellaneous flags */
} SC_DBFINFO;

/* SC_DBFINFO style flag */
#define SC_DB3 0                    /* dBase3 type data file */
#define SC_DB4 1                    /* dBase4 type data file */

/* SC_DBFINFO memo flag */
#define SC_USEMEMO 2                /* memo file used */
#define SC_NOMEMO 0                 /* no memo file required */

/* SC_DBFINFO lockt flag */
#define SC_DRECLCK 0x01             /* record lock active */
#define SC_DFILLCK 0x02             /* file lock active */


typedef struct {  /* dBASE data file record information packet */
  signed int reclen;                /* record length in bytes */
  signed int numflds;               /* number of fields in record */
  unsigned char *bfr;               /* address of the record buffer */
} SC_DBFRINFO;



typedef struct {  /* dBASE memo file information packet */
  signed char fname[80];  /* file name */
  SC_FLAGS flags;         /* miscellaneous flags */
} SC_DBTINFO;



typedef struct {  /* dBASE index file information packet */
  signed char fname[80];  /* file name */
  signed char keytype;    /* key type ('C' Character, 'N' Date/Numeric) */
  signed char keylen;     /* key length */
  signed int exprlen;     /* key expression length */
  SC_FLAGS flags;         /* miscellaneous flags */
} SC_NDXINFO;



typedef struct {  /* Clipper index file information packet */
  signed char fname[80];  /* file name */
  signed int keylen;      /* key length */
  signed int keydpl;      /* number of decimal places in numeric keys */
  signed int exprlen;     /* key expression length */
  SC_FLAGS flags;         /* miscellaneous flags */
} SC_NTXINFO;


typedef struct {  /* FoxBASE index file information packet */
  signed char fname[80];  /* file name */
  signed char keytype;    /* key type ('C' Character, 'N' Date/Numeric) */
  signed char keylen;     /* key length */
  signed int exprlen;     /* key expression length */
  SC_FLAGS flags;         /* miscellaneous flags */
} SC_IDXINFO;



/**********
 *
 *  dBASE Database File Manipulator Prototypes
 *
 **********/




signed int scddbfrsz( signed int,       /* data file handle */
                      signed int *,     /* I/O buffer length in records */
                      signed int );     /* set or get buffer length */

signed int scddbof(   signed int );     /* file handle */

signed int scddclose( signed int );     /* file handle */

signed int scddcreate(signed char *,    /* filename */
                      signed int,       /* number of data fields */
                      SC_FIELD *,       /* field description array */
                      signed int );     /* dBase version (3 or 4) */

signed int scddeof(   signed int );     /* file handle */

signed int scddflush( signed int );     /* file handle */

signed int scddinfo(  signed int,       /* file handle */
                      SC_DBFINFO * );   /* file information & status */

signed int scddlock(  signed int );     /* file handle */

signed int scddlud(   signed int,       /* file handle */
                      signed char *,    /* last update date string */
                      signed int );     /* date string format */

signed int scddopenx( signed int *,     /* file handle */
                      signed char *,    /* filename */
                      signed int );     /* open mode & characteristics */

signed int scddpack(  signed int *);    /* data file handle */

signed int scddsize(  signed int,       /* file handle */
                      signed long * );  /* number of data records */

signed int scddunlock(signed int );     /* file handle */




/**********
 *
 *  dBASE Database Field Manipulator Prototypes
 *
 **********/




signed int scddfgets( signed int,       /* file handle */
                      signed int,       /* field number */
                      char * );         /* buffer for field data */

signed int scddfget(  signed int,       /* file handle */
                      signed int,       /* field number */
                      void * );         /* buffer for field data */

signed int scddfinfo( signed int,       /* file handle */
                      signed int *,     /* length of longest field */
                      SC_FIELD * );     /* field description array */

signed int scddfnam2no(signed int,      /* file handle */
                      signed int *,     /* field number */
                      signed char *);   /* field name */

signed int scddfputs( signed int,       /* file handle */
                      signed int,       /* field number */
                      char * );         /* buffer for field data */

signed int scddfput(  signed int,       /* file handle */
                      signed int,       /* field number */
                      void * );         /* buffer for field data */




/**********
 *
 *  dBASE Database Record Manipulator Prototypes
 *
 **********/




signed int scddrclear(signed int );     /* file handle */

signed int scddrdel(  signed int,       /* file handle */
                      signed long );    /* record number to delete */

signed int scddrget(  signed int,       /* file handle */
                      signed long );    /* record number to read */

signed int scddrinfo( signed int,       /* file handle */
                      SC_DBFRINFO * );  /* record info structure */

signed int scddrlock( signed int,       /* file handle */
                      signed long );    /* record number to lock */

signed int scddrnum(  signed int,       /* file handle */
                      signed long * );  /* current data record number */

signed int scddrput(  signed int,       /* file handle */
                      signed long *,    /* record number */
                      signed int );     /* append or update record */

signed int scddrstat( signed int );     /* file handle */

signed int scddrundel(signed int,       /* fiel handle */
                      signed long );    /* record number */



/**********
 *
 *  dBASE Index File Manipulators Prototypes
 *
 **********/




signed int scdnbfrsz( signed int,       /* index file handle */
                      signed int *,     /* buffer length in pages */
                      signed int );     /* set or get buffer length */

signed int scdnclose( signed int );     /* file handle */

signed int scdncreate(signed char *,    /* filename */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int );     /* key length */

signed int scdnexpr(  signed int,       /* file handle */
                      signed char * );  /* key expression */

signed int scdnflush( signed int );     /* file handle */

signed int scdnindex( signed int,       /* data file handle */
                      signed char *,    /* new file name */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int );     /* key length */

signed int scdninfo(  signed int,       /* file handle */
                      SC_NDXINFO * );   /* file information and status */

signed int scdnopenx( signed int *,     /* file handle */
                      signed char *,    /* filename */
                      signed int );     /* open mode and characteristics */




/**********
 *
 *  dBASE Index Key Building Prototypes
 *
 **********/




signed int scdnkdate( double *,         /* numeric date */
                      signed char *,    /* date string */
                      signed int );     /* date string format type */

signed int scdnkmake( signed int,       /* .DBF file handle */
                      signed int,       /* .NDX file handle */
                      void ** );        /* index key */




/**********
 *
 *  dBASE Index Key Manipulator Prototypes
 *
 **********/




signed int scdnkadd(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdnkbot(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdnkcur(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdnkdel(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdnkfind( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *,    /* data record number */
                      signed int);      /* exact match or first */

signed int scdnknext( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdnkprev( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdnktop(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */





/**********
 *
 *  Clipper Index File Manipulators Prototypes
 *
 **********/




signed int scdcbfrsz( signed int,       /* index file handle */
                      signed int *,     /* buffer length in pages */
                      signed int );     /* set or get buffer length */

signed int scdcclose( signed int );     /* file handle */

signed int scdccreate(signed char *,    /* filename */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int,       /* key length */
                      signed int );     /* number of decimal places */

signed int scdcexpr(  signed int,       /* file handle */
                      signed char * );  /* key expression */

signed int scdcflush( signed int );     /* file handle */

signed int scdcindex( signed int,       /* data file handle */
                      signed char *,    /* new file name */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int,       /* key length */
                      signed int );     /* number of decimal places */

signed int scdcinfo(  signed int,       /* file handle */
                      SC_NTXINFO * );   /* file information and status */

signed int scdcopenx( signed int *,     /* file handle */
                      signed char *,    /* filename */
                      signed int );     /* open mode and characteristics */




/**********
 *
 *  Clipper Index Key Building Prototypes
 *
 **********/




signed int scdckmake( signed int,       /* .DBF file handle */
                      signed int,       /* .NTX file handle */
                      void ** );        /* index key */




/**********
 *
 *  Clipper Index Key Manipulator Prototypes
 *
 **********/




signed int scdckadd(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdckbot(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdckcur(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdckdel(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdckfind( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *,    /* data record number */
                      signed int);      /* exact match or first */

signed int scdcknext( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdckprev( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdcktop(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */





/**********
 *
 *  FoxBASE+ Index File Manipulators Prototypes
 *
 **********/




signed int scdibfrsz( signed int,       /* index file handle */
                      signed int *,     /* buffer length in pages */
                      signed int );     /* set or get buffer length */

signed int scdiclose( signed int );     /* file handle */

signed int scdicreate(signed char *,    /* filename */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int );     /* key length */

signed int scdiexpr(  signed int,       /* file handle */
                      signed char * );  /* key expression */

signed int scdiflush( signed int );     /* file handle */

signed int scdiindex( signed int,       /* data file handle */
                      signed char *,    /* new file name */
                      signed int,       /* index key type */
                      signed char *,    /* key expression */
                      signed int );     /* key length */

signed int scdiinfo(  signed int,       /* file handle */
                      SC_IDXINFO * );   /* file information and status */

signed int scdiopenx( signed int *,     /* file handle */
                      signed char *,    /* filename */
                      signed int );     /* open mode and characteristics */




/**********
 *
 *  FoxBASE+ Index Key Building Prototypes
 *
 **********/




signed int scdikdate( unsigned char *,  /* FoxBASE date */
                      signed char *,    /* date string */
                      signed int );     /* date string format type */

signed int scdikmake( signed int,       /* .DBF file handle */
                      signed int,       /* .NTX file handle */
                      void ** );        /* index key */

signed int scdiknum(  unsigned char *,  /* FoxBASE double */
                      double );         /* C double */






/**********
 *
 *  FoxBASE+ Index Key Manipulator Prototypes
 *
 **********/




signed int scdikadd(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdikbot(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdikcur(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdikdel(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long );    /* data record number */

signed int scdikfind( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *,    /* data record number */
                      signed int);      /* exact match or first */

signed int scdiknext( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdikprev( signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */

signed int scdiktop(  signed int,       /* file handle */
                      void *,           /* key string */
                      signed long *);   /* data record number */





/**********
 *
 *  dBase3 Memo File Manipulator Prototypes
 *
 **********/




signed int scdtclose( signed int );     /* file handle */

signed int scdtcreate(signed char * );  /* filename */

signed int scdtinfo(  signed int,       /* file handle */
                      SC_DBTINFO * );   /* file information and status */

signed int scdtopenx( signed int *,     /* file handle */
                      signed char *,    /* filename */
                      signed int );     /* open mode & characteristics */

signed int scdtpack(  signed int,       /* data file handle */
                      signed int *);    /* memo file handle */

signed int scdtrget(  signed int,       /* file handle */
                      signed long,      /* record number */
                      signed char **,   /* buffer for record number */
                      signed int );     /* remove soft carriage returns? */

signed int scdtrput(  signed int,       /* file handle */
                      signed long *,    /* record number */
                      signed char *,    /* buffer for record data */
                      signed int );     /* insert soft carriage returns? */






/**********
 *
 *  External Variables
 *
 **********/


extern signed int sc_date_style;  /* date string format for scddfget/scddfput */





/**********
 *
 *  Compatibility Definitions
 *
 **********/




#define scdfget(a,b,c)      scddfget(a,b,c)
#define scdfgetx(a,b,c,d)   scddfget(a,b,c)
#define scdfgets(a,b,c)     scddfgets(a,b,c)
#define scdfgetsx(a,b,c,d)  scddfgets(a,b,c)

#define scdfput(a,b,c)      scddfput(a,b,c)
#define scdfputx(a,b,c,d)   scddfput(a,b,c)
#define scdfputs(a,b,c)     scddfputs(a,b,c)
#define scdfputsx(a,b,c,d)  scddfputs(a,b,c)

#define scdfinfo(a,b,c)     scddfinfo(a,b,c)
#define scdfnam2no(a,b,c)   scddfnam2no(a,b,c)

#define scdrclear(a,b)      scddrclear(a)
#define scdrdel(a,b)        scddrdel(a,b)
#define scdrget(a,b)        scddrget(a,b)
#define scdrinfo(a,b,c,d,e) scddrinfo(a,b,c,d)
#define scdrput(a,b,c)      scddrput(a,b,c)
#define scdrundel(a,b)      scddrundel(a,b)

#define scdfgett(a,b,c)     scdtrget(a,b,c,SC_CRDELETE)
#define scdfgettx(a,b,c,d)  scdtrget(a,b,c,d)
#define scdfputt(a,b,c)     scdtrput(a,b,c,66)
#define scdfputtx(a,b,c,d)  scdtrput(a,b,c,d)

#define scdkadd(a,b,c)      scdnkadd(a,b,c);
#define scdkcur(a,b,c)      scdnkcur(a,b,c);
#define scdkdate(a,b)       scdnkdate(a,b,SC_YMD)
#define scdkdatex(a,b,c)    scdnkdate(a,b,c)
#define scdkdel(a,b,c)      scdnkdel(a,b,c)
#define scdkfind(a,b,c,d)   scdnkfind(a,b,c,d)
#define scdkfirst(a,b,c)    scdnktop(a,b,c)
#define scdklast(a,b,c)     scdnkbot(a,b,c)
#define scdkmake(a,b,c)     scdnkmake(a,b,c)
#define scdkmakex(a,b,c,d)  scdnkmake(a,b,c)
#define scdknext(a,b,c)     scdnknext(a,b,c)
#define scdkprev(a,b,c)     scdnkprev(a,b,c)

#define scdnopen(a,b)       scdnopenx(a,b,SC_RDWR | SC_FLUSH | SC_EXCLUDE)
#define scdpinfo(a,b)       scdnbfrsz(a,b,SC_GETSZ)
#define scdpnum(a,b)        scdnbfrsz(a,b,SC_SETSZ)

#define scdtopen(a,b)       scdtopenx(a,b,SC_RDWR | SC_FLUSH | SC_EXCLUDE)
