/*************************************************
 **                                             **
 **   clipper.c                                 **
 **                                             **
 **     SoftC (tm) Dbase Library                **
 **       Diskette TOC Demo Program             **
 **                                             **
 **           Copyright (C) 1989, 1990 by       **
 **               SoftC, Ltd.                   **
 **               16820 3rd St NE               **
 **               Ham Lake, MN 55304            **
 **               (612) 434-6968                **
 **                                             **
 **             All rights reserved.            **
 *************************************************/


/*
          The Diskette  TOC Program is a simple program which will create a
          database (TOC.DBF)  and three  index files.  The database  record
          contains the following fields:


          field name     type length    description
          ----------     ---- ------    -----------
          NAME            C    64       file name
          LENGTH          N    10.0     file size in bytes
          DATE            D     8       file creation date
          TIME            C     8       file creation time
          ATTRIBUTE       C     3       file attribute (READ ONLY, HIDDEN)


          The  index   files  created   are:   TOCNAME.NTX   (file   name),
          TOCLNGTH.NTX (file  length), and  TOCDATE.NTX (file creation date
          and time).


          The program  uses the DOS functions "findfirst" and "findnext" to
          step through  the  files  in  the  directory.  It  reformats  the
          compressed file  date  ("mm/dd/yy")  and  time  ("hh:mm:ss")  and
          places the  resultant data  into the  output  buffer.  After  all
          fields have  been entered  it will  append a record to the end of
          the database and add keys for each file found.


          After all the files have been cataloged, the name will be displayed
          in alphabetical order using TOCNAME.NDX.


          The program  only works  on the  current directory.  It does  not
          support any command line arguments, although it would be easy for
          the user  to add  such support.  Very little  error  checking  is
          performed.


          The program  as it  stands has value only in the demonstration of
          certain library  functions. However, it could form the basis of a
          diskette cataloger, or ...

*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if defined(__TURBOC__)
#include <dir.h>
#else
#include <dos.h>
#endif
#include <softc.h>
#include <sc_base.h>

SC_FIELD fields[] = { "name",'c',64,0,
                      "length",'n',10,0,
                      "date",'d',8,0,
                      "time",'c',8,0,
                      "attribute",'n',3,0 };

void main ()
{
#if defined(__TURBOC__)
  struct ffblk ffblk;
#else
  struct find_t ffblk;
#endif
  int r, w1, w2, w3, dbf, ntx1, ntx2, ntx3;
  char work[9], *key, name[65], fname[13], fattrib;
  long recno, fsize;
  unsigned fdate, ftime;
  double d;

  atexit(scdterm);  /* make sure that the terminate function is called */
  scdinit(20,0);  /* initialize the database manager */

/* create the database file */
  scddcreate("toc.dbf",5,fields,SC_DB3);
  scddopenx(&dbf,"toc.dbf",0);      /* open database file */

/* create empty index file on file name field */
  scdccreate("tocname.ntx",'c',"name",64,0);
  scdcopenx(&ntx1,"tocname.ntx",0);   /* open index file */

/* create empty index file on file length field */
  scdccreate("toclngth.ntx",'n',"length",10,0);
  scdcopenx(&ntx2,"toclngth.ntx",0);    /* open index file */

/* create empty index file using expression "dtoc(date) + time" */
  scdccreate("tocdate.ntx",'c',"dtoc(date) + time",16,0);
  scdcopenx(&ntx3,"tocdate.ntx",0);   /* open index file */

/* begin DOS file search */
#if defined(__TURBOC__)
  findfirst("*.*",&ffblk,0);
#else
  _dos_findfirst("*.*",0,&ffblk);
#endif
  do {
#if defined(__TURBOC__)
    strcpy(fname,ffblk.ff_name);  /* file name */
    fsize = ffblk.ff_fsize;       /* file size */
    fdate = ffblk.ff_fdate;       /* file creation date */
    ftime = ffblk.ff_ftime;       /* file creation time */
    fattrib = ffblk.ff_attrib;    /* file attributes */
#else
    strcpy(fname,ffblk.name);     /* file name */
    fsize = ffblk.size;           /* file size */
    fdate = ffblk.wr_date;        /* file creation date */
    ftime = ffblk.wr_time;        /* file creation time */
    fattrib = ffblk.attrib;       /* file attributes */
#endif

  /* ignore the files I am using */
    if ((strcmp(fname,"TOC.DBF") != 0) &&
        (strcmp(fname,"TOCNAME.NTX") != 0) &&
        (strcmp(fname,"TOCLNGTH.NTX") != 0) &&
        (strcmp(fname,"TOCDATE.NTX") != 0)) {

      scddfput(dbf,0,fname);  /* put file name in record */

      d = (double) fsize; /* put file size in record */
      scddfput(dbf,1,&d);

      w1 = ((fdate & 0xFE00) >> 9) + 80;  /* add date to record */
      w2 = (fdate & 0x01E0) >> 5;
      w3 = fdate & 0x001F;
      sprintf(work,"%02d/%02d/%02d",w2,w3,w1);
      scddfput(dbf,2,work);

      w1 = (ftime & 0xF800) >> 11;  /* add file create time to record */
      w2 = (ftime & 0x07E0) >> 5;
      w3 = (ftime & 0x001F) << 1;
      sprintf(work,"%02d:%02d:%02d",w1,w2,w3);
      scddfput(dbf,3,work);

      d = (double) fattrib; /* put file attributes in record */
      scddfput(dbf,4,&d);

      if (scddrput(dbf,&recno,SC_ADD) == SC_SUCCESS) {  /* write record */

        scdckadd(ntx1,fname,recno); /* add key to "name" index */

        scdckmake(dbf,ntx2,(void **) &key); /* add key to "length" index */
        scdckadd(ntx2,key,recno);
        free(key);

        scdckmake(dbf,ntx3,(void **) &key); /* add key to "dtoc(date) + time" index */
        scdckadd(ntx3,key,recno);
        free(key);
      }
    }
#if defined(__TURBOC__)
    r = findnext(&ffblk); /* get next file */
  } while (r != -1);
#else
    r = _dos_findnext(&ffblk);
  } while (r == 0);
#endif

  scdcktop(ntx1,name,&recno); /* get first record in "name" index */

  do {
    scddrget(dbf,recno);  /* get corresponding record */

    scddfget(dbf,0,name); /* get file name field */

    scddfget(dbf,1,&d);   /* get file size */
    printf("%s %10.0lf\n",name,d);

    scdcknext(ntx1,name,&recno);  /* get next key */
  } while (sc_code != SC_END);    /* keep doing this until no more keys */

  scddclose(dbf);   /* close data file */
  scdcclose(ntx1);  /* close "name" index file */
  scdcclose(ntx2);  /* close "length" index file */
  scdcclose(ntx3);  /* close other index file */
}