/*************************************************
 **                                             **
 **   softc.h                                   **
 **                                             **
 **       SoftC common library header           **
 **                                             **
 **         Copyright (C) 1988, 1989 by         **
 **               SoftC, Ltd.                   **
 **               16820 3rd St NE               **
 **               Ham Lake, MN 55304            **
 **               (612) 434-6968                **
 **                                             **
 **             All rights reserved.            **
 *************************************************/



/**********
 *
 *  Function Return Codes
 *
 **********/




#define SC_MEMWRN     9     /* WARNING - partial memory allocation */
#define SC_NOTBFRD    8     /* WARNING - file I/O not buffered */
#define SC_FILENGTH   7     /* WARNING - file length is incorrect */
#define SC_FLDROUND   6     /* WARNING - numeric field rounded */
#define SC_FLDTRUNC   5     /* WARNING - data field truncated */
#define SC_NOFIND     4     /* WARNING - could not find key in index file */
#define SC_END        3     /* WARNING - no more keys */
#define SC_EMPTY      2     /* WARNING - file is empty */
#define SC_DELREC     1     /* WARNING - record read is marked deleted */
#define SC_SUCCESS    0     /* successful function return code */
#define SC_WRTFAIL    -1    /* ERROR - file write failure */
#define SC_RDFAIL     -2    /* ERROR - file read failure */
#define SC_MEMERR     -3    /* ERROR - memory allocation error */
#define SC_SKFAIL     -4    /* ERROR - file pointer reposition failed */
#define SC_NOFILE     -5    /* ERROR - file not found */
#define SC_FILBAD     -6    /* ERROR - file corrupted */
#define SC_BADEXPR    -7    /* ERROR - bad user specified key expression */
#define SC_NOHNDL     -8    /* ERROR - no handles available */
#define SC_NOPGS      -9    /* ERROR - no index pages loaded */
#define SC_BADPG      -10   /* ERROR - index page was not loaded */
#define SC_CLOSFAIL   -11   /* ERROR - file close failure */
#define SC_BADCMD     -12   /* ERROR - invalid command */
#define SC_BADHNDL    -13   /* ERROR - invalid handle number */
#define SC_BADFNAME   -14   /* ERROR - invalid filename */
#define SC_BADDATE    -15   /* ERROR - invalid date */
#define SC_BADTIME    -16   /* ERROR - invalid time */
#define SC_NODBT      -17   /* ERROR - file not in .DBT format */
#define SC_DBFVERS    -18   /* ERROR - invalid dBaseIII version */
#define SC_DBFHLEN    -19   /* ERROR - file header length error */
#define SC_DBFDATE    -20   /* ERROR - last file change date in error */
#define SC_NULLPARM   -21   /* ERROR - parameter address NULL */
#define SC_BADKEYT    -22   /* ERROR - invalid key type */
#define SC_KEYLEN     -23   /* ERROR - invalid key length */
#define SC_ITEMLEN    -24   /* ERROR - item length incorrect */
#define SC_BADROOT    -25   /* ERROR - invalid root page */
#define SC_MAXKEYS    -26   /* ERROR - bad maximum number of keys per page */
#define SC_FLDCNT     -27   /* ERROR - invalid number of fields */
#define SC_BADFLDN    -28   /* ERROR - field name invalid */
#define SC_FLDLEN     -29   /* ERROR - bad field length */
#define SC_DECPL      -30   /* ERROR - decimal places parameter invalid */
#define SC_BADFLDT    -31   /* ERROR - invalid field type */
#define SC_RECLEN     -32   /* ERROR - invalid record length */
#define SC_BADDATA    -33   /* ERROR - bad data */
#define SC_LINELEN    -34   /* ERROR - memo soft line length invalid */
#define SC_MDXFLAG    -35   /* ERROR - MDX flag in DBF file invalid */
#define SC_READOLY    -36   /* ERROR - file open for reading only */
#define SC_LCKVIOL    -37   /* ERROR - file locking violation */
#define SC_LCKBOVR    -38   /* ERROR - sharing buffer overflow */
#define SC_NOPATH     -39   /* ERROR - path not found */
#define SC_ACCDEN     -40   /* ERROR - access to file denied */
#define SC_BADACC     -41   /* ERROR - invalid access code */
#define SC_NOTLCKD    -42   /* ERROR - file must be locked first */
#define SC_NEWDEV     -43   /* ERROR - diskette changed */
#define SC_MINKEYS    -44   /* ERROR - bad minimum number of keys per page */
#define SC_FILSOPEN   -45   /* ERROR - some files remain open */




/**********
 *
 *  Common Defines
 *
 **********/



#define SC_TRUE 1
#define SC_FALSE 0




/**********
 *
 *  Error Handling Prototypes
 *
 **********/



#define sceclr() (sc_code = SC_SUCCESS)
signed char *scemsg( void );



/**********
 *
 *  External Variables
 *
 **********/



extern const char sc_version[];       /* Library Revision */
extern signed int sc_code;      /* function result code */



