/* SHOWDATE.C
 * Syntax: SHOWDATE filename
 */
 
#include <dir.h>
#include <io.h>
 
main(int argc, char *argv[])
{
    struct ffblk fb;
    struct ftime *ft;
 
    /* Setup up ffblk */
    if (argc < 2 ||
        findfirst(argv[1],&fb,0))
            exit();
 
    /* Map date & time into ftime structure using a typecast */
    ft = (struct ftime *) &fb.ff_ftime;
 
    printf("Date: %02d-%02d-%02d   Time: %02d:%02d.%02d\n",
        ft->ft_month,
        ft->ft_day,
        ft->ft_year+80,   /* Year - 1980 */
        ft->ft_hour,
        ft->ft_min,
        ft->ft_tsec * 2); /* Seconds / 2 */
}
/* End of Program */
