class SerialPort
  {
      Word B;  // bps 1200, 2400, 4800 or 9600
      Word IBS; // input buffer size
      Word OBS; // output buffer size
      Byte P;  // the port num 1, 2, 3 or 4
      Byte Pa; // the parity (NoParity, OddParity, etc.)
      Byte DB; // data bits
      Byte SB; // stop bits
      void Reset(){comm_setup(P,B,Pa,DB,SB);}
    public:
      SerialPort(Byte PortNum,Word BPS,
          Word MaxInBuffSize=256,Word MaxOutBuffSize=256,
          Byte Parity=NoParity,Byte DataBits=DataBit8,Byte StopBits=StopBit1);
      ~SerialPort(){Close();}
      void Close(){comm_close(P,False);}
      Byte PortNum(){return P;}
      Word BPS(){return B;}
      Word MaxInBuffSize(){return IBS;}
      Word InBuffSize(){return lc_icnt(P);}
      Word MaxOutBuffSize(){return OBS;}
      Word OutBuffSize(){return lc_ocnt(P);}
      Byte Parity(){return Pa;}
      Byte DataBits(){return DB;}
      Byte StopBits(){return SB;}
      void ResetBPS(Word BPS){B=BPS; Reset();}
      void ResetParity(Byte Parity){Pa=Parity; Reset();}
      void ResetDataBits(Byte DataBits){DB=DataBits; Reset();}
      void ResetStopBits(Byte StopBits){SB=StopBits; Reset();}
      Char Peek(){return Char(lc_peek(P));}
      Char Read(){return Char(lc_getw(P));}  // will wait for char
      void Send(Char C){lc_put(P,C);}
      void Send(const Char* CS){lc_puts(P,CS,strlen(CS));}
      void FlushOutBuff(){lc_tflush(P);}
      void FlushInBuff(){lc_rflush(P);}
      Bool CarrierDetect(){return ((lc_mstat(P)&DCD)!=0);}
  };
/* 
For the untrained eye:  Bool, Byte, Char and Word are derived types using
"typedef" (unsigned char, unsigned char, unsigned char and unsigned short
respectively).
*/
