/*
**  255files.c
**
**  Originally written for Turbo C by Doug Burger
**  11 Mar 90
**
**  Modified for Zortech C++ and Microsoft C/Quick C by Bob Stout
**  13 Oct 90
**
**  Demonstrates relocating the file handle table under DOS 3.x
**  for having more than the usual 20 files open in a single
**  program
*/

#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>

#define TABLE_SIZE 100

#if !defined(__ZTC__) && !defined(__TURBOC__)   /* i.e. #if MSC/QC   */
 #include <stdlib.h>
 #define MK_FP(seg,offset) \
        ((void far *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))

 /* MSC's open() is funny - this code only works with _dos_open()    */
 int open(char *name, unsigned mode)
 {
         int hdl;

         if (0 == _dos_open(name, mode, &hdl))
                 return hdl;
         else    return -1;
 }
#endif

unsigned char handle_table[TABLE_SIZE]; /* table of file DOS handles */
unsigned char far * far * handle_ptr;   /* ptr to DOS's ptr to hand. */
unsigned int far *handle_count;         /* ptr to handle count */

void relocate(void)
{
    unsigned int i;

    handle_count = MK_FP(_psp, 0x32);   /* handle count at PSP:32h */
    handle_ptr = MK_FP(_psp, 0x34);     /* table ptr at PSP:34h */
    for (i = 0; i < *handle_count; i++) /* relocate exiting table */
        handle_table[i] = (*handle_ptr)[i];
    for (i = *handle_count; i < TABLE_SIZE; i++)    /* init. rest */
        handle_table[i] = 255;
    *handle_ptr = handle_table;         /* set pointer to new table */
    *handle_count = TABLE_SIZE;         /* set new table size */
}   /*  relocate()  */

/*********************************************************************/
void main(void)
{
    int c, h;

    relocate();

    c = 0;
    while ((h = open("CON", O_RDONLY)) >= 0)    /* DOS closes files */
    {
        c++;                                    /* on exit, so I    */
        printf("handle = %d\n", h);             /* don't bother     */
    }                                           /* saving handles   */
    printf("total opened files = %d\n", c);
}   /*  255files.c  */
