#include <string.h>
#include <stdlib.h>
#include <dos.h>

#pragma pack(1)

struct PSP {                        /* Must be byte aligned       */
      unsigned    Int20,
                  MemTop;
      char        r0;
      char        Jmp05[5];
      void far *  OldInt22;
      void far *  OldInt23;
      void far *  OldInt24;
      unsigned    OldPSPSeg;
      char        r1[0x14];
      unsigned    EnvSeg;
      char        r2[0x2e];
      struct {
            unsigned char     drive;
            unsigned char     fname[8];
            unsigned char     fext[3];
            int               curr_block;
            int               rec_size;
            long              file_size;
            unsigned int      date;
            unsigned int      time;
            char              r3[8];
            unsigned char     curr_rec;
            long              rand_rec;
            } fcb[2];
      char        dta[128];
};

extern char **environ;

int _cdecl read_envars(void);

#define NUL '\0'
#define SUCCESS 0

typedef enum {ERROR = -1, FALSE, TRUE} LOGICAL;

char **environ = NULL;

extern unsigned   _psp;
extern unsigned   aenvseg;

static int        no_envars;
static LOGICAL    registered = FALSE;
static size_t     envsize;

/*
**  A structure is used here since realloc'ed environment block copies
**  may not reside on paragraph boundries. Therefore to realloc or free,
**  the buffer address must be saved while the environment block is
**  paragraph aligned.
*/

struct ENV {
      char *buf;
      char *block;
      };

static struct ENV my_env = {NULL, NULL};

/*
**  new_env_block()
**
**  Function to resize the environment block copy. When done,
**  my_env.block will point to a paragraph-aligned buffer of
**  sufficient size. ERROR indicate realloc() failed.
**
**  Parameters: 1 - Size of new environment block
**
**  Returns: SUCCESS or ERROR
**
**  Side effect & Notes:
**
**  Calls malloc() to resize/allocate the environment, then
**  copies the old to the new, aligning the new on a paragraph
**  boundry and setting the fields of the my_env struct
**  accordingly.
*/

static LOGICAL _near _pascal new_env_block(envsize)
{
      char *p1, *p2;
      unsigned i;
      struct ENV old_env;
      char far *fp;


      if (NULL == (p1 = malloc(envsize + 18)))
            return ERROR;
      else  old_env = my_env;
      my_env.buf = p1;
      fp = (char far *)my_env.buf;  /* Locate on a segment boundry      */
      fp = _farptr_norm(fp);
      if (0 != (i = FP_OFF(fp)))
            my_env.block = &my_env.buf[16 - i];
      else  my_env.block = my_env.buf;
      if (old_env.buf)
      {
            p1 = my_env.block;
            p2 = old_env.block;
            i = 0;
            while (*p2)
            {     size_t len;

                  strcpy(p1, p2);
                  len = strlen(p2) + 1;
                  environ[i++] = p1;
                  p2 += len;
                  p1 += len;
            }
            *p1 = NUL;
            environ[i++] = p1;
            if (old_env.buf && (old_env.buf != my_env.buf))
                  free(old_env.buf);
      }
      return SUCCESS;
}

/*
**  fstrlen()
**
**  Universal strlen() replacement using far char pointers
**
**  Parameters: 1 - Far pointer to char array
**
**  Returns: Length of character array
*/

#if SPTR
size_t _near _pascal fstrlen(const char far *str)
{
      size_t i;

      for (i = 0; i < 0xffff && *str; ++i, ++str) ;
      return i;
}
#else
 #define fstrlen(s) strlen(s)
#endif

/*
**  strfcpy()
**
**  Universal strcpy() replacement using far char pointers
**
**  Parameters: 1 - Pointer to target char array
**              2 - Far pointer to source char array
**
**  Returns: Pointer to target char array
*/

#if SPTR
char * _near _pascal strfcpy(char *to, const char far *from)
{
      char *target = to;

      do
      {     *to++ = *from;
      } while (*from++);
      return target;
}
#else
 #define strfcpy(s1,s2) strcpy(s1,s2)
#endif

/*
**  read_envars()
**
**  Reads environment variables into a global array.
**
**  Parameters: None
**
**  Returns: SUCCESS or ERROR if realloc() failed
**
**  Side effects: 1 - Calls realloc() to resize environ array.
**                2 - (S, T, M models) Builds a new copy of
**                    the environment accessible using near
**                    pointers.
*/

int _cdecl read_envars(void)
{
      int i;
      size_t envarsize;
      char far *envptr, far *from;
      char *to;

      /* Get the number of envars & the size of the env block           */

      if (environ)
            return SUCCESS;
      envptr = MK_FP(aenvseg, 0);
      for (no_envars = 0, envsize = 0, from = envptr;
            0 != (envarsize = fstrlen(from)); ++no_envars)
      {
            from += envarsize + 1;
            envsize += envarsize + 1;
      }
      ++no_envars;
      ++envsize;

      /* Point environ at a suitably-sized area             */

      if (NULL == (environ = realloc(environ, (no_envars + 2) *
            sizeof(char *))))
                  return ERROR;
      if (ERROR == new_env_block(envsize))
      {     free(environ);
            environ = NULL;
            return ERROR;
      }
      for (i = 0, from = envptr, to = my_env.block; i < no_envars; ++i)
      {     strfcpy(to, from);
            environ[i] = to;
            to = &to[1 + strlen(to)];
            while (*from++) ;
      }
      environ[no_envars + 1] = NULL;
      return SUCCESS;
}
