/********************************************************************
          The McGill Super-Duper Random Number Generator
             G. Marsaglia, K. Ananthanarayana, N. Paul
  
    Incorporating the Ziggurat method of sampling from decreasing
              or symmetric unimodal density functions.
                      G. Marsaglia, W.W. Tsang
  
                 Rewritten into C by E. Schneider
 *********************************************************************/
  
 static unsigned long mcgn, srgn;
  
 #define MULT 69069L
  
 void rstart (i1, i2)
 long i1, i2;
  
 { mcgn = (i1 == 0) ? 0 : i1 | 1;
   srgn = (i2 == 0) ? 0 : (i2 & 0x7FF) | 1;
  }
  
 long uni()
 { unsigned long r0, r1;
   r0 = (srgn >> 15);
   r1 = srgn ^ r0;
   r0 = (r1 << 17);
   srgn = r0 ^ r1;
   mcgn = MULT * mcgn;
   r1 = mcgn ^ srgn;
   return (r1 >> 1);  }
  
 long vni()
 { unsigned long r0, r1;
   r0 = (srgn >> 15);
   r1 = srgn ^ r0;
   r0 = (r1 << 17);
   srgn = r0 ^ r1;
   mcgn = MULT * mcgn;
   r1 = mcgn ^ srgn;
   return r1;  }
/* 
"Anyone who consider arithmetic means of producing random number is,
 of course, in a state of sin" - John Von Neumann
*/
