/*
** POPDIAL.C
**
** QC 2.0
*/

#include <dos.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <string.h>

#define TEST

#define NOINT 0x01
#define MSI 0x00
#define THRI 0x02
#define RDAI 0x04
#define RCLS 0x06
#define INT14 0x14
#define CTRL_C 3
#define COM1 0
#define COM2 1
#define BAUD_300 2
#define BAUD_600 3
#define BAUD_1200 4
#define BAUD_2400 5
#define BAUD_4800 6
#define BAUD_9600 7
#define ODD 1
#define NONE 2
#define EVEN 3
#define STOP_1 0
#define STOP_2 1
#define BITS_7 2
#define BITS_8 3
#define _CRET 0x0d

#define COMINT_VEC 12                   /* Comm vector interrupt number */
#define COMBUF_SIZE 10240               /* Communications buffer size */
#define IIR     0x3fa                   /* Interrupt Indentification Register */
#define LCR     0x3fb                   /* Line Control Register */
#define MCR     0x3fc                   /* Modem Control Register */
#define MSR     0x3fe                   /* Modem Status Register */
#define LSR     0x3fd                   /* Line Status Register */
#ifdef skip
#define IOR     0x3f8                   /* Communications I/O Register */
#define IER     0x3f9                   /* Interrupt Enable Register */
#define RX_BUFFER 0x3f8                 /* RX buffer (register) */
#endif
#define INTA00  0x20                    /* 8259 Comm board COM1 Register 0 */
#define INTA01  0x21                    /* 8259 Comm board COM1 Register 1 */
#define IMR     0x21                    /* 8259 Interrupt Mask Register */
#define EOI 0x20                        /* 8259 End of Interrupt */
#define peek( addr )        (*(unsigned char far *)addr)

struct regval { unsigned int ax,bx,cx,dx,si,di,ds,es; } ;

                /* External Declaractions */

char combuf[COMBUF_SIZE];       /* Communications buffer filled by comint */
int cptr,                       /* Index into commuications buffer */
    head,                       /* Current head of commuications buffer */
    popflag,                   /* Online status flag */
    dialflag;
int hotflag;
int hotTimer;
int ticker;
unsigned char bite;

int IOR,IER,RX_BUFFER;  /*  ints for defines as test */
int val_array[] = { 0x3f8,0x3f9,0x3f8 };
/* End of test */
union REGS registers;

/* Stack and pointer checking off */
#pragma check_stack( off )
#pragma check_pointer( off )

static char dialstring[] = "ATDT5358931";
static char dropstring[] = "+++~~ATH";
static int kbval;
unsigned scancode[] = { 56 , 32 };
static unsigned old_IMR, old_IER, old_MCR;

/* Prototypes for interrupt functions */
void (interrupt far *oldkey)( void );
void interrupt far newkey( void );
void (interrupt far *oldtimer)( void );
void interrupt far newtimer( void );
void (interrupt far *oldcomm)( void );
void interrupt far newcomm( void );
void (interrupt far *appcomm)( void );

/* Variables that will be accessed inside TSR must be global. */
int  fintimer = FALSE, finvideo = FALSE;
int flag = 0;
int waitflag = 0;
int status,oldbyte,newbyte,cntr,_waitctr;
int byte;
int outbyte;
int inbyte;
int row,col;

char huge *tsrstack;
char huge *appstack;
char huge *tsrbottom;


main()
{
    unsigned tsrsize;
    int r;

    /* Initialize stack and bottom of program. */
    _asm mov  WORD PTR tsrstack[0], sp
    _asm mov  WORD PTR tsrstack[2], ss
    FP_SEG( tsrbottom ) = _psp;
    FP_OFF( tsrbottom ) = 0;

    /* Use 16 paragraph heap (controlled through global in malloc.h). */
    _amblksiz = 256;

    /* Program size is:
     *     top of stack
     *   - bottom of program (converted to paragraphs)
     *   + paragraphs in the heap plus
     *   + one extra paragraph just to be safe
     */
    tsrsize = ((tsrstack - tsrbottom) >> 4) + (_amblksiz >> 4) + 1;

    /* Replace existing timer and video routines with ours. */
    oldkey = _dos_getvect( 0x09 );
    _dos_setvect( 0x09, newkey );
    oldtimer = _dos_getvect( 0x1c );
    _dos_setvect( 0x1c, newtimer );
    oldcomm = _dos_getvect( 0x14 );

    popflag = FALSE;
    hotflag = FALSE;
    hotTimer = 0;

    #ifndef TEST
    /* Free the PSP segment and terminate with program resident. */
    _dos_freemem( _psp );
    _dos_keep( 0, tsrsize );
    #endif
    #ifdef TEST
    popdial();
    #endif

}

void interrupt far newkey()
{
        if (!hotflag)
        {
                if (inp(0x60) == scancode[0])
                {
                        hotflag = TRUE;
                }
        }
        if ( hotflag )
        {
                if (inp(0x60) == scancode[1])
                {
                        /* --- reset the keyboard ---- */
                        kbval = inp(0x61);
                        outp(0x61, kbval | 0x80);
                        outp(0x61, kbval);
                        _disable();
                        outp(0x20, 0x20);
                        _enable();
                        /* ---- set hotkey indicator ---- */
                        popflag = TRUE;
                        hotflag = FALSE;
                        return;
                }
                else
                        if (inp(0x60) != scancode[0])
                                hotflag = FALSE;
        }
        _chain_intr( oldkey );
}

void interrupt far newtimer()
{
        (*oldtimer)();
        if ( popflag )
        {
                popflag = FALSE;
                outp( 0x20 , 0x20 );
                popdial();

        }
        else
        {
                if ( hotflag )
                {
                        if ( hotTimer++ == 11 )
                        {
                                hotflag = FALSE;
                                hotTimer = 0;
                        }
                }
                if( waitflag )
                {
                        if( _waitctr == 540 )
                                dialflag = FALSE;
                        else
                                _waitctr++;
                }
        }
}

popdial()
{
        _disable();
        _asm \
        {
                mov  WORD PTR appstack[0], sp   ; Save current stack
                mov  WORD PTR appstack[2], ss
                mov  sp, WORD PTR tsrstack[0]   ; Load new stack
                mov  ss, WORD PTR tsrstack[2]
        }
        _enable();
        byte = 0x00;
        dialflag = TRUE;
        popflag = FALSE;
        pause();
        setcom();
        for( ticker = 0; ticker < strlen( dialstring ); ticker++ )
        {
                outbyte = dialstring[ticker];
RETRY1:
                pause();
                status = ( 0x20 & inp( LSR ));
                if( status != 0x20 )
                        goto RETRY1 ;
                outp( IOR, outbyte );
                pause();
                inbyte = inp( IOR );
        }
RETRY2:
        pause();
        status = ( 0x20 & inp( LSR ));
        if( status != 0x20 )
                goto RETRY2 ;
        outp( IOR, _CRET );
        pause();
        inbyte = inp( IOR );
        _waitctr = 0;
        waitflag = TRUE;
        while( dialflag )
        {
WAIT1:
                pause();
                byte = ( inp( MSR ) & 0x80 );
                if( byte != 0x80 )
                        goto WAIT1;
                else
                {
                        inbyte = inp( IOR );
                        dialflag = FALSE;
                        waitflag = FALSE;
                }
        }
        if( waitflag )
                hangup();
        _disable();
        rstcom();
        _asm \
        {
                mov  sp, WORD PTR appstack[0]
                mov  ss, WORD PTR appstack[2]
        }
        _enable();
}

pause()
{
        for( cntr = 0; cntr < 1 ; cntr++ )
                flag = TRUE;
}

hangup()
{
        for( ticker = 0; ticker < strlen( dropstring ); ticker++ )
        {
                outbyte = dropstring[ticker];
DROP1:
                pause();
                status = ( 0x20 & inp( LSR ));
                if( status != 0x20 )
                        goto DROP1 ;
                outp( IOR, outbyte );
                pause();
                inbyte = inp( IOR );
        }
DROP2:
        pause();
        status = ( 0x20 & inp( LSR ));
        if( status != 0x20 )
                goto DROP2 ;
        outp( IOR, _CRET );
        pause();
        inbyte = inp( IOR );
        popflag = TRUE;
        _disable();
        rstcom();
        _asm \
        {
                mov  sp, WORD PTR appstack[0]
                mov  ss, WORD PTR appstack[2]
        }
        _enable();
}

setcom()
{
        _disable();
        old_IMR = inp(INTA01);
        bite = (0x10 | old_IMR);
        outp(INTA01, bite);                     /* disallow COM1 ints */
        old_IER = inp( IER );
        bite = ( old_IER & 0xf0 );
        outp( IER, bite );
        old_MCR = inp( MCR );
        bite = ( old_MCR & 0x03 );
        outp( MCR, bite );
        bite = inp(MSR);                    /* Clear Modem Status Reg */
        bite = inp(LSR);                    /* Clear Line Status Reg */
        bite = inp(val_array[0]);                   /* Clear I/O Register */
        bite = inp(LCR);
        bite &= 0x7f;
        outp(LCR, bite);                    /* Set DLAB to 0 */
        outp( IOR, 0x00 );
        _enable();
}

rstcom()
{
LOOP:
        bite = inp(val_array[0]);                   /* Clear I/O Register */
        bite = inp(LSR);                    /* Clear Line Status Reg */
        if( (bite & 0x01) == 0x01 )
                goto LOOP;

        bite = inp(MSR);                    /* Clear Modem Status Reg */
        outp( MCR, old_MCR );
        outp( IER, old_IER );
        outp(INTA01, old_IMR );
        outp( IOR, _CRET );
}


static void error_exit    (int errnum);
/* error message table */
static char *error_text[]= {
    NULL,                               /* errnum =  0, no error            */
    NULL,                               /* errnum == 1, windowing error */
    "Syntax:  CXLDEMO [-switches]\n\n"
        "\t -c = CGA snow reduction\n"
        "\t -b = BIOS screen writing\n"
        "\t -m = force monochrome text attributes",
    "Memory allocation error"
};

/*---------------------------------------------------------------------------*/
/* this function handles abnormal termination.  If it is passed an  */
/* error code of 1, then it is a windowing system error.  Otherwise */
/* the error message is looked up in the error message table.       */

static void error_exit(int errnum)
{
    if(errnum) {
        printf("\n%s\n",(errnum==1)?werrmsg():error_text[errnum]);
        exit(errnum);
    }
}
