/*
**  MOUSE.C by Doug Boone
*/

#include <dos.h>
#include <stdio.h>
#include <conio.h>

int     init_mouse(void);
void    button_release(int);
int     button_press(void);

/* initialize the mouse, return 0 for no mouse */
/* or the number of buttons on mouse           */

int init_mouse(void)   /* initialize the mouse driver */
{
        union REGS inregs;

        inregs.x.ax = 0;
        int86(0x33,&inregs,&inregs);
        if (inregs.x.ax)
                return(inregs.x.bx);
        return(0);
}

/* Wait for the mouse to be released. Not many people can release */
/* buttons quickly enough for their computer so you have to wait  */

void button_release(int which)
{
        union REGS inregs;

        do
        {       inregs.x.ax = 6;
                inregs.x.bx = 1 << which;
                int86(0x33,&inregs,&inregs);
        } while (inregs.x.ax & (1 << which));
}

int button_press(void)
{
        union REGS inregs;

        inregs.x.ax = 3;    /* you can also get the mouse position... */
        int86(0x33,&inregs,&inregs);

        if (inregs.x.bx == 0)                   /* no buttons pressed */
                return(0);

        if (inregs.x.bx & 0x0001)               /* left button pushed */
        {       button_release(0);
                return(1);
        }

        else if (inregs.x.bx & 0x0002)         /* right button pushed */
        {       button_release(1);
                return(2);
        }
        else if (inregs.x.bx & 0x0003)        /* center button pushed */
        {       button_release(2);
                return(1);
        }
        else    return(-1);                  /* an error has occured? */
}

int main(void)
{
        int  buttons;

        if ((buttons = init_mouse()) > 0)
                printf("\n Your mouse has %d buttons on it. \n",buttons);
        else
        {       printf("\n\a You don't have a mouse, or it isn't ");
                printf("installed. Fix that before running again.\n");
                exit(1);
        }

        printf("\n Press any key to exit \n");
        while (!kbhit())  /* This is the only statement that may not  */
                          /* work on any compiler. kbhit() isn't ANSI */
                          /* but most compilers support it.           */
        {
                switch(button_press())
                {
                case 1:    cputs("\n\rLeft button pressed"); break;
                case 2:    cputs("\n\rRight button pressed"); break;
                case 3:    cputs("\n\rCenter button pressed"); break;
                case -1:   cputs("\n\rMouse error reported"); break;
                }
        }
        cputs("\n\r\n\r Done!\n\r");
        exit(0);
}
