/*
** GETDCWD.C - returns the current working directory for a specific drive
**
** for ZTC/C++ by Bob Jarvis
*/

#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

char *getdcwd(unsigned int drive)   /* 0 = current, 1 = A, 2 = B, etc */
{
        union REGS regs;
        struct SREGS sregs;
        char *retptr;

        retptr = malloc(67);
        if(retptr == NULL)
                return NULL;

        if(drive == 0)    /* figure out which drive is current */
        {
                dos_getdrive(&drive);
                drive += 1;
        }

        *retptr = (drive-1) + 'A';
        *(retptr+1) = ':';
        *(retptr+2) = '\\';

        regs.h.ah = 0x47;
        regs.h.dl = drive;

#if SPTR
        sregs.ds = getDS();
        regs.x.si = (unsigned)retptr+3;
#else
        sregs.ds = FP_SEG(retptr);
        regs.x.si = FP_OFF(retptr)+3;
#endif

        intdosx(&regs, &regs, &sregs);
        if(regs.x.ax == 15)     /* drive number invalid */
        {
                free(retptr);
                return NULL;
        }
        else    return retptr;
}

main(int argc, char *argv[])
{
        char *curpath;
        unsigned int n;

        if(argc > 1)
                n = (tolower(*argv[1]) - 'a') + 1;
        else    dos_getdrive(&n);

        curpath = getdcwd(n);

        printf("curpath = '%s'\n", curpath);
}
