/*
** By: John Navas 
** 
** Microsoft C v5.0 and QuickC include an alloca() library function,
** which allocates temporary storage from the stack.
** 
** The following function does the same job in Turbo C (tested in
** Version 1.5):
*/

#include <stdio.h>

typedef unsigned WORD;

char *alloca(WORD siz)          /* LOCAL STACK ALLOCATION IN TURBO C */
{
#if defined(__TINY__) || defined(__SMALL__) || defined(__COMPACT__)
    extern WORD __brklvl;           /* stack check */
#endif
    static WORD len;                /* length rounded to words */
    static int(*volatile rtn)();    /* return address */
    static WORD volatile bp;        /* saved value of bp */
 
    if (_SP > (len = siz+1&~1)  /* stack check in words */
#if defined(__TINY__) || defined(__SMALL__) || defined(__COMPACT__)
    && __brklvl < _SP-len
#endif
    ) {
        rtn = *(int(**)())((char*)&siz-sizeof(int(*)()));
        bp = *(WORD*)((char*)&siz-sizeof(int(*)())-sizeof(WORD));
        _SP -= len;
        _BP -= len;
        *(int(**)())((char*)&siz-sizeof(int(*)())) = rtn;
        *(WORD*)((char*)&siz-sizeof(int(*)())-sizeof(WORD)) = bp;
        return (char*)(&siz+1);
    }
    return 0;
}
 
void main()
{
    char *p = alloca(80);

    printf("sp = %u\np  = %p\n", _SP, p);
}
