
067/118 14 Jul 89 23:08:31
From:   Walter Bright
To:     All
Subj:   Interrupt Handlers in C
Attr:   
------------------------------------------------
From: bright@Data-IO.COM (Walter Bright)
Date: 13 Jul 89 01:39:18 GMT
Organization: Data I/O Corporation; Redmond, WA
Message-ID: <2046@dataio.Data-IO.COM>
Newsgroups: comp.lang.c

In article <3607@cps3xx.UUCP> usenet@cps3xx.UUCP (Usenet file owner) writes:
>Below is a short piece of code written for Microsoft C 5.1 which illustrates
>how easy it is to  write interrupt routines in C, despite what the other
>poster said.
>I must admit that I have not had the opportunity to use Turbo C or
>Zortech C.

I couldn't resist the challenge. I wrote a Zortech C version.
Compare for yourselves.

---------- ZTC --------------------
/* To compile test program:
 *      ZTC int -D
 */

#include <int.h>

static unsigned int ticker = 0;

#define timeup() (ticker==0)
#define timerset(tenths) ticker=(unsigned int)((long)tenths*182L/100L+1L)
#define TIMER     0x1c

static int newtimer(struct INT_DATA *pd)
    {
    if (ticker)
        --ticker;
    return 0;      /* call old timer ISR */
    }

void sleep(int seconds)
        {
        int_intercept(TIMER,newtimer,256);
        when = timerset (seconds * 10);
        while (!timeup())
            ;
        int_restore(TIMER);
        }

#if DEBUG
#include <stdio.h>
main()
    {
    char input[100];
    int val;
    long when;
    
    printf ("Enter delay amount in 1/10 seconds: ");
    gets (input);
    val = atoi (input);

    int_intercept(TIMER,newtimer,256);
    when = timerset (val);
    while (!timeup())
        ;
    int_restore(TIMER);
    }
#endif

------------ MSC ------------------
#include <stdio.h>
#include <dos.h>

static void intercept_timer(void);
static void restore_timer(void);
static void interrupt far newtimer (void);
static void (interrupt far *oldtimer)(void);
static unsigned int ticker = 0;

#define timeup() (ticker==0)
#define timerset(tenths) ticker=(unsigned int)((long)tenths*182L/100L+1L)
#define TIMER     0x1c

#define getvect _dos_getvect
#define setvect _dos_setvect

static void intercept_timer (void)
    {
    if (oldtimer == NULL)
        {
        oldtimer = getvect(TIMER);
        setvect (TIMER, newtimer);
        }
    }

static void restore_timer(void)
    {
    if (oldtimer)
        setvect(TIMER, oldtimer);
    oldtimer = NULL;
    }

static void interrupt far newtimer()
    {
    (*oldtimer)();      /* call old timer ISR */
    if (ticker)
        --ticker;
    }

void sleep(int seconds)
        {
        intercept_timer ();
        timerset (seconds * 10);
        while ( ! timeup())
                ;
        restore_timer ();
        }



#if DEBUG
#include <stdio.h>
main()
    {
    char input[100];
    int val;
    long when;
    
    printf ("Enter delay amount in 1/10 seconds: ");
    gets (input);
    val = atoi (input);

    intercept_timer();
    when = timerset (val);
    while (!timeup (when))
        ;
    restore_timer();
    }
#endif
---------------------------------
e


--- QM v1.00
 * Origin: urchin (1:106/889.5)

