unsigned int *screen;    /* pointer to screen memory */
unsigned int vbase;      /* segment of video base */
unsigned int maxx;       /* number of columns */
unsigned int maxy;       /* number of rows */
union REGS r;
struct SREGS sr;
int vmode = 0;

/* get display mode */

r.h.ah = 0x0f;
int86(0x10,&r,&r);

vmode = r.h.al;

/* guess what!?
   it returns the number of columns too! */

if (maxx == 0)
        maxx = (int) r.h.ah;

/* number of rows is harder */

if (maxy == 0)
{
        /* try using a ega/vga function */

        r.x.ax = 0x1130;
        r.x.dx = maxy;
        int86(0x10,&r,&r);

        /* if it fails, it returns 0, so we set
           the screen to 25 lines, otherwise
           it returns the actual number of lines
           of text on the screen */

        maxy = (r.x.dx == 0) ? 25 : (r.x.dx + 1);
}

if (vbase == 0)

        /* if you are in mode 7 the video is
           most likely based at 0xB000, otherwise
           it will be at 0xB800.  This fails for
           a small number of cards, like the
           genius mono displays (although, i've
           never had a failure reported... */

        if (vmode == 0x07)
                vbase = 0xb000;
        else    vbase = 0xb800;

r.h.ah = 0xfe;
sr.es = vbase;

/* if we are running desqview or topview,
   this function returns the segment of a video
   buffer to use, otherwise it returns the
   value in es unchanged */

r.x.di = 0;
int86x(0x10,&r,&r,&sr);

desqview = (vbase != sr.es);
vbase = sr.es;

/* make my screen pointer */

screen = (unsigned int *) MK_FP(vbase,r.x.di);

/*

incidentally, if you are in a vmode<7 and the number of
screen lines is greater than 25, it means you are in
43/50 line mode and should either remain there or reset
it when you get done.

jim nutt
'the computer handyman'

*/
