/*
** Here is a version of Shell sort that is compatible with qsort() 
** and about as tight and fast as you're going to get in C.
*/

/*
** ssort()  --  Shell sort   R. Gardner   public domain   5/90
*/

ssort (base, nel, width, comp)
char *base;
unsigned int nel, width;
int (*comp)();
{
   unsigned int wnel, gap, wgap, i, j, k;
   char *a, *b, tmp;

   wnel = width * nel;
   for ( gap = 0; ++gap < nel; )
      gap *= 3;
   while ( gap /= 3 ) {
      wgap = width * gap;
      for ( i = wgap; i < wnel; i += width ) {
         for ( j = i - wgap; ;j -= wgap ) {
            a = j + base;
            b = a + wgap;
            if ( (*comp)(a, b) <= 0 )
               break;
            k = width;
            do {
               tmp = *a;
               *a++ = *b;
               *b++ = tmp;
            } while ( --k );
            if ( j < wgap )
               break;
         }
      }
   }
}
