/* code to disable <Ctrl><Alt><Del>.                                */

#include <dos.h>

#define CTRLALT        (0x08|0x04) /* bit flags set in kbstat()     */
#define DELSCAN        0x53        /* keyboard scan code for <Del>  */
#define KEYPORT        0x60        /* keyboard scan code port       */
#define CONTROLLERPORT 0x20        /* interrupt controller port     */
#define kbstat()       peekb(0,0x417)  /* BIOS data area - kb flags */

#define keyport()      inportb(KEYPORT)
        /* macro that returns the scancode of the key that caused   */
        /* the interrupt                                            */

#define install()      (oldkbisr=getvect(0x09),setvect(0x09,newkbisr))
        /* installation macro, installs newkbisr() in the keyboard  */
        /* interrupt chain                                          */

#define remove()       setvect(0x09,oldkbisr)
        /* removal macro, call to remove newkbisr() from interrupt  */
        /* chain.  oldkbisr()  must be removed before program ends  */

void interrupt (*oldkbisr)(void);  /* address of old keyboard ISR   */

void interrupt newkbisr(void)
{
   if((keyport()==DELSCAN)&&(kbstat()&CTRLALT))
   {
       char kbin=inportb(KEYPORT+1);  /* reset keyboard */
       outportb(KEYPORT+1,kbin|0x80);
       outportb(KEYPORT+1,kbin);
       disable();
       outportb(CONTROLLERPORT,0x20); /* tell controller to shut up */
       enable();
   }
   else
      oldkbisr();  /* chain to old keyboard isr */
}
