/*
** LSD - A simple directory lister
** A public domain C demo program by Bob Stout
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/* For portability, make everything look like MSC 6 */

#ifdef __ZTC__
 #include <mflfiles.h>  /* ZTC doesn't do recursive find first/next...  */
 #include <msport.h>    /* ...so use MFLZT library functions            */
#elif defined(__TURBOC__)
 #include <dir.h>
 #define _dos_findfirst(f,a,b) findfirst(f,b,a)
 #define find_t ffblk
 #define _A_SUBDIR FA_DIREC
 #define attrib ff_attrib
 #define name ff_name
 #define size ff_size
 #define wr_time ff_time
 #define wr_date ff_date
#else                   /* assume MSC/QC                                */
 #include <dos.h>
 #include <errno.h>
#endif

#ifndef SUCCESS
 #define SUCCESS 0
#endif

#ifndef __ZTC__         /* these are included with mflfiles.h           */
 #ifdef TRUE
  #undef TRUE
 #endif
 #ifdef FALSE
  #undef FALSE
 #endif
 #ifdef ERROR
  #undef ERROR
 #endif
 enum LOGICAL {FALSE, TRUE};
#endif

#ifndef CAST
 #define CAST(new_type,old_object) (*((new_type *)&(old_object)))
#endif
 
struct DOS_TIME {
        unsigned int ss : 5;
        unsigned int mm : 6;
        unsigned int hh : 5;
        } ;
#define dos_time(t) CAST(struct DOS_TIME, (t))

struct DOS_DATE {
        unsigned int da : 5;
        unsigned int mo : 4;
        unsigned int yr : 7;
        } ;
#define dos_date(t) CAST(struct DOS_DATE, (t))

main(int argc, char *argv[])
{
        int i, files = 0, dirs = 0, argptr = 0, errflag = FALSE, cols;
        long siz_tot = 0L;
        char *p, *fname, *ext, name[13], buf[67], numbuf[12];
        struct find_t ff;
        struct diskfree_t df;
        int one_column(), five_column(), (*display)() = one_column;
        char *sprintfc(char *, long);

        strcpy(buf, fname = "*.*");
        if(argc != 1)   for (i = 1; i < argc; ++i)
        {
                if ('/' == argv[i][0])
                {
                        if ('W' == toupper(argv[i][1]))
                                display = five_column;
                        else
                        {
                                puts("\aUsage: LSD [/W] [file]");
                                errflag = TRUE;
                        }
                }
                else    if (!argptr)    argptr = i;
        }
        if (argptr)
        {
                fname = argv[argptr];
                if (!(_dos_findfirst(fname, _A_SUBDIR, &ff)))
                {
                        if (ff.attrib & _A_SUBDIR)
                                strcat(strcpy(buf, fname), "\\*.*");
                        else    strcpy(buf, fname);
                }
                else    errflag = TRUE;
        }
        if (!errflag && !(_dos_findfirst(buf, 0xff, &ff))) do
        {
                siz_tot += ff.size;
                if (ff.attrib & _A_SUBDIR)
                        ++dirs;
                else    ++files;
                strcpy(name, ff.name);
                if (NULL != (p = strchr(name, '.')) && p != name)
                {
                        *p  = '\0';
                        ext = ++p;
                }
                else    ext = "";
                cols = (*display)(name, ext, ff.size,
                        ff.attrib, ff.wr_date, ff.wr_time);
        } while (SUCCESS == _dos_findnext(&ff));
        else
        {
                fprintf(stderr, "Cannot do directory on '%s'\n", fname);
                exit(-1);
        }
        if (cols)
                fputc('\n', stdout);
        sprintfc(numbuf,siz_tot);
        printf("\n%3d Files totalling %s bytes\n", files, numbuf);
        printf("%3d Director%s\n", dirs, (1 == dirs) ? "y" : "ies");
        _dos_getdiskfree(0, &df);
        sprintfc(numbuf, (long)df.avail_clusters * df.sectors_per_cluster *
                df.bytes_per_sector);
        printf("%s bytes free\n", numbuf);
        exit(0);
}

int one_column(char    *name,
               char    *ext,
               long     size,
               unsigned attribs,
               unsigned date,
               unsigned time)
{
        register int i, mask;
        static char *atr = "RHSVDA";

        printf("%-8s %-3s %9ld  ", name, ext, size);
        for (i = 0, mask = 1; i < 6; ++i, mask <<= 1)
                if (attribs & mask)
                        fputc(atr[i], stdout);
                else    fputc('.'   , stdout);
        printf("%4d-%02d-%02d%4d:%02d:%02d\n",
                dos_date(date).mo,
                dos_date(date).da,
                (dos_date(date).yr + 80) % 100,
                dos_time(time).hh,
                dos_time(time).mm,
                dos_time(time).ss);
        return 0;
}

int five_column(char    *name,
                char    *ext,
                long     size,
                unsigned attribs,
                unsigned date,
                unsigned time)
{
        static int cols = 0;

        printf("%-8s %-3s%s", name, ext, (5 > ++cols) ? "    " : "");
        if (0 == (cols %= 5))
                putchar('\n');
        return (cols);
}

char *sprintfc(char *string, long num)
{
        if (num > 999999L)
                sprintf(string, "%d,%03d,%03d",
                        (int)(num / 1000000L),
                        (int)((num % 1000000L) / 1000L),
                        (int)(num % 1000L));
        else
        {
                if (num > 999L)
                        sprintf(string, "%d,%03d",
                                (int)(num / 1000L),
                                (int)(num % 1000L));
                else sprintf(string, "%d", (int)num);
        }
        return string;
}
