/*
**  large bit array operations by Scott Dudley
*/

#include <limits.h>

#define BitOff(a,x) ((void)((a)[(x)/CHAR_BIT] &= ~(1 << ((x) % CHAR_BIT))))
#define BitOn(a,x)  ((void)((a)[(x)/CHAR_BIT] |= (1 << ((x) % CHAR_BIT))))
#define IsBit(a,x)  ((a)[(x)/CHAR_BIT] & (1 << ((x) % CHAR_BIT)))

#include <stdio.h>

main()
{
        char array[64];

        memset(array,'\0',sizeof(array));

        BitOn(array,5);
        BitOn(array,12);
        BitOn(array,500);

        if (IsBit(array,5) && IsBit(array,12) && IsBit(array,500))
                puts("These functions seemed to work!");
        else puts("Something's broken here!");
}
